/*
 * Decompiled with CFR 0.152.
 */
package tigase.conf;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;
import tigase.TestLogger;
import tigase.conf.ConfigReader;
import tigase.conf.ConfigWriter;
import tigase.kernel.beans.config.AbstractBeanConfigurator;
import tigase.server.xmppclient.ClientConnectionManager;
import tigase.server.xmppserver.S2SConnectionManager;

public class ConfigReaderTest {
    private static final Logger log = TestLogger.getLogger(ConfigReaderTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test1() throws Exception {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("test123", "2313");
        root.put("tes22", "223");
        root.put("x-gy+=x", 123);
        root.put("env-1", new ConfigReader.EnvironmentVariable("PATH", null));
        root.put("env-2", new ConfigReader.EnvironmentVariable("test-1", null));
        root.put("env-3", new ConfigReader.EnvironmentVariable("test-2", "test"));
        root.put("prop-1", new ConfigReader.PropertyVariable("java.vendor", null));
        root.put("prop-2", new ConfigReader.PropertyVariable("java.version", "-1"));
        ConfigReader.CompositeVariable compositeVariable = new ConfigReader.CompositeVariable();
        compositeVariable.add((Object)"Java: ");
        compositeVariable.add('+', (Object)new ConfigReader.PropertyVariable("java.vendor", null));
        compositeVariable.add('+', (Object)" ");
        compositeVariable.add('+', (Object)new ConfigReader.PropertyVariable("java.version", null));
        root.put("comp-prop1", compositeVariable);
        compositeVariable = new ConfigReader.CompositeVariable();
        compositeVariable.add((Object)5);
        compositeVariable.add('-', (Object)2);
        compositeVariable.add('*', (Object)60);
        compositeVariable.add('*', (Object)1000);
        root.put("comp-prop2", compositeVariable);
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new ConfigReader.EnvironmentVariable("USER", null));
        root.put("env-list", list);
        list = new ArrayList();
        list.add(1);
        list.add(3);
        root.put("some-list", list);
        list = new ArrayList();
        list.add("1");
        list.add("3");
        root.put("some-list-2", list);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ala-ma-kota", true);
        map.put("test", "false");
        root.put("some-map", map);
        root.put("for-null", null);
        HashMap<String, Constable> embeddedMap = new HashMap<String, Constable>();
        embeddedMap.put("test", Integer.valueOf(123));
        embeddedMap.put("other", Boolean.valueOf(true));
        map = new HashMap();
        map.put("simple", "text");
        map.put("integer", 1);
        map.put("long", 2L);
        map.put("double", 2.0);
        list = new ArrayList();
        list.add(1);
        list.add(embeddedMap);
        list.add("3");
        map.put("embedded-list", list);
        map.put("embedded-map", embeddedMap);
        root.put("another-map", map);
        AbstractBeanConfigurator.BeanDefinition b1 = new AbstractBeanConfigurator.BeanDefinition();
        b1.setBeanName("s2s");
        b1.setClazzName(S2SConnectionManager.class.getCanonicalName());
        b1.put((Object)"list", new ArrayList(list));
        b1.put((Object)"map", new HashMap(embeddedMap));
        b1.put((Object)"some", (Object)true);
        b1.put((Object)"other", (Object)123);
        b1.put((Object)"ala", (Object)"kot");
        AbstractBeanConfigurator.BeanDefinition conns = new AbstractBeanConfigurator.BeanDefinition();
        conns.setBeanName("connections");
        AbstractBeanConfigurator.BeanDefinition port = new AbstractBeanConfigurator.BeanDefinition();
        port.setBeanName("5269");
        conns.put((Object)port.getBeanName(), (Object)port);
        b1.put((Object)conns.getBeanName(), (Object)conns);
        root.put(b1.getBeanName(), b1);
        AbstractBeanConfigurator.BeanDefinition b2 = new AbstractBeanConfigurator.BeanDefinition();
        b2.setBeanName("c2s");
        b2.setClazzName(ClientConnectionManager.class.getCanonicalName());
        b2.setActive(true);
        b2.setExportable(true);
        root.put(b2.getBeanName(), b2);
        AbstractBeanConfigurator.BeanDefinition b3 = new AbstractBeanConfigurator.BeanDefinition();
        b3.setBeanName("upload");
        root.put(b3.getBeanName(), b3);
        Map parsed = null;
        File f = File.createTempFile("xx3232", "ccxx");
        try {
            new ConfigWriter().write(f, root);
            this.displayFile(f);
            parsed = new ConfigReader().read(f);
        }
        finally {
            f.delete();
        }
        f = File.createTempFile("xx3232", "ccxx");
        try {
            new ConfigWriter().write(f, root);
            this.displayFile(f);
        }
        finally {
            f.delete();
        }
        this.assertMapEquals(root, parsed, "/");
        Assert.assertEquals(root, (Object)parsed);
        Assert.assertEquals((Object)System.getenv("PATH"), (Object)((ConfigReader.Variable)root.get("env-1")).calculateValue());
        Assert.assertEquals((Object)System.getenv("test-1"), (Object)((ConfigReader.Variable)root.get("env-2")).calculateValue());
        Assert.assertEquals((Object)Optional.ofNullable(System.getenv("test-2")).orElse("test"), (Object)((ConfigReader.Variable)root.get("env-3")).calculateValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test2() throws Exception {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("--cluster-mode", true);
        props.put("dataSource/repo-uri", "jdbc:postgresql://127.0.0.1/tigase?user=test&password=test&autoCreateUser=true");
        props.put("sess-man/commands/ala-ma-kota", "DOMAIN");
        props.put("c2s/incoming-filters", Arrays.asList("tigase.server.filters.PacketCounter", "tigase.server.filters.PacketCounter"));
        props.put("http/active", "true");
        Map root = ConfigWriter.buildTree(props);
        Map parsed = null;
        File f = File.createTempFile("xx3232", "ccxx");
        try {
            new ConfigWriter().write(f, root);
            this.displayFile(f);
            parsed = new ConfigReader().read(f);
        }
        finally {
            f.delete();
        }
        Assert.assertEquals((Object)root, (Object)parsed);
        Assert.assertEquals(props, (Object)ConfigReader.flatTree((Map)parsed));
    }

    @Test
    public void testReadingListOfItemsWithVariables1() throws IOException, ConfigReader.ConfigException {
        String tmp = "paths = [ '/xxx/yyy/zzz', 'aaa/' + env('HOME') + '/ccc', 'eee/fff/ggg' ]";
        Map data = new ConfigReader().read((Reader)new StringReader(tmp));
        List paths = (List)data.get("paths");
        Assert.assertEquals((long)3L, (long)paths.size());
        Assert.assertEquals((Object)"/xxx/yyy/zzz", (Object)paths.get(0).toString());
        Assert.assertEquals((Object)("aaa/" + System.getenv("HOME") + "/ccc"), (Object)((ConfigReader.Variable)paths.get(1)).calculateValue());
        Assert.assertEquals((Object)"eee/fff/ggg", (Object)paths.get(2).toString());
    }

    @Test
    public void testReadingListOfItemsWithVariables2() throws IOException, ConfigReader.ConfigException {
        String tmp = "paths = [\n'/xxx/yyy/zzz',\n'aaa/' + env('HOME') + '/ccc'\n]";
        Map data = new ConfigReader().read((Reader)new StringReader(tmp));
        List paths = (List)data.get("paths");
        Assert.assertEquals((long)2L, (long)paths.size());
        Assert.assertEquals((Object)"/xxx/yyy/zzz", (Object)paths.get(0).toString());
        Assert.assertEquals((Object)("aaa/" + System.getenv("HOME") + "/ccc"), (Object)((ConfigReader.Variable)paths.get(1)).calculateValue());
    }

    @Test
    public void testReadingListOfItemsWithVariables3() throws IOException, ConfigReader.ConfigException {
        String tmp = "paths = [ 'admin@localhost', '' + env('USER') + '@localhost' ]";
        Map data = new ConfigReader().read((Reader)new StringReader(tmp));
        List paths = (List)data.get("paths");
        Assert.assertEquals((long)2L, (long)paths.size());
        Assert.assertEquals((Object)"admin@localhost", (Object)paths.get(0).toString());
        Assert.assertEquals((Object)("" + System.getenv("USER") + "@localhost"), (Object)((ConfigReader.Variable)paths.get(1)).calculateValue());
    }

    @Test
    public void testReadingNegativeValues() throws IOException, ConfigReader.ConfigException {
        String tmp = Stream.of("sub = 10 - 15", "sub2 = [ 20 - 25 ]", "negative1 = -10", "negative2 = -10l", "negative3 = -10.9d", "negative4 = [ -10 ]").collect(Collectors.joining("\n"));
        Map data = new ConfigReader().read((Reader)new StringReader(tmp));
        int negative1 = (Integer)data.get("negative1");
        Assert.assertEquals((long)-10L, (long)negative1);
        long negative2 = (Long)data.get("negative2");
        Assert.assertEquals((long)-10L, (long)negative2);
        double negative3 = (Double)data.get("negative3");
        Assert.assertEquals((double)-10.9, (double)negative3, (double)0.2);
        List negative4 = (List)data.get("negative4");
        Assert.assertEquals((long)-10L, (long)((Integer)negative4.get(0)).intValue());
        Assert.assertEquals((Object)-5, (Object)((ConfigReader.CompositeVariable)data.get("sub")).calculateValue());
        Assert.assertEquals((Object)-5, (Object)((ConfigReader.CompositeVariable)((List)data.get("sub2")).get(0)).calculateValue());
    }

    private void displayFile(File f) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(f));
        String line = null;
        log.log(Level.FINE, "file content: " + f.getAbsolutePath());
        while ((line = reader.readLine()) != null) {
            log.log(Level.FINE, line);
        }
    }

    private void assertMapEquals(Map<String, Object> expected, Map actual, String prefix) {
        for (Map.Entry<String, Object> e : expected.entrySet()) {
            Object value = actual.get(e.getKey());
            log.log(Level.FINE, "checking key = " + prefix + e.getKey());
            if (e.getValue() == null) {
                Assert.assertNull(value);
                continue;
            }
            Assert.assertEquals((String)("for key " + prefix + e.getKey()), e.getValue().getClass(), value.getClass());
            if (value instanceof AbstractBeanConfigurator.BeanDefinition) {
                AbstractBeanConfigurator.BeanDefinition av = (AbstractBeanConfigurator.BeanDefinition)value;
                AbstractBeanConfigurator.BeanDefinition ev = (AbstractBeanConfigurator.BeanDefinition)e.getValue();
                Assert.assertEquals((Object)ev.getClazzName(), (Object)av.getClazzName());
                Assert.assertEquals((Object)ev.getBeanName(), (Object)av.getBeanName());
                Assert.assertEquals((Object)ev.isActive(), (Object)av.isActive());
                Assert.assertEquals((Object)ev.isExportable(), (Object)av.isExportable());
            }
            if (value instanceof Map) {
                this.assertMapEquals((Map)e.getValue(), (Map)value, prefix + e.getKey() + "/");
                continue;
            }
            if (value instanceof List) {
                this.assertListEquals((List)e.getValue(), (List)value);
                continue;
            }
            Assert.assertEquals((Object)e.getValue(), value);
        }
    }

    private void assertListEquals(List expected, List actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            Assert.assertEquals(expected.get(i), actual.get(i));
        }
    }
}

