/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.eventbus.EventBus;
import tigase.eventbus.EventBusFactory;
import tigase.eventbus.HandleEvent;
import tigase.kernel.beans.Bean;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.server.xmppsession.UserPresenceChangedEvent;
import tigase.server.xmppsession.UserSessionEvent;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPPacketFilterIfc;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPSession;
import tigase.xmpp.impl.C2SDeliveryErrorProcessor;
import tigase.xmpp.impl.Message;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="message-carbons", parent=SessionManager.class, active=true)
public class MessageCarbons
extends XMPPProcessor
implements XMPPProcessorIfc,
XMPPPacketFilterIfc {
    public static final String XMLNS = "urn:xmpp:carbons:2";
    protected static final String ID = "message-carbons";
    private static final Logger log = Logger.getLogger(MessageCarbons.class.getCanonicalName());
    private static final String[][] ELEMENTS = new String[][]{{"message"}, {"iq", "enable"}, {"iq", "disable"}};
    private static final String[] XMLNSS = new String[]{"jabber:client", "urn:xmpp:carbons:2", "urn:xmpp:carbons:2"};
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"urn:xmpp:carbons:2"})};
    private static final String ENABLED_KEY = "urn:xmpp:carbons:2-enabled";
    private static final String ENABLED_RESOURCES_KEY = "urn:xmpp:carbons:2-resources";
    private static final String ENABLE_ELEM_NAME = "enable";
    private static final String DISABLE_ELEM_NAME = "disable";
    private static final String[] MESSAGE_HINTS_NO_COPY = new String[]{"message", "no-copy"};
    private static final String MESSAGE_HINTS_XMLNS = "urn:xmpp:hints";
    private static final Function<String, Object> RESOURCES_MAP_FACTORY = k -> new ConcurrentHashMap();
    private final EventBus eventBus = EventBusFactory.getInstance();
    private Message messageProcessor = new Message();

    private static boolean isEnabled(XMPPResourceConnection session) throws NotAuthorizedException {
        Boolean value = (Boolean)session.getSessionData(ENABLED_KEY);
        return value != null && value != false;
    }

    private static Packet prepareCarbonCopy(Packet packet, JID srcJid, JID jid, String type) {
        Packet msgClone = tigase.server.Message.getMessage(srcJid, jid, packet.getType(), null, null, null, packet.getStanzaId());
        Element received = new Element(type);
        received.setXMLNS(XMLNS);
        msgClone.getElement().addChild((XMLNodeIfc)received);
        Element forwarded = new Element("forwarded");
        forwarded.setXMLNS("urn:xmpp:forward:0");
        received.addChild((XMLNodeIfc)forwarded);
        forwarded.addChild((XMLNodeIfc)packet.getElement().clone());
        return msgClone;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (session == null) {
            return;
        }
        if (packet.getElemName() == "iq") {
            boolean disable;
            boolean enable = packet.getElement().getChild(ENABLE_ELEM_NAME, XMLNS) != null;
            boolean bl = disable = packet.getElement().getChild(DISABLE_ELEM_NAME, XMLNS) != null;
            if (enable && disable || !enable && !disable) {
                results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, null, false));
            } else {
                this.setEnabled(session, enable);
                results.offer(packet.okResult((Element)null, 0));
            }
        } else if (packet.getElemName() == "message" && packet.getType() == StanzaType.chat && packet.getStanzaTo() != null) {
            if (C2SDeliveryErrorProcessor.isDeliveryError(packet)) {
                return;
            }
            Map resources = (Map)session.getCommonSessionData(ENABLED_RESOURCES_KEY);
            if (resources == null || resources.isEmpty()) {
                return;
            }
            if (packet.getType() == StanzaType.chat) {
                if (packet.getElement().getChild("received", XMLNS) != null || packet.getElement().getChild("sent", XMLNS) != null) {
                    return;
                }
                if (packet.getAttributeStaticStr(MESSAGE_HINTS_NO_COPY, "xmlns") == MESSAGE_HINTS_XMLNS) {
                    return;
                }
                Element privateEl = packet.getElement().getChild("private", XMLNS);
                if (privateEl != null) {
                    packet.getElement().removeChild(privateEl);
                    return;
                }
                String type = session.isUserId(packet.getStanzaTo().getBareJID()) ? "received" : "sent";
                JID srcJid = JID.jidInstance((BareJID)session.getBareJID());
                Set<JID> skipForkingTo = null;
                if (session.isUserId(packet.getStanzaTo().getBareJID()) && packet.getStanzaTo().getResource() == null) {
                    skipForkingTo = this.messageProcessor.getJIDsForMessageDelivery(session);
                    for (JID jid : resources.keySet()) {
                        if (session.getParentSession().getResourceForJID(jid) != null) continue;
                        skipForkingTo.add(jid);
                    }
                } else {
                    skipForkingTo = Collections.singleton(session.getJID());
                }
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "Sending message carbon copy, packet: {0}, resources {1}, skipForkingTo: {2}, session: {3}", new Object[]{packet, resources, skipForkingTo, session});
                }
                for (Map.Entry entry : resources.entrySet()) {
                    if (!((Boolean)entry.getValue()).booleanValue()) continue;
                    JID jid = (JID)entry.getKey();
                    if (skipForkingTo.contains(entry.getKey())) continue;
                    Packet msgClone = MessageCarbons.prepareCarbonCopy(packet, srcJid, jid, type);
                    results.offer(msgClone);
                }
            }
        }
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    @Override
    public void filter(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) {
        if (session == null || !session.isAuthorized() || results == null || results.size() == 0 || packet == null) {
            return;
        }
        if (packet.getElemName() != "message") {
            return;
        }
        Iterator it = results.iterator();
        while (it.hasNext()) {
            Element messageEl;
            Element privateEl;
            Packet res = (Packet)it.next();
            if (res.getElemName() != "message") continue;
            if (this.isErrorDeliveringForkedMessage(packet, session)) {
                it.remove();
            }
            if ((privateEl = (messageEl = res.getElement()).getChild("private", XMLNS)) == null) continue;
            messageEl.removeChild(privateEl);
        }
    }

    @HandleEvent
    protected void stateChanged(MessageCarbonsStateChangedEvent event) {
        XMPPSession session = event.getSession();
        ConcurrentHashMap resources = (ConcurrentHashMap)session.computeCommonSessionDataIfAbsent(ENABLED_RESOURCES_KEY, RESOURCES_MAP_FACTORY);
        for (JID jid : event.getEnabledJids()) {
            resources.put(jid, true);
        }
        for (JID jid : event.getDisabledJids()) {
            resources.put(jid, false);
        }
    }

    @HandleEvent
    protected void presenceUpdate(UserPresenceChangedEvent presenceEvent) throws NotAuthorizedException {
        XMPPSession session = presenceEvent.getSession();
        Packet packet = presenceEvent.getPresence();
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "session = {0} processing presence = {1}", new Object[]{session, packet.toString()});
        }
        ConcurrentHashMap resources = (ConcurrentHashMap)session.computeCommonSessionDataIfAbsent(ENABLED_RESOURCES_KEY, RESOURCES_MAP_FACTORY);
        StanzaType type = packet.getType();
        if (type == null || type == StanzaType.available) {
            if (resources.putIfAbsent(packet.getStanzaFrom(), false) != null) {
                return;
            }
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "session = {0} adding resource = {1} to list of available resources", new Object[]{session, packet.getStanzaFrom()});
            }
            MessageCarbonsStateChangedEvent event = new MessageCarbonsStateChangedEvent(packet.getStanzaFrom().copyWithoutResource(), packet.getStanzaFrom(), session);
            for (XMPPResourceConnection res : session.getActiveResources()) {
                if (!res.isAuthorized()) continue;
                event.add(res.getJID(), MessageCarbons.isEnabled(res));
            }
            this.eventBus.fire(event);
        } else if (type == StanzaType.unavailable) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "session = {0} removing resource = {1} from list of available resources", new Object[]{session, packet.getStanzaFrom()});
            }
            resources.remove(packet.getStanzaFrom());
        }
    }

    private void setEnabled(XMPPResourceConnection session, boolean value) throws NotAuthorizedException {
        session.putSessionData(ENABLED_KEY, value);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "session = {0} enabling urn:xmpp:carbons:2", session);
        }
        MessageCarbonsStateChangedEvent event = new MessageCarbonsStateChangedEvent(session.getJID(), session.getJID().copyWithoutResource(), session.getParentSession());
        event.add(session.getJID(), value);
        this.eventBus.fire(event);
    }

    private boolean isErrorDeliveringForkedMessage(Packet packet, XMPPResourceConnection session) {
        if (!session.isAuthorized() || packet.getStanzaTo() == null) {
            return false;
        }
        try {
            if (packet.getType() == StanzaType.error && packet.getStanzaTo().getResource() == null && session.isUserId(packet.getStanzaTo().getBareJID())) {
                Element messageEl = packet.getElement();
                Element sentEl = messageEl.getChild("sent", XMLNS);
                if (sentEl != null) {
                    return true;
                }
                Element receivedEl = messageEl.getChild("received", XMLNS);
                if (receivedEl != null) {
                    return true;
                }
            }
        }
        catch (NotAuthorizedException notAuthorizedException) {
            // empty catch block
        }
        return false;
    }

    public static class MessageCarbonsStateChangedEvent
    extends UserSessionEvent {
        private HashSet<String> disabled = null;
        private HashSet<String> enabled = null;

        public MessageCarbonsStateChangedEvent() {
        }

        public MessageCarbonsStateChangedEvent(JID sender, JID userJid, XMPPSession session) {
            super(sender, userJid, session);
        }

        public void add(JID jid, Boolean value) {
            if (value == null) {
                value = false;
            }
            HashSet<String> tmp = null;
            if (value.booleanValue()) {
                if (this.enabled == null) {
                    this.enabled = new HashSet();
                }
                tmp = this.enabled;
            } else {
                if (this.disabled == null) {
                    this.disabled = new HashSet();
                }
                tmp = this.disabled;
            }
            tmp.add(jid.getResource());
        }

        public Set<JID> getEnabledJids() {
            HashSet<JID> result = new HashSet<JID>();
            if (this.enabled != null) {
                for (String res : this.enabled) {
                    result.add(JID.jidInstanceNS((BareJID)this.getUserJid().getBareJID(), (String)res));
                }
            }
            return result;
        }

        public Set<JID> getDisabledJids() {
            HashSet<JID> result = new HashSet<JID>();
            if (this.disabled != null) {
                for (String res : this.disabled) {
                    result.add(JID.jidInstanceNS((BareJID)this.getUserJid().getBareJID(), (String)res));
                }
            }
            return result;
        }
    }
}

