/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.PolicyViolationException;
import tigase.server.Priority;
import tigase.server.xmppsession.SessionManager;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.PresenceAbstract;
import tigase.xmpp.impl.RemoteRosterManagement;
import tigase.xmpp.impl.roster.DynamicRoster;
import tigase.xmpp.impl.roster.RepositoryAccessException;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterFactory;
import tigase.xmpp.impl.roster.RosterRetrievingException;
import tigase.xmpp.jid.JID;

@Bean(name="jabber:iq:roster", parent=SessionManager.class, active=true)
public class JabberIqRoster
extends XMPPProcessor
implements XMPPProcessorIfc {
    public static final String ANON = "anon";
    protected static final String ID = "jabber:iq:roster";
    private static final String[][] ELEMENTS = new String[][]{{"iq", "query"}, {"iq", "query"}, {"iq", "query"}};
    private static final Logger log = Logger.getLogger(JabberIqRoster.class.getName());
    private static final String[] XMLNSS = new String[]{"jabber:iq:roster", "jabber:iq:roster-dynamic", "jabber:iq:roster-load"};
    private static final String[] IQ_QUERY_ITEM_PATH = new String[]{"iq", "query", "item"};
    protected RosterAbstract roster_util = this.getRosterUtil();
    @ConfigField(desc="Automatically authorize subscription requests", alias="auto-authorize")
    private boolean autoAuthorize = false;
    @Inject(nullAllowed=true)
    private DynamicRoster dynamicRoster;
    @ConfigField(desc="Allow empty names in roster", alias="empty_name_enabled")
    private boolean emptyNameAllowed = false;
    @ConfigField(desc="Max roster size", alias="max_roster_size")
    private int maxRosterSize = 0;

    protected static void dynamicGetRequest(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) throws NotAuthorizedException {
        Element request = packet.getElement();
        Element item = request.findChildStaticStr(IQ_QUERY_ITEM_PATH);
        if (item != null) {
            Element new_item = DynamicRoster.getItemExtraData(session, settings, item);
            if (new_item == null) {
                new_item = item;
            }
            results.offer(packet.okResult(new_item, 1));
        } else {
            try {
                results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Missing 'item' element, request can not be processed.", true));
            }
            catch (PacketErrorTypeException ex) {
                log.log(Level.SEVERE, "Received error packet? not possible.", ex);
            }
        }
    }

    protected static void dynamicSetRequest(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) {
        Element request = packet.getElement();
        List items = request.getChildrenStaticStr(Iq.IQ_QUERY_PATH);
        if (items != null && items.size() > 0) {
            for (Element item : items) {
                DynamicRoster.setItemExtraData(session, settings, item);
            }
            results.offer(packet.okResult((String)null, 0));
        } else {
            try {
                results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Missing 'item' element, request can not be processed.", true));
            }
            catch (PacketErrorTypeException ex) {
                log.log(Level.SEVERE, "Received error packet? not possible.", ex);
            }
        }
    }

    public static String[] getItemGroups(Element item) {
        List elgr = item.getChildren();
        if (elgr != null && elgr.size() > 0) {
            ArrayList<String> groups = new ArrayList<String>(1);
            for (Element grp : elgr) {
                if (grp.getName() != "group") continue;
                groups.add(grp.getCData());
            }
            if (groups.size() > 0) {
                return groups.toArray(new String[groups.size()]);
            }
        }
        return null;
    }

    @Override
    public int concurrentQueuesNo() {
        return super.concurrentQueuesNo() * 4;
    }

    @Override
    public String id() {
        return ID;
    }

    public boolean isEmptyNameAllowed() {
        JabberIqRoster jabberIqRoster = this;
        return jabberIqRoster.roster_util.isEmptyNameAllowed();
    }

    public void setEmptyNameAllowed(boolean emptyNameAllowed) {
        RosterAbstract.setEmptyNameAllowed(emptyNameAllowed);
    }

    public int getMaxRosterSize() {
        JabberIqRoster jabberIqRoster = this;
        return jabberIqRoster.roster_util.getMaxRosterSize();
    }

    public void setMaxRosterSize(int maxRosterSize) {
        RosterAbstract.setMaxRosterSize(maxRosterSize);
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (session == null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Session is null, ignoring packet: {0}", packet);
            }
            return;
        }
        if (!session.isAuthorized()) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Session is not authorized, ignoring packet: {0}", packet);
            }
            return;
        }
        JID connectionId = session.getConnectionId();
        if (connectionId.equals((Object)packet.getPacketFrom())) {
            if (packet.getStanzaTo() != null && !session.isLocalDomain(packet.getStanzaTo().toString(), false) && !session.isUserId(packet.getStanzaTo().getBareJID())) {
                results.offer(packet.copyElementOnly());
                return;
            }
        } else if (session.isUserId(packet.getStanzaTo().getBareJID())) {
            if (packet.getStanzaTo().getResource() != null) {
                Packet result = packet.copyElementOnly();
                result.setPacketTo(session.getConnectionId(packet.getStanzaTo()));
                result.setPacketFrom(packet.getTo());
                results.offer(result);
            } else {
                this.processRemoteRosterManagementRequest(packet, session, results, settings);
            }
            return;
        }
        try {
            if (packet.getStanzaFrom() != null && !session.isUserId(packet.getStanzaFrom().getBareJID())) {
                log.log(Level.WARNING, "Roster request ''from'' attribute doesn't match session: {0}, request: {1}", new Object[]{session, packet});
                return;
            }
            StanzaType type = packet.getType();
            String xmlns = packet.getElement().getXMLNSStaticStr(Iq.IQ_QUERY_PATH);
            if (xmlns == ID) {
                switch (type) {
                    case get: {
                        this.processGetRequest(packet, session, results, settings);
                        break;
                    }
                    case set: {
                        this.processSetRequest(packet, session, results, settings);
                        break;
                    }
                    case result: {
                        break;
                    }
                    default: {
                        results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Request type is incorrect", false));
                        break;
                    }
                }
            } else if (xmlns == "jabber:iq:roster-dynamic") {
                switch (type) {
                    case get: {
                        JabberIqRoster.dynamicGetRequest(packet, session, results, settings);
                        break;
                    }
                    case set: {
                        JabberIqRoster.dynamicSetRequest(packet, session, results, settings);
                        break;
                    }
                    case result: {
                        break;
                    }
                    default: {
                        results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Request type is incorrect", false));
                        break;
                    }
                }
            } else if (xmlns == "jabber:iq:roster-load") {
                switch (type) {
                    case set: {
                        if (!this.roster_util.isRosterLoaded(session)) {
                            this.roster_util.getRosterElement(session, session.getJID());
                        }
                        Element resultEl = packet.getElement().clone();
                        resultEl.setAttribute("type", StanzaType.result.name());
                        Packet result = Packet.packetInstance(resultEl, packet.getStanzaFrom(), packet.getStanzaTo());
                        result.setPacketFrom(packet.getPacketFrom());
                        result.setPacketTo(packet.getPacketTo());
                        results.add(result);
                        break;
                    }
                }
            } else {
                log.log(Level.WARNING, "Unknown XMLNS for the roster plugin: {0}", packet);
            }
        }
        catch (RosterRetrievingException e) {
            log.log(Level.WARNING, "Unknown roster retrieving exception: {0} for packet: {1}", new Object[]{e, packet});
            results.offer(Authorization.UNDEFINED_CONDITION.getResponseMessage(packet, e.getMessage(), true));
        }
        catch (RepositoryAccessException e) {
            log.log(Level.WARNING, "Problem with roster repository access: {0} for packet: {1}", new Object[]{e, packet});
            results.offer(packet.okResult((String)null, 0));
        }
        catch (NotAuthorizedException e) {
            log.log(Level.WARNING, "Received roster request but user session is not authorized yet: {0}", packet);
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
        }
        catch (PolicyViolationException e) {
            log.log(Level.FINE, "Roster set request violated items number policy: {0}", packet);
            results.offer(Authorization.POLICY_VIOLATION.getResponseMessage(packet, e.getLocalizedMessage(), true));
        }
        catch (TigaseDBException e) {
            log.log(Level.WARNING, "Database problem, please contact admin:", e);
            results.offer(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Database access problem, please contact administrator.", true));
        }
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return RosterAbstract.DISCO_FEATURES;
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    @Override
    public Element[] supStreamFeatures(XMPPResourceConnection session) {
        return RosterAbstract.FEATURES;
    }

    protected void processGetRequest(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) throws NotAuthorizedException, TigaseDBException, RosterRetrievingException, RepositoryAccessException {
        List<Element> ritems;
        List<Element> its = DynamicRoster.getRosterItems(session, settings);
        if (its != null && its.size() > 0) {
            this.updateHash(session, settings);
        }
        String incomingHash = packet.getAttributeStaticStr(Iq.IQ_QUERY_PATH, "ver");
        String storedHash = "";
        if (incomingHash != null) {
            storedHash = this.roster_util.getBuddiesHash(session);
            if (storedHash == null || storedHash.isEmpty()) {
                this.updateHash(session, settings);
                storedHash = this.roster_util.getBuddiesHash(session);
            }
            if (incomingHash.equals(storedHash)) {
                results.offer(packet.okResult((String)null, 0));
                return;
            }
        }
        if ((ritems = this.roster_util.getRosterItems(session)) != null && ritems.size() > 0) {
            Element query = new Element("query");
            query.setXMLNS(ID);
            if (incomingHash != null) {
                query.setAttribute("ver", storedHash);
            }
            query.addChildren(ritems);
            results.offer(packet.okResult(query, 0));
        } else {
            results.offer(packet.okResult((String)null, 1));
        }
        try {
            if (its != null && its.size() > 0) {
                ArrayDeque<Element> items = new ArrayDeque<Element>(its);
                while (items.size() > 0) {
                    Element iq = new Element("iq", new String[]{"type", "id", "to"}, new String[]{"set", session.nextStanzaId(), session.getJID().toString()});
                    iq.setXMLNS("jabber:client");
                    Element query = new Element("query");
                    query.setXMLNS(ID);
                    iq.addChild((XMLNodeIfc)query);
                    query.addChild((XMLNodeIfc)items.poll());
                    while (query.getChildren().size() < 20 && items.size() > 0) {
                        query.addChild((XMLNodeIfc)items.poll());
                    }
                    Packet rost_res = Packet.packetInstance(iq, null, session.getJID());
                    rost_res.setPacketTo(session.getConnectionId());
                    rost_res.setPacketFrom(packet.getTo());
                    results.offer(rost_res);
                }
            }
        }
        catch (NoConnectionIdException ex) {
            log.log(Level.WARNING, "Problem with roster request, no connection ID for session: {0}, request: {1}", new Object[]{session, packet});
        }
    }

    protected void processSetRequest(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) throws XMPPException, NotAuthorizedException, TigaseDBException, PolicyViolationException {
        List<Element> items = packet.getElemChildrenStaticStr(Iq.IQ_QUERY_PATH);
        if (items != null) {
            try {
                for (Element item : items) {
                    JID buddy = JID.jidInstance((String)item.getAttributeStaticStr("jid"));
                    if (DynamicRoster.getBuddyItem(session, settings, buddy) != null) {
                        results.offer(Authorization.FEATURE_NOT_IMPLEMENTED.getResponseMessage(packet, "You cannot modify this contact. It is controlled by an external service.", true));
                        return;
                    }
                    if (session.isUserId(buddy.getBareJID())) {
                        results.offer(Authorization.NOT_ALLOWED.getResponseMessage(packet, "User can't add himself to the roster, RFC says NO.", true));
                        return;
                    }
                    String subscription = item.getAttributeStaticStr("subscription");
                    if (subscription != null && subscription.equals("remove")) {
                        RosterAbstract.SubscriptionType sub = this.roster_util.getBuddySubscription(session, buddy);
                        if (sub == null) {
                            sub = RosterAbstract.SubscriptionType.none;
                        }
                        String type = item.getAttributeStaticStr("type");
                        if (!(sub == RosterAbstract.SubscriptionType.none || type != null && type.equals(ANON))) {
                            Element pres = new Element("presence");
                            pres.setXMLNS("jabber:client");
                            pres.setAttribute("to", buddy.toString());
                            pres.setAttribute("from", session.getJID().toString());
                            pres.setAttribute("type", "unavailable");
                            Packet pres_packet = Packet.packetInstance(pres, session.getJID(), buddy);
                            pres_packet.setPriority(Priority.HIGH);
                            results.offer(pres_packet);
                            pres = new Element("presence");
                            pres.setXMLNS("jabber:client");
                            pres.setAttribute("to", buddy.toString());
                            pres.setAttribute("from", session.getBareJID().toString());
                            pres.setAttribute("type", "unsubscribe");
                            results.offer(Packet.packetInstance(pres, session.getJID().copyWithoutResource(), buddy));
                            pres = new Element("presence");
                            pres.setXMLNS("jabber:client");
                            pres.setAttribute("to", buddy.toString());
                            pres.setAttribute("from", session.getBareJID().toString());
                            pres.setAttribute("type", "unsubscribed");
                            results.offer(Packet.packetInstance(pres, session.getJID().copyWithoutResource(), buddy));
                        }
                        Element it = new Element("item");
                        it.setAttribute("jid", buddy.toString());
                        it.setAttribute("subscription", "remove");
                        this.roster_util.removeBuddy(session, buddy);
                        this.roster_util.updateBuddyChange(session, results, it);
                        continue;
                    }
                    String name = item.getAttributeStaticStr("name");
                    List groups = item.getChildren();
                    String[] gr = null;
                    if (groups != null && groups.size() > 0) {
                        gr = new String[groups.size()];
                        int cnt = 0;
                        for (Element group : groups) {
                            gr[cnt++] = group.getCData() == null ? "" : group.getCData();
                        }
                    }
                    this.roster_util.addBuddy(session, buddy, name, gr, null, null);
                    String type = item.getAttributeStaticStr("type");
                    if (type != null && type.equals(ANON) || this.autoAuthorize) {
                        this.roster_util.setBuddySubscription(session, RosterAbstract.SubscriptionType.both, buddy);
                        Element pres = (Element)session.getSessionData("user-presence");
                        if (pres == null) {
                            pres = new Element("presence");
                            pres.setXMLNS("jabber:client");
                        } else {
                            pres = pres.clone();
                        }
                        pres.setAttribute("to", buddy.toString());
                        pres.setAttribute("from", session.getJID().toString());
                        results.offer(Packet.packetInstance(pres, session.getJID(), buddy));
                        if (this.autoAuthorize) {
                            PresenceAbstract.sendPresence(StanzaType.subscribe, session.getJID().copyWithoutResource(), buddy.copyWithoutResource(), results, null);
                        }
                    }
                    Element new_buddy = this.roster_util.getBuddyItem(session, buddy);
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "1. New Buddy: {0}", new_buddy.toString());
                    }
                    if (this.roster_util.getBuddySubscription(session, buddy) == null) {
                        this.roster_util.setBuddySubscription(session, RosterAbstract.SubscriptionType.none, buddy);
                    }
                    new_buddy = this.roster_util.getBuddyItem(session, buddy);
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "2. New Buddy: {0}", new_buddy.toString());
                    }
                    this.roster_util.updateBuddyChange(session, results, new_buddy);
                }
                results.offer(packet.okResult((String)null, 0));
            }
            catch (TigaseStringprepException ex) {
                results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Buddy JID is incorrct, stringprep failed.", true));
            }
        } else {
            log.log(Level.WARNING, "No items found in roster set request: {0}", packet);
            results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "No items found in the roster set request", true));
        }
    }

    protected void updateHash(XMPPResourceConnection session, Map<String, Object> settings) throws NotAuthorizedException, TigaseDBException, RosterRetrievingException, RepositoryAccessException {
        List<Element> ritems = this.roster_util.getRosterItems(session);
        StringBuilder roster_str = new StringBuilder(5000);
        List<Element> its = DynamicRoster.getRosterItems(session, settings);
        if (its != null && its.size() > 0) {
            Iterator<Element> it = its.iterator();
            while (it.hasNext()) {
                Element element = it.next();
                try {
                    JID jid = JID.jidInstance((String)element.getAttributeStaticStr("jid"));
                    if (!this.roster_util.containsBuddy(session, jid)) continue;
                    this.roster_util.setBuddySubscription(session, RosterAbstract.SubscriptionType.both, jid);
                    String[] itemGroups = JabberIqRoster.getItemGroups(element);
                    if (itemGroups != null) {
                        this.roster_util.addBuddyGroup(session, jid, itemGroups);
                    }
                    it.remove();
                }
                catch (TigaseStringprepException ex) {
                    log.log(Level.INFO, "JID from dynamic roster is incorrect, stringprep failed for: {0}", element.getAttributeStaticStr("jid"));
                    it.remove();
                }
            }
            ritems = this.roster_util.getRosterItems(session);
            for (Element ritem : its) {
                roster_str.append(ritem.toString());
            }
        }
        for (Element ritem : ritems) {
            roster_str.append(ritem.toString());
        }
        this.roster_util.updateRosterHash(roster_str.toString(), session);
    }

    protected RosterAbstract getRosterUtil() {
        return RosterFactory.getRosterImplementation(true);
    }

    private void processRemoteRosterManagementRequest(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        if (!RemoteRosterManagement.isRemoteAllowed(packet.getStanzaFrom(), session)) {
            results.offer(Authorization.NOT_ALLOWED.getResponseMessage(packet, "Not authorized for remote roster management", true));
            return;
        }
        try {
            switch (packet.getType()) {
                case get: {
                    List<Element> ritems = this.roster_util.getRosterItems(session);
                    if (ritems != null && !ritems.isEmpty()) {
                        Element query = new Element("query");
                        query.setXMLNS(ID);
                        String jidStr = "@" + packet.getStanzaFrom().getBareJID().toString();
                        for (Element ritem : ritems) {
                            if (!ritem.getAttributeStaticStr("jid").endsWith(jidStr)) continue;
                            query.addChild((XMLNodeIfc)ritem);
                        }
                        results.offer(packet.okResult(query, 0));
                        break;
                    }
                    results.offer(packet.okResult((String)null, 1));
                    break;
                }
                case set: {
                    this.processSetRequest(packet, session, results, settings);
                    break;
                }
                default: {
                    results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Bad stanza type", true));
                    break;
                }
            }
        }
        catch (PolicyViolationException e) {
            log.log(Level.WARNING, "Roster set request violated items number policy: {0}", packet);
            results.offer(Authorization.POLICY_VIOLATION.getResponseMessage(packet, e.getLocalizedMessage(), true));
        }
        catch (Throwable ex) {
            log.log(Level.WARNING, "Reflection execution exception", ex);
            results.offer(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Internal server error", true));
        }
    }
}

