/*
 * Decompiled with CFR 0.152.
 */
package tigase.vhosts;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.comp.RepositoryItemAbstract;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.util.StringUtilities;
import tigase.util.repository.DataTypes;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.vhosts.VHostItemDefaults;
import tigase.vhosts.filter.DomainFilterPolicy;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.jid.JID;

public class VHostItem
extends RepositoryItemAbstract
implements Comparable<VHostItem> {
    public static final String ANONYMOUS_ENABLED_ATT = "anon";
    public static final String ANONYMOUS_ENABLED_LABEL = "Anonymous enabled";
    public static final String SASL_MECHANISM_ATT = "sasl-mechanisms";
    public static final String SASL_MECHANISM_LABEL = "Allowed SASL mechanisms";
    public static final String COMPONENTS_ATT = "comps";
    public static final String COMPONENTS_ELEM = "comps";
    public static final String C2S_PORTS_ALLOWED_ATT = "c2s-ports-allowed";
    public static final String C2S_PORTS_ALLOWED_LABEL = "Allowed C2S,BOSH,WebSocket ports";
    public static final String DOMAIN_FILTER_POLICY_ATT = "domain-filter";
    public static final String DOMAIN_FILTER_POLICY_DOMAINS_ATT = "domain-filter-domains";
    public static final String DOMAIN_FILTER_POLICY_LABEL = "Domain filter policy";
    public static final String DOMAIN_FILTER_POLICY_DOMAINS_LABEL = "Domain filter domains (only LIST and BLACKLIST)";
    public static final String ENABLED_ATT = "enabled";
    public static final String ENABLED_LABEL = "Enabled";
    public static final String HOSTNAME_ATT = "hostname";
    public static final String HOSTNAME_LABEL = "Domain name";
    public static final String MAX_USERS_NUMBER_ATT = "max-users";
    public static final String MAX_USERS_NUMBER_LABEL = "Max users";
    public static final String MESSAGE_FORWARD_ADDRESS_ATT = "mess-forw";
    public static final String MESSAGE_FORWARD_ADDRESS_LABEL = "Message forward address";
    public static final String OTHER_PARAMS_ELEM = "other";
    public static final String OTHER_PARAMS_LABEL = "Other parameters";
    public static final String PRESENCE_FORWARD_ADDRESS_ATT = "pres-forw";
    public static final String PRESENCE_FORWARD_ADDRESS_LABEL = "Presence forward address";
    public static final String REGISTER_ENABLED_ATT = "register";
    public static final String REGISTER_ENABLED_LABEL = "In-band registration";
    public static final String S2S_SECRET_ATT = "s2s-secret";
    public static final String S2S_SECRET_LABEL = "S2S secret";
    public static final String TLS_REQUIRED_ATT = "tls-required";
    public static final String TLS_REQUIRED_LABEL = "TLS required";
    public static final String TRUSTED_JIDS_ATT = "trusted-jids";
    public static final String VHOST_ELEM = "vhost";
    protected static final String DOMAIN_FILTER_POLICY_PROP_KEY = "domain-filter-policy";
    protected static final String S2S_SECRET_PROP_DEF = null;
    protected static final String S2S_SECRET_PROP_KEY = "s2s-secret";
    protected static final String VHOST_ANONYMOUS_ENABLED_PROP_KEY = "vhost-anonymous-enabled";
    protected static final Boolean VHOST_ANONYMOUS_ENABLED_PROP_DEF = Boolean.TRUE;
    protected static final String VHOST_MAX_USERS_PROP_KEY = "vhost-max-users";
    protected static final Long VHOST_MAX_USERS_PROP_DEF = 0L;
    protected static final String VHOST_MESSAGE_FORWARD_PROP_DEF = null;
    protected static final String VHOST_MESSAGE_FORWARD_PROP_KEY = "vhost-message-forward-jid";
    protected static final String VHOST_PRESENCE_FORWARD_PROP_DEF = null;
    protected static final String VHOST_PRESENCE_FORWARD_PROP_KEY = "vhost-presence-forward-jid";
    protected static final String VHOST_REGISTER_ENABLED_PROP_KEY = "vhost-register-enabled";
    protected static final Boolean VHOST_REGISTER_ENABLED_PROP_DEF = Boolean.TRUE;
    protected static final String VHOST_TLS_REQUIRED_PROP_KEY = "vhost-tls-required";
    protected static final Boolean VHOST_TLS_REQUIRED_PROP_DEF = Boolean.FALSE;
    protected static final DomainFilterPolicy DOMAIN_FILTER_POLICY_PROP_DEF = DomainFilterPolicy.ALL;
    protected static final String[] VHOST_OTHER_PARAMS_PATH = new String[]{"vhost", "other"};
    protected static final String[] VHOST_COMPONENTS_PATH = new String[]{"vhost", "comps"};
    protected static final Map<String, DataType> dataTypes = Collections.synchronizedMap(new LinkedHashMap());
    private static final Logger log = Logger.getLogger(VHostItem.class.getName());
    private boolean anonymousEnabled = VHOST_ANONYMOUS_ENABLED_PROP_DEF;
    private int[] c2sPortsAllowed = null;
    private String[] comps = null;
    private Map<String, Object> data = new ConcurrentHashMap<String, Object>();
    private VHostItemDefaults defaults;
    private DomainFilterPolicy domainFilter = DOMAIN_FILTER_POLICY_PROP_DEF;
    private String[] domainFilterDomains = null;
    private boolean enabled = true;
    private long maxUsersNumber = VHOST_MAX_USERS_PROP_DEF;
    private JID messageForward = JID.jidInstanceNS((String)VHOST_MESSAGE_FORWARD_PROP_DEF);
    private String otherDomainParams = null;
    private JID presenceForward = JID.jidInstanceNS((String)VHOST_PRESENCE_FORWARD_PROP_DEF);
    private boolean registerEnabled = VHOST_REGISTER_ENABLED_PROP_DEF;
    private String s2sSecret = S2S_SECRET_PROP_DEF;
    private String[] saslAllowedMechanisms = null;
    private boolean tlsRequired = VHOST_TLS_REQUIRED_PROP_DEF;
    private VHostItem unmodifiableItem = null;
    private JID vhost = null;

    static DomainFilterPolicy getPolicyFromConfString(String configuration) {
        String[] df = configuration.split("=");
        try {
            if (df.length >= 2) {
                return DomainFilterPolicy.valueof(df[1]);
            }
            return DomainFilterPolicy.ALL;
        }
        catch (Exception e) {
            return DomainFilterPolicy.ALL;
        }
    }

    static String[] getDomainsFromConfString(String configuration) {
        String[] df = configuration.split("=");
        try {
            if (df.length >= 3 && df[2] != null && !df[2].trim().isEmpty()) {
                return StringUtilities.stringToArrayOfString((String)df[2], (String)";");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new String[0];
    }

    public static void registerData(List<DataType> types) {
        for (DataType type : types) {
            dataTypes.put(type.getKey(), type);
        }
    }

    public VHostItem() {
        if (this.s2sSecret == null) {
            this.s2sSecret = UUID.randomUUID().toString();
        }
    }

    public VHostItem(Element elem) {
        this.initFromElement(elem);
    }

    public VHostItem(JID vhost) {
        this.setVHost(vhost);
    }

    public VHostItem(String vhost) throws TigaseStringprepException {
        this.setVHost(vhost);
    }

    @Override
    public void addCommandFields(Packet packet) {
        Command.addFieldValue(packet, HOSTNAME_LABEL, this.vhost != null ? this.vhost.getDomain() : "");
        Command.addCheckBoxField(packet, ENABLED_LABEL, this.enabled);
        Command.addCheckBoxField(packet, ANONYMOUS_ENABLED_LABEL, this.anonymousEnabled);
        Command.addCheckBoxField(packet, REGISTER_ENABLED_LABEL, this.registerEnabled);
        Command.addCheckBoxField(packet, TLS_REQUIRED_LABEL, this.tlsRequired);
        Command.addFieldValue(packet, S2S_SECRET_LABEL, this.s2sSecret != null ? this.s2sSecret : "");
        Command.addFieldValue(packet, DOMAIN_FILTER_POLICY_LABEL, this.domainFilter.toString(), DOMAIN_FILTER_POLICY_LABEL, DomainFilterPolicy.valuesStr(), DomainFilterPolicy.valuesStr());
        Command.addFieldValue(packet, DOMAIN_FILTER_POLICY_DOMAINS_LABEL, this.domainFilterDomains != null ? this.stringArrayToString(this.domainFilterDomains, ";") : "");
        Command.addFieldValue(packet, MAX_USERS_NUMBER_LABEL, "" + this.maxUsersNumber);
        String c2sPortsAllowedStr = this.intArrayToString(this.c2sPortsAllowed, ",");
        Command.addFieldValue(packet, C2S_PORTS_ALLOWED_LABEL, c2sPortsAllowedStr != null ? c2sPortsAllowedStr : "");
        Command.addFieldValue(packet, PRESENCE_FORWARD_ADDRESS_LABEL, this.presenceForward != null ? this.presenceForward.toString() : "");
        Command.addFieldValue(packet, MESSAGE_FORWARD_ADDRESS_LABEL, this.messageForward != null ? this.messageForward.toString() : "");
        Command.addFieldValue(packet, OTHER_PARAMS_LABEL, this.otherDomainParams != null ? this.otherDomainParams : "");
        Command.addFieldValue(packet, SASL_MECHANISM_LABEL, this.saslAllowedMechanisms != null ? this.stringArrayToString(this.saslAllowedMechanisms, ",") : "");
        super.addCommandFields(packet);
        for (DataType type : dataTypes.values()) {
            if (type.cls != Boolean.class) {
                String valueStr;
                T[] options = type.getOptions();
                Object val = this.getData(type.getKey());
                if (val instanceof Collection) {
                    Collection collection = (Collection)val;
                    val = Array.newInstance(type.getCls().getComponentType(), collection.size());
                    int i = 0;
                    for (Object v : collection) {
                        Array.set(val, i, v);
                        ++i;
                    }
                }
                String string = valueStr = val != null ? DataTypes.valueToString(val) : "";
                if (options == null || options.length == 0) {
                    Command.addFieldValue(packet, type.getName(), valueStr);
                    continue;
                }
                String[] optionsStr = new String[options.length];
                for (int i = 0; i < options.length; ++i) {
                    optionsStr[i] = options[i] != null ? DataTypes.valueToString(options[i]) : "";
                }
                String[] optionsNames = type.getOptionsNames();
                if (optionsNames == null) {
                    optionsNames = optionsStr;
                }
                Command.addFieldValue(packet, type.getName(), valueStr, type.getName(), optionsNames, optionsStr);
                continue;
            }
            boolean val = this.isData(type.getKey());
            Command.addCheckBoxField(packet, type.getName(), val);
        }
    }

    @Override
    public int compareTo(VHostItem o) {
        return this.vhost.compareTo(o.vhost);
    }

    public boolean equals(Object v) {
        boolean result = false;
        if (v instanceof VHostItem) {
            result = this.vhost.equals((Object)((VHostItem)v).vhost);
        }
        return result;
    }

    public int hashCode() {
        return this.vhost.hashCode();
    }

    @Override
    public void initFromCommand(Packet packet) {
        super.initFromCommand(packet);
        String tmp = Command.getFieldValue(packet, HOSTNAME_LABEL);
        try {
            this.setVHost(tmp);
        }
        catch (TigaseStringprepException ex) {
            throw new IllegalArgumentException("Incorrect domain, unable to parse it: " + tmp, ex);
        }
        this.enabled = Command.getCheckBoxFieldValue(packet, ENABLED_LABEL);
        this.anonymousEnabled = Command.getCheckBoxFieldValue(packet, ANONYMOUS_ENABLED_LABEL);
        this.registerEnabled = Command.getCheckBoxFieldValue(packet, REGISTER_ENABLED_LABEL);
        this.tlsRequired = Command.getCheckBoxFieldValue(packet, TLS_REQUIRED_LABEL);
        tmp = Command.getFieldValue(packet, S2S_SECRET_LABEL);
        this.s2sSecret = tmp != null && !tmp.trim().isEmpty() ? tmp : null;
        tmp = Command.getFieldValue(packet, DOMAIN_FILTER_POLICY_LABEL);
        try {
            this.domainFilter = DomainFilterPolicy.valueof(tmp);
            if (this.domainFilter == null) {
                this.domainFilter = this.defaults.getDomainFilter();
            } else if (this.domainFilter.isDomainListRequired() && (tmp = Command.getFieldValue(packet, DOMAIN_FILTER_POLICY_DOMAINS_LABEL)) != null && !tmp.trim().isEmpty()) {
                this.domainFilterDomains = StringUtilities.stringToArrayOfString((String)tmp, (String)";");
            }
        }
        catch (Exception ex) {
            this.domainFilter = DOMAIN_FILTER_POLICY_PROP_DEF;
        }
        try {
            this.maxUsersNumber = Long.parseLong(Command.getFieldValue(packet, MAX_USERS_NUMBER_LABEL));
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Can not parse max users number: {0}", Command.getFieldValue(packet, MAX_USERS_NUMBER_LABEL));
        }
        tmp = Command.getFieldValue(packet, PRESENCE_FORWARD_ADDRESS_LABEL);
        if (tmp != null && !tmp.trim().isEmpty()) {
            try {
                this.presenceForward = JID.jidInstance((String)tmp);
            }
            catch (TigaseStringprepException ex) {
                this.presenceForward = null;
                throw new IllegalArgumentException("Incorrect presence forward address: " + tmp, ex);
            }
        }
        if ((tmp = Command.getFieldValue(packet, MESSAGE_FORWARD_ADDRESS_LABEL)) != null && !tmp.trim().isEmpty()) {
            try {
                this.messageForward = JID.jidInstance((String)tmp);
            }
            catch (TigaseStringprepException ex) {
                this.messageForward = null;
                throw new IllegalArgumentException("Incorrect message forward address: " + tmp, ex);
            }
        }
        this.otherDomainParams = Command.getFieldValue(packet, OTHER_PARAMS_LABEL);
        tmp = Command.getFieldValue(packet, C2S_PORTS_ALLOWED_LABEL);
        this.c2sPortsAllowed = this.parseIntArray(tmp, ",");
        tmp = Command.getFieldValue(packet, SASL_MECHANISM_LABEL);
        if (tmp != null && !tmp.trim().isEmpty()) {
            this.setSaslAllowedMechanisms(tmp.split(","));
        }
        for (DataType type : dataTypes.values()) {
            Object value;
            String valueStr = Command.getFieldValue(packet, type.getName());
            Character typeId = DataTypes.typesMap.get(type.cls.getName());
            Object object = value = valueStr == null || valueStr.isEmpty() ? null : DataTypes.decodeValueType(typeId.charValue(), valueStr);
            if (value != null && type.getCollectionCls() != null) {
                try {
                    Collection collection = type.getCollectionCls().newInstance();
                    for (int i = 0; i < Array.getLength(value); ++i) {
                        collection.add(Array.get(value, i));
                    }
                    value = collection;
                }
                catch (IllegalAccessException | InstantiationException ex) {
                    throw new IllegalArgumentException("Could not instantiate collection of class: " + type.getCollectionCls().getCanonicalName(), ex);
                }
            }
            this.setData(type.getKey(), value);
        }
        log.log(Level.FINE, "Initialized from command: {0}", this);
    }

    @Override
    public void initFromElement(Element elem) {
        List items;
        Element data;
        String comps_str;
        String tmp;
        if (elem.getName() != VHOST_ELEM) {
            throw new IllegalArgumentException("Incorrect element name, expected: vhost");
        }
        super.initFromElement(elem);
        this.setVHost(JID.jidInstanceNS((String)elem.getAttributeStaticStr(HOSTNAME_ATT)));
        this.enabled = Boolean.parseBoolean(elem.getAttributeStaticStr(ENABLED_ATT));
        this.anonymousEnabled = Boolean.parseBoolean(elem.getAttributeStaticStr(ANONYMOUS_ENABLED_ATT));
        this.registerEnabled = Boolean.parseBoolean(elem.getAttributeStaticStr(REGISTER_ENABLED_ATT));
        this.tlsRequired = Boolean.parseBoolean(elem.getAttributeStaticStr(TLS_REQUIRED_ATT));
        this.s2sSecret = elem.getAttributeStaticStr("s2s-secret");
        try {
            this.domainFilter = DomainFilterPolicy.valueof(elem.getAttributeStaticStr(DOMAIN_FILTER_POLICY_ATT));
            if (this.domainFilter == null) {
                this.domainFilter = this.defaults.getDomainFilter();
            } else if (this.domainFilter.isDomainListRequired() && (tmp = elem.getAttributeStaticStr(DOMAIN_FILTER_POLICY_DOMAINS_ATT)) != null && !tmp.trim().isEmpty()) {
                this.domainFilterDomains = StringUtilities.stringToArrayOfString((String)tmp, (String)";");
            }
        }
        catch (Exception e) {
            this.domainFilter = DOMAIN_FILTER_POLICY_PROP_DEF;
        }
        try {
            this.maxUsersNumber = Long.parseLong(elem.getAttributeStaticStr(MAX_USERS_NUMBER_ATT));
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Can not parse max users number: {0}", elem.getAttributeStaticStr(MAX_USERS_NUMBER_ATT));
            this.maxUsersNumber = Long.getLong(VHOST_MAX_USERS_PROP_KEY, VHOST_MAX_USERS_PROP_DEF);
        }
        tmp = elem.getAttributeStaticStr(PRESENCE_FORWARD_ADDRESS_ATT);
        if (tmp != null && !tmp.trim().isEmpty()) {
            this.presenceForward = JID.jidInstanceNS((String)tmp);
        }
        if ((tmp = elem.getAttributeStaticStr(MESSAGE_FORWARD_ADDRESS_ATT)) != null && !tmp.trim().isEmpty()) {
            this.messageForward = JID.jidInstanceNS((String)tmp);
        }
        if ((comps_str = elem.getCDataStaticStr(VHOST_COMPONENTS_PATH)) != null && !comps_str.isEmpty()) {
            this.comps = comps_str.split(",");
        }
        this.otherDomainParams = elem.getCDataStaticStr(VHOST_OTHER_PARAMS_PATH);
        this.c2sPortsAllowed = this.parseIntArray(elem.getAttributeStaticStr(C2S_PORTS_ALLOWED_ATT), ",");
        tmp = elem.getAttributeStaticStr(SASL_MECHANISM_ATT);
        if (tmp != null) {
            this.setSaslAllowedMechanisms(tmp.split(";"));
        }
        if ((data = elem.getChild("data")) != null && (items = data.getChildren()) != null) {
            for (Element item : items) {
                DataType type = dataTypes.get(item.getName());
                Character typeChar = type != null ? DataTypes.typesMap.get(type.getCls().getName()) : Character.valueOf(item.getAttributeStaticStr("type").charAt(0));
                Object value = DataTypes.decodeValueType(typeChar.charValue(), item.getCData());
                if (type != null && type.getCollectionCls() != null && value != null) {
                    try {
                        Collection collection = type.getCollectionCls().newInstance();
                        for (int i = 0; i < Array.getLength(value); ++i) {
                            collection.add(Array.get(value, i));
                        }
                        value = collection;
                    }
                    catch (IllegalAccessException | InstantiationException ex) {
                        throw new IllegalArgumentException("Could not instantiate collection of class: " + type.getCollectionCls().getCanonicalName(), ex);
                    }
                }
                this.setData(item.getName(), value);
            }
        }
        log.log(Level.FINE, "Initialized from element: {0}", this);
    }

    @Override
    protected void setKey(String key) {
        this.setVHost(JID.jidInstanceNS((String)key));
    }

    @Override
    public void initFromPropertyString(String propString) {
        String[] props = propString.split(":");
        try {
            this.setVHost(props[0]);
        }
        catch (TigaseStringprepException ex) {
            throw new IllegalArgumentException("Domain misconfiguration, cannot parse it: " + props[0], ex);
        }
        for (String tmp : props) {
            String[] mu;
            String[] c;
            String comps_str;
            boolean val = true;
            if (tmp.startsWith("-")) {
                val = false;
            }
            if (tmp.endsWith(ANONYMOUS_ENABLED_ATT)) {
                this.anonymousEnabled = val;
            }
            if (tmp.endsWith(REGISTER_ENABLED_ATT)) {
                this.registerEnabled = val;
            }
            if (tmp.endsWith(TLS_REQUIRED_ATT)) {
                this.tlsRequired = val;
            }
            if (tmp.startsWith("s2s-secret")) {
                String[] s2 = tmp.split("=");
                this.s2sSecret = s2[1];
            }
            if (tmp.startsWith("comps") && !(comps_str = (c = tmp.split("="))[1]).isEmpty()) {
                this.comps = comps_str.split(";");
            }
            if (tmp.startsWith(DOMAIN_FILTER_POLICY_ATT)) {
                this.domainFilter = VHostItem.getPolicyFromConfString(tmp);
                if (this.domainFilter == null) {
                    this.domainFilter = this.defaults.getDomainFilter();
                    if (this.domainFilter.isDomainListRequired()) {
                        this.domainFilterDomains = this.defaults.getDomainFilterDomains();
                    }
                } else if (this.domainFilter.isDomainListRequired()) {
                    this.domainFilterDomains = VHostItem.getDomainsFromConfString(tmp);
                }
            }
            if (tmp.startsWith(MAX_USERS_NUMBER_ATT)) {
                mu = tmp.split("=");
                try {
                    this.maxUsersNumber = Long.parseLong(mu[1]);
                }
                catch (NumberFormatException ex) {
                    this.maxUsersNumber = 0L;
                    log.log(Level.WARNING, "Incorrect max users number for vhost settings, number parsing error: {0}", tmp);
                }
            }
            if (tmp.startsWith(PRESENCE_FORWARD_ADDRESS_ATT)) {
                mu = tmp.split("=");
                try {
                    this.presenceForward = JID.jidInstance((String)mu[1]);
                }
                catch (TigaseStringprepException ex) {
                    this.presenceForward = null;
                    log.log(Level.WARNING, "Incorrect presence forwarding address, address parsing error: {0}", tmp);
                }
            }
            if (tmp.startsWith(MESSAGE_FORWARD_ADDRESS_ATT)) {
                mu = tmp.split("=");
                try {
                    this.messageForward = JID.jidInstance((String)mu[1]);
                }
                catch (TigaseStringprepException ex) {
                    this.messageForward = null;
                    log.log(Level.WARNING, "Incorrect presence forwarding address, address parsing error: {0}", tmp);
                }
            }
            if (tmp.startsWith(C2S_PORTS_ALLOWED_ATT)) {
                mu = tmp.split("=");
                this.c2sPortsAllowed = this.parseIntArray(mu[1], ";");
            }
            if (tmp.startsWith(SASL_MECHANISM_ATT)) {
                mu = tmp.split("=");
                this.setSaslAllowedMechanisms(mu[1].split(";"));
            }
            if ((mu = tmp.split("=")) == null || mu.length != 2 || !dataTypes.containsKey(mu[0])) continue;
            this.parseDataValue(mu[0], mu[1]);
        }
        log.log(Level.FINE, "Initialized from property string: {0}", this);
    }

    @Override
    public Element toElement() {
        Element elem = super.toElement();
        String comps_str = "";
        if (this.comps != null && this.comps.length > 0) {
            for (String comp : this.comps) {
                if (!comps_str.isEmpty()) {
                    comps_str = comps_str + ",";
                }
                comps_str = comps_str + comp;
            }
        }
        String other_params = this.otherDomainParams != null ? this.otherDomainParams : "";
        elem.addChild((XMLNodeIfc)new Element("comps", comps_str));
        elem.addChild((XMLNodeIfc)new Element(OTHER_PARAMS_ELEM, other_params));
        elem.addAttribute(HOSTNAME_ATT, this.vhost.getDomain());
        elem.addAttribute(ENABLED_ATT, "" + this.enabled);
        elem.addAttribute(ANONYMOUS_ENABLED_ATT, "" + this.anonymousEnabled);
        if (this.saslAllowedMechanisms != null) {
            elem.addAttribute(SASL_MECHANISM_ATT, this.stringArrayToString(this.saslAllowedMechanisms, ";"));
        }
        elem.addAttribute(REGISTER_ENABLED_ATT, "" + this.registerEnabled);
        elem.addAttribute(TLS_REQUIRED_ATT, "" + this.tlsRequired);
        if (this.s2sSecret != null) {
            elem.addAttribute("s2s-secret", this.s2sSecret);
        }
        if (this.domainFilter != null) {
            elem.addAttribute(DOMAIN_FILTER_POLICY_ATT, this.domainFilter.toString());
        }
        if (this.domainFilterDomains != null) {
            elem.addAttribute(DOMAIN_FILTER_POLICY_DOMAINS_ATT, this.stringArrayToString(this.domainFilterDomains, ";"));
        }
        elem.addAttribute(MAX_USERS_NUMBER_ATT, "" + this.maxUsersNumber);
        if (this.presenceForward != null) {
            elem.addAttribute(PRESENCE_FORWARD_ADDRESS_ATT, this.presenceForward.toString());
        }
        if (this.messageForward != null) {
            elem.addAttribute(MESSAGE_FORWARD_ADDRESS_ATT, this.messageForward.toString());
        }
        if (this.c2sPortsAllowed != null) {
            String c2sPortsAllowedStr = this.intArrayToString(this.c2sPortsAllowed, ",");
            elem.addAttribute(C2S_PORTS_ALLOWED_ATT, c2sPortsAllowedStr);
        }
        if (!this.data.isEmpty()) {
            Element data = new Element("data");
            for (Map.Entry<String, Object> e : this.data.entrySet()) {
                Element item = new Element(e.getKey());
                item.addAttribute("type", String.valueOf(DataTypes.getTypeId(e.getValue())));
                Object val = e.getValue();
                DataType type = dataTypes.get(e.getKey());
                if (type != null && val instanceof Collection && type.getCollectionCls() != null) {
                    Collection collection = (Collection)val;
                    val = Array.newInstance(type.getCls().getComponentType(), collection.size());
                    int i = 0;
                    for (Object v : collection) {
                        Array.set(val, i, v);
                        ++i;
                    }
                }
                item.setCData(DataTypes.valueToString(val));
                data.addChild((XMLNodeIfc)item);
            }
            elem.addChild((XMLNodeIfc)data);
        }
        return elem;
    }

    @Override
    public String toPropertyString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.vhost.toString());
        if (!this.anonymousEnabled) {
            sb.append(":-").append(ANONYMOUS_ENABLED_ATT);
        }
        if (!this.registerEnabled) {
            sb.append(":-").append(REGISTER_ENABLED_ATT);
        }
        if (!this.tlsRequired) {
            sb.append(":-").append(TLS_REQUIRED_ATT);
        }
        if (this.s2sSecret != null) {
            sb.append(':').append("s2s-secret").append('=').append(this.s2sSecret);
        }
        sb.append(':').append(DOMAIN_FILTER_POLICY_ATT).append('=').append(this.domainFilter.toString());
        if (this.domainFilterDomains != null) {
            sb.append("=").append(this.stringArrayToString(this.domainFilterDomains, ";"));
        }
        if (this.maxUsersNumber > 0L) {
            sb.append(':').append(MAX_USERS_NUMBER_ATT).append('=').append(this.maxUsersNumber);
        }
        if (this.presenceForward != null) {
            sb.append(':').append(PRESENCE_FORWARD_ADDRESS_ATT).append('=').append(this.presenceForward.toString());
        }
        if (this.messageForward != null) {
            sb.append(':').append(MESSAGE_FORWARD_ADDRESS_ATT).append('=').append(this.messageForward.toString());
        }
        if (this.c2sPortsAllowed != null) {
            sb.append(':').append(C2S_PORTS_ALLOWED_ATT).append('=').append(this.intArrayToString(this.c2sPortsAllowed, ";"));
        }
        if (this.saslAllowedMechanisms != null) {
            sb.append(':').append(SASL_MECHANISM_ATT).append('=').append(this.stringArrayToString(this.saslAllowedMechanisms, ";"));
        }
        return sb.toString();
    }

    public String toString() {
        String str = "Domain: " + this.vhost + ", enabled: " + this.enabled + ", anonym: " + this.anonymousEnabled + ", register: " + this.registerEnabled + ", maxusers: " + this.maxUsersNumber + ", tls: " + this.tlsRequired + ", s2sSecret: " + this.s2sSecret + ", domainFilter: " + (Object)((Object)this.domainFilter) + ", domainFilterDomains: " + this.stringArrayToString(this.domainFilterDomains, ";") + ", c2sPortsAllowed: " + this.intArrayToString(this.c2sPortsAllowed, ",") + ", saslAllowedMechanisms: " + Arrays.toString(this.saslAllowedMechanisms);
        for (Map.Entry<String, Object> e : this.data.entrySet()) {
            Object val = e.getValue();
            DataType type = dataTypes.get(e.getKey());
            if (type != null && val instanceof Collection && type.getCollectionCls() != null) {
                Collection collection = (Collection)val;
                val = Array.newInstance(type.getCls().getComponentType(), collection.size());
                int i = 0;
                for (Object v : collection) {
                    Array.set(val, i, v);
                    ++i;
                }
            }
            str = str + ", " + e.getKey() + ": " + DataTypes.valueToString(val);
        }
        return str;
    }

    public String[] getComps() {
        return this.comps;
    }

    public void setComps(String[] comps) {
        this.comps = comps;
    }

    public int[] getC2SPortsAllowed() {
        return this.c2sPortsAllowed;
    }

    public void setC2SPortsAllowed(int[] ports) {
        this.c2sPortsAllowed = ports;
    }

    public <T> T getData(String key) {
        DataType type;
        Object val = this.data.get(key);
        if (val == null && (type = dataTypes.get(key)) != null) {
            val = type.getDefValue();
        }
        return (T)val;
    }

    public DomainFilterPolicy getDomainFilter() {
        if (this.domainFilter == null) {
            this.domainFilter = this.defaults.getDomainFilter();
        }
        return this.domainFilter;
    }

    public void setDomainFilter(DomainFilterPolicy domainFilter) {
        this.domainFilter = domainFilter;
    }

    public String[] getDomainFilterDomains() {
        return this.domainFilterDomains;
    }

    public void setDomainFilterDomains(String[] domainFilterDomains) {
        this.domainFilterDomains = StringUtilities.internStringArray((String[])domainFilterDomains);
    }

    @Override
    public String getElemName() {
        return VHOST_ELEM;
    }

    @Override
    public String getKey() {
        return this.vhost.getDomain();
    }

    public long getMaxUsersNumber() {
        return this.maxUsersNumber;
    }

    public void setMaxUsersNumber(long maxUsersNumber) {
        this.maxUsersNumber = maxUsersNumber;
    }

    public JID getMessageForward() {
        return this.messageForward;
    }

    public void setMessageForward(JID messageForward) {
        this.messageForward = messageForward;
    }

    public JID getMessageForwardAddress() {
        return this.messageForward;
    }

    public String getOtherDomainParams() {
        return this.otherDomainParams;
    }

    public void setOtherDomainParams(String otherParams) {
        this.otherDomainParams = otherParams;
    }

    public JID getPresenceForward() {
        return this.presenceForward;
    }

    public void setPresenceForward(JID presenceForward) {
        this.presenceForward = presenceForward;
    }

    public JID getPresenceForwardAddress() {
        return this.presenceForward;
    }

    public String getS2sSecret() {
        return this.s2sSecret;
    }

    public void setS2sSecret(String s2sSecret) {
        this.s2sSecret = s2sSecret;
    }

    public Set<String> getTrustedJIDs() {
        return (Set)this.getData(TRUSTED_JIDS_ATT);
    }

    public void setTrustedJIDs(JID[] trustedJids) {
        this.setData(TRUSTED_JIDS_ATT, trustedJids);
    }

    public VHostItem getUnmodifiableVHostItem() {
        if (this.unmodifiableItem == null) {
            this.unmodifiableItem = new UnmodifiableVHostItem();
        }
        return this.unmodifiableItem;
    }

    public JID getVhost() {
        return this.vhost;
    }

    public boolean isAnonymousEnabled() {
        return this.anonymousEnabled;
    }

    public void setAnonymousEnabled(boolean value) {
        this.anonymousEnabled = value;
    }

    public boolean isData(String key) {
        if (this.data.containsKey(key)) {
            return (Boolean)this.data.get(key);
        }
        DataType type = dataTypes.get(key);
        Boolean defValue = type == null ? null : (Boolean)type.getDefValue();
        return defValue != null ? defValue : false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    public boolean isRegisterEnabled() {
        return this.registerEnabled;
    }

    public void setRegisterEnabled(boolean value) {
        this.registerEnabled = value;
    }

    public boolean isTlsRequired() {
        return this.tlsRequired || this.defaults.isTlsRequired();
    }

    public void setTlsRequired(boolean value) {
        this.tlsRequired = value;
    }

    public boolean isTrustedJID(JID jid) {
        Set<String> trustedJids = this.getTrustedJIDs();
        if (trustedJids == null) {
            return false;
        }
        return trustedJids.contains(jid.toString()) || trustedJids.contains(jid.getBareJID().toString()) || trustedJids.contains(jid.getDomain());
    }

    public void setData(String key, Object value) {
        if (value == null) {
            this.data.remove(key);
        } else {
            this.data.put(key, value);
        }
    }

    public void parseDataValue(String key, String valueStr) {
        DataType type = dataTypes.get(key);
        if (type == null) {
            throw new RuntimeException("Key " + key + " is not registered");
        }
        if (valueStr == null) {
            this.data.remove(key);
        } else {
            Object value;
            char typeId = DataTypes.typesMap.get(type.cls.getName()).charValue();
            if (valueStr.contains(";")) {
                valueStr = valueStr.replace(';', ',');
            }
            Object object = value = valueStr == null || valueStr.isEmpty() ? null : DataTypes.decodeValueType(typeId, valueStr);
            if (type.getCollectionCls() != null && value != null) {
                try {
                    Collection collection = type.getCollectionCls().newInstance();
                    for (int i = 0; i < Array.getLength(value); ++i) {
                        collection.add(Array.get(value, i));
                    }
                    value = collection;
                }
                catch (IllegalAccessException | InstantiationException ex) {
                    throw new IllegalArgumentException("Could not instantiate collection of class: " + type.getCollectionCls().getCanonicalName(), ex);
                }
            }
            this.setData(type.getKey(), value);
        }
    }

    public void setVHost(String vhost) throws TigaseStringprepException {
        if (vhost == null) {
            vhost = "";
        }
        this.vhost = JID.jidInstance((String)vhost);
    }

    public void setVHost(JID vhost) {
        this.vhost = vhost;
    }

    public String[] getSaslAllowedMechanisms() {
        return this.saslAllowedMechanisms;
    }

    public void setSaslAllowedMechanisms(String[] saslAllowedMechanisms) {
        this.saslAllowedMechanisms = saslAllowedMechanisms == null || saslAllowedMechanisms.length == 0 ? null : saslAllowedMechanisms;
    }

    protected void initializeFromDefaults(VHostItemDefaults vhostDefaults) {
        if (vhostDefaults.getTrusted() != null) {
            this.data.put(TRUSTED_JIDS_ATT, vhostDefaults.getTrusted());
        }
        this.maxUsersNumber = vhostDefaults.getMaxUsersNumber();
        this.messageForward = vhostDefaults.getMessageForward();
        this.presenceForward = vhostDefaults.getPresenceForward();
        this.tlsRequired = vhostDefaults.isTlsRequired();
        this.s2sSecret = vhostDefaults.getS2sSecret();
        this.registerEnabled = vhostDefaults.isRegisterEnabled();
        this.domainFilter = vhostDefaults.getDomainFilter();
        this.domainFilterDomains = vhostDefaults.getDomainFilterDomains();
        this.anonymousEnabled = vhostDefaults.isAnonymousEnabled();
        if (this.s2sSecret == null) {
            this.s2sSecret = UUID.randomUUID().toString();
        }
        this.defaults = vhostDefaults;
    }

    private int[] parseIntArray(String tmp, String separator) {
        int[] c2s_ports_allowed = null;
        if (tmp != null && !tmp.isEmpty()) {
            String[] tmpPorts = tmp.split(separator);
            c2s_ports_allowed = new int[tmpPorts.length];
            int filled = 0;
            for (String portStr : tmpPorts) {
                try {
                    c2s_ports_allowed[filled] = Integer.parseInt(portStr);
                    ++filled;
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, "Can not parse allowed c2s port: {0}", portStr);
                }
            }
            if (filled == 0) {
                c2s_ports_allowed = null;
            } else if (filled < c2s_ports_allowed.length) {
                c2s_ports_allowed = Arrays.copyOf(c2s_ports_allowed, filled);
            }
            if (c2s_ports_allowed != null) {
                Arrays.sort(c2s_ports_allowed);
            }
        }
        return c2s_ports_allowed;
    }

    private String intArrayToString(int[] arr, String separator) {
        if (arr == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                buf.append(separator);
            }
            buf.append(arr[i]);
        }
        return buf.toString();
    }

    private String stringArrayToString(String[] arr, String separator) {
        if (arr == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                buf.append(separator);
            }
            buf.append(arr[i]);
        }
        return buf.toString();
    }

    static {
        ArrayList<DataType> types = new ArrayList<DataType>();
        types.add(new DataType("clientCertCA", "Client Certificate CA", String.class, (Object)null));
        types.add(new DataType("clientCertRequired", "Client Certificate Required", Boolean.class, Boolean.FALSE));
        types.add(new DataType(TRUSTED_JIDS_ATT, "Trusted JIDs", String[].class, ConcurrentSkipListSet.class, null, null));
        VHostItem.registerData(types);
    }

    private class UnmodifiableVHostItem
    extends VHostItem {
        private UnmodifiableVHostItem() {
        }

        @Override
        public void initFromElement(Element elem) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public void initFromPropertyString(String propString) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public Element toElement() {
            return VHostItem.this.toElement();
        }

        @Override
        public String toString() {
            return VHostItem.this.toString();
        }

        @Override
        public String[] getComps() {
            return VHostItem.this.getComps();
        }

        @Override
        public void setComps(String[] comps) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public <T> T getData(String key) {
            return VHostItem.this.getData(key);
        }

        @Override
        public DomainFilterPolicy getDomainFilter() {
            return VHostItem.this.getDomainFilter();
        }

        @Override
        public void setDomainFilter(DomainFilterPolicy filter) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public String[] getDomainFilterDomains() {
            return VHostItem.this.getDomainFilterDomains();
        }

        @Override
        public void setDomainFilterDomains(String[] domainFilterDomains) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public String getKey() {
            return VHostItem.this.getKey();
        }

        @Override
        public long getMaxUsersNumber() {
            return VHostItem.this.getMaxUsersNumber();
        }

        @Override
        public void setMaxUsersNumber(long maxUsersNumber) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public JID getMessageForward() {
            return VHostItem.this.messageForward;
        }

        @Override
        public void setMessageForward(JID messageForward) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public String getOtherDomainParams() {
            return VHostItem.this.getOtherDomainParams();
        }

        @Override
        public void setOtherDomainParams(String otherParams) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public JID getPresenceForward() {
            return VHostItem.this.presenceForward;
        }

        @Override
        public void setPresenceForward(JID presenceForward) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public String getS2sSecret() {
            return VHostItem.this.getS2sSecret();
        }

        @Override
        public void setS2sSecret(String s2sSecret) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public String[] getSaslAllowedMechanisms() {
            return VHostItem.this.getSaslAllowedMechanisms();
        }

        @Override
        public Set<String> getTrustedJIDs() {
            return Collections.unmodifiableSet(VHostItem.this.getTrustedJIDs());
        }

        @Override
        public VHostItem getUnmodifiableVHostItem() {
            return this;
        }

        @Override
        public JID getVhost() {
            return VHostItem.this.getVhost();
        }

        @Override
        public boolean isAnonymousEnabled() {
            return VHostItem.this.isAnonymousEnabled();
        }

        @Override
        public void setAnonymousEnabled(boolean enabled) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public boolean isData(String key) {
            return VHostItem.this.isData(key);
        }

        @Override
        public boolean isEnabled() {
            return VHostItem.this.isEnabled();
        }

        @Override
        public void setEnabled(boolean enabled) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public boolean isRegisterEnabled() {
            return VHostItem.this.isRegisterEnabled();
        }

        @Override
        public void setRegisterEnabled(boolean enabled) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public boolean isTlsRequired() {
            return VHostItem.this.isTlsRequired();
        }

        @Override
        public void setTlsRequired(boolean enabled) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public boolean isTrustedJID(JID jid) {
            return VHostItem.this.isTrustedJID(jid);
        }

        @Override
        public void setC2SPortsAllowed(int[] ports) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        public void setData(String key, Object value) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }

        @Override
        protected void initializeFromDefaults(VHostItemDefaults vhostDefaults) {
            throw new UnsupportedOperationException("This is unmodifiable instance of VHostItem");
        }
    }

    public static class DataType {
        private final Class cls;
        private final Class collectionCls;
        private final Object defValue;
        private final String key;
        private final String name;
        private final Object[] options;
        private final String[] optionsNames;

        public DataType(String key, String name, Class cls, Class<? extends Collection> collectionCls, Object defValue, Object[] options, String[] optionsNames) {
            this.key = key;
            this.name = name;
            this.cls = cls;
            this.collectionCls = collectionCls;
            this.defValue = defValue;
            this.options = options;
            this.optionsNames = optionsNames;
            if (defValue != null && !cls.isAssignableFrom(defValue.getClass())) {
                throw new IllegalArgumentException("default value parameter must be of class " + cls.getCanonicalName());
            }
            if (options != null) {
                for (Object option : options) {
                    if (option == null || cls.isAssignableFrom(option.getClass())) continue;
                    throw new IllegalArgumentException("option values must of class " + cls.getCanonicalName());
                }
                if (optionsNames != null && options.length != optionsNames.length) {
                    throw new IllegalArgumentException("if passed options name must be specified for each option");
                }
            }
        }

        public DataType(String key, String name, Class cls, Class<? extends Collection> collectionCls, Object defValue, Object[] options) {
            this(key, name, cls, collectionCls, defValue, options, null);
        }

        public DataType(String key, String name, Class cls, Class<? extends Collection> collectionCls, Object defValue) {
            this(key, name, cls, collectionCls, defValue, null, null);
        }

        public DataType(String key, String name, Class cls, Object defValue, Object[] options) {
            this(key, name, cls, null, defValue, options, null);
        }

        public DataType(String key, String name, Class cls, Object defValue) {
            this(key, name, cls, null, defValue, null, null);
        }

        public <E extends Enum<E>> DataType(String key, String name, Class<? extends Enum<E>> e, E defValue) {
            String[] options = new String[defValue != null ? e.getEnumConstants().length : e.getEnumConstants().length + 1];
            int idx = 0;
            if (defValue == null) {
                options[idx++] = null;
            }
            for (Enum<E> en : e.getEnumConstants()) {
                options[idx++] = en.name();
            }
            this.key = key;
            this.name = name;
            this.cls = String.class;
            this.collectionCls = null;
            this.defValue = defValue != null ? defValue.name() : null;
            this.options = options;
            this.optionsNames = null;
        }

        public String getName() {
            return this.name;
        }

        public String getKey() {
            return this.key;
        }

        public Class getCls() {
            return this.cls;
        }

        public Class<? extends Collection> getCollectionCls() {
            return this.collectionCls;
        }

        public <T> T getDefValue() {
            return (T)this.defValue;
        }

        public <T> T[] getOptions() {
            return this.options;
        }

        public String[] getOptionsNames() {
            return this.optionsNames;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.key).append(':');
            sb.append(this.name).append(" @ ");
            sb.append(this.cls);
            return sb.toString();
        }
    }
}

