/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppserver.proc;

import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Logger;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.Packet;
import tigase.server.xmppserver.S2SIOService;
import tigase.server.xmppserver.S2SProcessor;
import tigase.server.xmppserver.proc.S2SAbstract;
import tigase.xml.Element;

public abstract class S2SAbstractProcessor
extends S2SAbstract
implements S2SProcessor {
    private static final Logger log = Logger.getLogger(S2SAbstractProcessor.class.getName());
    @ConfigField(desc="Skip StartTLS for domains", alias="skip-tls-hostnames")
    private String[] skipTlsHosts;

    @Override
    public boolean process(Packet p, S2SIOService serv, Queue<Packet> results) {
        return false;
    }

    @Override
    public void serviceStarted(S2SIOService serv) {
    }

    @Override
    public void serviceStopped(S2SIOService serv) {
    }

    public boolean skipTLSForHost(String hostname) {
        if (this.skipTlsHosts != null) {
            for (String host : this.skipTlsHosts) {
                if (!hostname.equalsIgnoreCase(host)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void streamClosed(S2SIOService serv) {
    }

    @Override
    public void streamFeatures(S2SIOService serv, List<Element> results) {
    }

    @Override
    public String streamOpened(S2SIOService serv, Map<String, String> attribs) {
        return null;
    }

    @Override
    public int compareTo(S2SProcessor proc) {
        return -1 * (proc.order() - this.order());
    }

    protected static enum Order {
        StreamOpen,
        StreamError,
        StreamFeatures,
        StartTLS,
        StartZlib,
        Dialback;

    }
}

