/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppserver;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.xmppserver.CID;
import tigase.server.xmppserver.CIDConnections;
import tigase.server.xmppserver.S2SConnection;
import tigase.xmpp.XMPPIOService;

public class S2SIOService
extends XMPPIOService<Object> {
    public static final String S2S_CONNECTION_KEY = "s2s-connection-key";
    public static final String HANDSHAKING_DOMAIN_KEY = "handshaking-domain-key";
    protected static final String HANDSHAKING_ONLY_KEY = "handshaking-only-key";
    private static final Logger log = Logger.getLogger(S2SIOService.class.getName());
    private Set<CID> authenticatedCIDs = new CopyOnWriteArraySet<CID>();
    private CIDConnections cid_conns = null;
    private String dbKey = null;
    private S2SConnection s2s_conn = null;
    private String session_id = null;

    public void addCID(CID cid) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "{0}, Adding CID to authenticated: {1}", new Object[]{this, cid});
        }
        this.authenticatedCIDs.add(cid);
    }

    public Set<CID> getCIDs() {
        return this.authenticatedCIDs;
    }

    public S2SConnection getS2SConnection() {
        return this.s2s_conn;
    }

    public void setS2SConnection(S2SConnection s2s_conn) {
        this.s2s_conn = s2s_conn;
    }

    public String getSessionId() {
        return this.session_id;
    }

    public void setSessionId(String session_id) {
        this.session_id = session_id;
    }

    public boolean isAuthenticated(CID cid) {
        return this.authenticatedCIDs.contains(cid);
    }

    public boolean isAuthenticated() {
        return this.authenticatedCIDs.size() > 0;
    }

    public boolean isHandshakingOnly() {
        return this.getSessionData().get(HANDSHAKING_ONLY_KEY) != null;
    }

    public void setDBKey(String key) {
        this.dbKey = key;
    }

    @Override
    public String toString() {
        CID cid = (CID)this.getSessionData().get("cid");
        return "CID: " + cid + ", " + super.toString();
    }
}

