/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.test;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import tigase.component.AbstractKernelBasedComponent;
import tigase.component.modules.impl.DiscoveryModule;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.core.Kernel;
import tigase.server.Packet;
import tigase.server.test.TestSpamModule;
import tigase.stats.StatisticsList;

@Bean(name="test", parent=Kernel.class, active=false)
public class TestComponent
extends AbstractKernelBasedComponent {
    private static final Logger log = Logger.getLogger(TestComponent.class.getName());
    @Inject(nullAllowed=true)
    private TestSpamModule spamTestModule;

    @Override
    public String getDiscoCategoryType() {
        return "spam";
    }

    @Override
    public String getDiscoDescription() {
        return "Spam filtering";
    }

    @Override
    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        if (null != this.spamTestModule) {
            list.add(this.getName(), "Spam messages found", this.spamTestModule.getTotalSpamCounter(), Level.INFO);
            list.add(this.getName(), "All messages processed", this.spamTestModule.getMessagesCounter(), Level.FINE);
        }
        if (list.checkLevel(Level.FINEST)) {
            // empty if block
        }
    }

    @Override
    public int hashCodeForPacket(Packet packet) {
        if (packet.getElemTo() != null) {
            return packet.getElemTo().hashCode();
        }
        if (packet.getElemFrom() != null) {
            return packet.getElemFrom().hashCode();
        }
        return 1;
    }

    @Override
    public void initBindings(Bindings binds) {
        super.initBindings(binds);
        if (null != this.spamTestModule) {
            this.spamTestModule.initBindings(binds);
        }
    }

    @Override
    public boolean isDiscoNonAdmin() {
        return true;
    }

    @Override
    public int processingInThreads() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public int processingOutThreads() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    protected void registerModules(Kernel kernel) {
        kernel.registerBean("disco").asClass(DiscoveryModule.class).exec();
    }
}

