/*
 * Decompiled with CFR 0.152.
 */
package tigase.net;

import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IOUtil {
    private static final Logger log = Logger.getLogger(IOUtil.class.getCanonicalName());
    private static final String DIRECT_BUFFER_DEFAULT_SIZE = "direct-buffer-default-size";
    private static final ThreadLocal<BufferCache> buffers = new ThreadLocal();
    private static int bufferSize;

    public static ByteBuffer getDirectBuffer(int size) {
        BufferCache cache = buffers.get();
        if (cache == null) {
            cache = new BufferCache(bufferSize);
            buffers.set(cache);
        }
        return cache.get(size);
    }

    public static void returnDirectBuffer(ByteBuffer buf) {
        BufferCache cache = buffers.get();
        if (cache != null) {
            cache.offer(buf);
        } else {
            log.log(Level.SEVERE, "returning direct buffer to cache, but no cache found");
        }
    }

    static {
        Integer size = Integer.getInteger(DIRECT_BUFFER_DEFAULT_SIZE);
        if (size == null) {
            Socket socket = new Socket();
            try {
                bufferSize = Math.max(socket.getReceiveBufferSize(), socket.getSendBufferSize());
            }
            catch (SocketException ex) {
                bufferSize = 65536;
            }
        } else {
            bufferSize = size;
        }
        log.log(Level.CONFIG, "using direct byte buffers with size {0} per buffer", bufferSize);
    }

    private static class BufferCache {
        private final ByteBuffer buffer;
        private int count = 1;

        public BufferCache(int size) {
            this.buffer = ByteBuffer.allocateDirect(size);
        }

        public ByteBuffer get(int size) {
            if (this.count == 1 && size <= this.buffer.capacity()) {
                this.count = 0;
                this.buffer.limit(size);
                return this.buffer;
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "allocating buffer with size = {0}", size);
            }
            return ByteBuffer.allocateDirect(size);
        }

        public void offer(ByteBuffer buffer) {
            if (this.buffer == buffer) {
                this.count = 1;
                buffer.rewind();
            }
        }
    }
}

