/*
 * Decompiled with CFR 0.152.
 */
package tigase.io;

import java.nio.ByteBuffer;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import tigase.cert.CertCheckResult;
import tigase.cert.CertificateUtil;
import tigase.io.SSLContextContainerIfc;
import tigase.io.TLSEventHandler;
import tigase.io.TLSStatus;
import tigase.io.TLSWrapper;

public class JcaTLSWrapper
implements TLSWrapper {
    private static final Logger log = Logger.getLogger(JcaTLSWrapper.class.getName());
    private int appBuffSize = 0;
    private String debugId = null;
    private TLSEventHandler eventHandler = null;
    private int netBuffSize = 0;
    private SSLEngine tlsEngine = null;
    private SSLEngineResult tlsEngineResult = null;

    public JcaTLSWrapper(SSLContext sslc, TLSEventHandler eventHandler, String hostname, int port, boolean clientMode, boolean wantClientAuth) {
        this(sslc, eventHandler, hostname, port, clientMode, wantClientAuth, false);
    }

    public JcaTLSWrapper(SSLContext sslc, TLSEventHandler eventHandler, String hostname, int port, boolean clientMode, boolean wantClientAuth, boolean needClientAuth) {
        this(sslc, eventHandler, hostname, port, clientMode, wantClientAuth, needClientAuth, null, null);
    }

    public JcaTLSWrapper(SSLContext sslc, TLSEventHandler eventHandler, String hostname, int port, boolean clientMode, boolean wantClientAuth, boolean needClientAuth, String[] enabledCiphers, String[] enabledProtocols) {
        this.tlsEngine = clientMode && hostname != null ? sslc.createSSLEngine(hostname, port) : sslc.createSSLEngine();
        this.tlsEngine.setUseClientMode(clientMode);
        if (enabledCiphers != null) {
            this.tlsEngine.setEnabledCipherSuites(enabledCiphers);
        }
        if (enabledProtocols != null) {
            this.tlsEngine.setEnabledProtocols(enabledProtocols);
        }
        this.netBuffSize = this.tlsEngine.getSession().getPacketBufferSize();
        this.appBuffSize = Math.min(eventHandler.getSocketInputSize(), this.tlsEngine.getSession().getApplicationBufferSize());
        this.eventHandler = eventHandler;
        if (!clientMode && wantClientAuth) {
            this.tlsEngine.setWantClientAuth(true);
        }
        if (!clientMode && needClientAuth) {
            this.tlsEngine.setNeedClientAuth(true);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Created " + (clientMode ? "client" : "server") + " TLSWrapper. Protocols:" + (this.tlsEngine.getEnabledProtocols() == null ? " default" : Arrays.toString(this.tlsEngine.getEnabledProtocols())) + "; Ciphers:" + (this.tlsEngine.getEnabledCipherSuites() == null ? " default" : Arrays.toString(this.tlsEngine.getEnabledCipherSuites())));
        }
    }

    @Override
    public int bytesConsumed() {
        return this.tlsEngineResult.bytesConsumed();
    }

    @Override
    public void close() throws SSLException {
        this.tlsEngine.closeOutbound();
        this.tlsEngine.getSession().invalidate();
    }

    @Override
    public int getAppBuffSize() {
        return this.appBuffSize;
    }

    @Override
    public CertCheckResult getCertificateStatus(boolean revocationEnabled, SSLContextContainerIfc sslContextContainer) {
        Certificate[] peerChain = null;
        try {
            peerChain = this.tlsEngine.getSession().getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException ex) {
            return CertCheckResult.none;
        }
        try {
            return CertificateUtil.validateCertificate((Certificate[])peerChain, (KeyStore)sslContextContainer.getTrustStore(), (boolean)revocationEnabled);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Problem validating certificate", ex);
            return CertCheckResult.invalid;
        }
    }

    @Override
    public SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        return this.tlsEngine.getHandshakeStatus();
    }

    @Override
    public Certificate[] getLocalCertificates() {
        return this.tlsEngine.getSession().getLocalCertificates();
    }

    @Override
    public int getNetBuffSize() {
        return this.netBuffSize;
    }

    @Override
    public int getPacketBuffSize() {
        return this.tlsEngine.getSession().getPacketBufferSize();
    }

    @Override
    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        return this.tlsEngine.getSession().getPeerCertificates();
    }

    @Override
    public TLSStatus getStatus() {
        TLSStatus status = null;
        if (this.tlsEngineResult != null && this.tlsEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
            status = TLSStatus.UNDERFLOW;
        } else if (this.tlsEngineResult != null && this.tlsEngineResult.getStatus() == SSLEngineResult.Status.CLOSED) {
            status = TLSStatus.CLOSED;
        } else {
            switch (this.tlsEngine.getHandshakeStatus()) {
                case NEED_WRAP: {
                    status = TLSStatus.NEED_WRITE;
                    break;
                }
                case NEED_UNWRAP: {
                    status = TLSStatus.NEED_READ;
                    break;
                }
                default: {
                    status = TLSStatus.OK;
                }
            }
        }
        return status;
    }

    @Override
    public byte[] getTlsUniqueBindingData() {
        return null;
    }

    @Override
    public boolean isClientMode() {
        return this.tlsEngine.getUseClientMode();
    }

    @Override
    public boolean isNeedClientAuth() {
        return this.tlsEngine.getNeedClientAuth();
    }

    @Override
    public void setDebugId(String id) {
        this.debugId = id;
    }

    @Override
    public ByteBuffer unwrap(ByteBuffer net, ByteBuffer app) throws SSLException {
        ByteBuffer out = app;
        out.order(app.order());
        this.tlsEngineResult = this.tlsEngine.unwrap(net, out);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "{0}, unwrap() tlsEngineRsult.getStatus() = {1}, tlsEngineRsult.getHandshakeStatus() = {2}", new Object[]{this.debugId, this.tlsEngineResult.getStatus(), this.tlsEngineResult.getHandshakeStatus()});
        }
        if (this.tlsEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED && this.eventHandler != null) {
            this.eventHandler.handshakeCompleted(this);
        }
        if (this.tlsEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
            out = this.resizeApplicationBuffer(net, out);
            this.tlsEngineResult = this.tlsEngine.unwrap(net, out);
        }
        if (this.tlsEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            this.doTasks();
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "unwrap() doTasks(), handshake: {0}, {1}", new Object[]{this.tlsEngine.getHandshakeStatus(), this.debugId});
            }
        }
        return out;
    }

    @Override
    public boolean wantClientAuth() {
        return this.tlsEngine.getWantClientAuth();
    }

    @Override
    public void wrap(ByteBuffer app, ByteBuffer net) throws SSLException {
        this.tlsEngineResult = this.tlsEngine.wrap(app, net);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "{0}, tlsEngineRsult.getStatus() = {1}, tlsEngineRsult.getHandshakeStatus() = {2}", new Object[]{this.debugId, this.tlsEngineResult.getStatus(), this.tlsEngineResult.getHandshakeStatus()});
        }
        if (this.tlsEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED && this.eventHandler != null) {
            this.eventHandler.handshakeCompleted(this);
        }
        if (this.tlsEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            this.doTasks();
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "doTasks(): {0}, {1}", new Object[]{this.tlsEngine.getHandshakeStatus(), this.debugId});
            }
        }
    }

    private void doTasks() {
        Runnable runnable = null;
        while ((runnable = this.tlsEngine.getDelegatedTask()) != null) {
            runnable.run();
        }
    }

    private ByteBuffer resizeApplicationBuffer(ByteBuffer net, ByteBuffer app) {
        int newSize = app.capacity() * 2;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Resizing tlsInput to {0} bytes, {1}", new Object[]{newSize, this.debugId});
        }
        ByteBuffer bb = ByteBuffer.allocate(newSize);
        bb.order(app.order());
        app.flip();
        bb.put(app);
        return bb;
    }
}

