/*
 * Decompiled with CFR 0.152.
 */
package tigase.eventbus.component;

import java.io.Serializable;
import java.util.Collection;
import java.util.logging.Level;
import tigase.component.exceptions.ComponentException;
import tigase.criteria.Criteria;
import tigase.eventbus.EventRoutingSelector;
import tigase.eventbus.component.AbstractEventBusModule;
import tigase.eventbus.component.EventBusComponent;
import tigase.eventbus.component.stores.Subscription;
import tigase.eventbus.component.stores.SubscriptionStore;
import tigase.eventbus.impl.AbstractHandler;
import tigase.eventbus.impl.EventBusImplementation;
import tigase.eventbus.impl.EventBusSerializer;
import tigase.eventbus.impl.EventName;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.server.Packet;
import tigase.server.Permissions;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.jid.JID;

@Bean(name="publisher", active=true)
public class EventPublisherModule
extends AbstractEventBusModule
implements Initializable,
UnregisterAware {
    public static final String ID = "publisher";
    @Inject
    private EventBusComponent component;
    @Inject(nullAllowed=false, bean="localEventBus")
    private EventBusImplementation localEventBus;
    private EventBusSerializer serializer = new EventBusSerializer();
    @Inject
    private SubscriptionStore subscriptionStore;
    private final AbstractHandler firedEventHandler = new AbstractHandler(null, null){

        @Override
        public void dispatch(Object event, Object source, boolean remotelyGeneratedEvent) {
            if (remotelyGeneratedEvent) {
                return;
            }
            if (event instanceof Element) {
                EventPublisherModule.this.publishEvent((Element)event);
            } else if (!(event instanceof EventBusImplementation.InternalEventbusEvent)) {
                EventPublisherModule.this.publishObjectEvent(event);
            }
        }

        @Override
        public AbstractHandler.Type getRequiredEventType() {
            return AbstractHandler.Type.asIs;
        }
    };

    @Override
    public void beforeUnregister() {
        this.localEventBus.removeHandler(this.firedEventHandler);
    }

    @Override
    public String[] getFeatures() {
        return null;
    }

    @Override
    public Criteria getModuleCriteria() {
        return null;
    }

    @Override
    public void initialize() {
        this.localEventBus.addHandler(this.firedEventHandler);
    }

    @Override
    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
    }

    public void publishEvent(Element event) {
        EventName en = new EventName(event.getName());
        String isRemote = event.getAttributeStaticStr("remote");
        if (isRemote != null && ("true".equals(isRemote) || "1".equals(isRemote))) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("Remote event. No need to redistribute this way. " + event.toString());
            }
            return;
        }
        String isLocal = event.getAttributeStaticStr("local");
        if (isLocal != null && ("true".equals(isLocal) || "1".equals(isLocal))) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("Event for local subscribers only. Skipping. " + event.toString());
            }
            return;
        }
        Collection<Subscription> subscribers = this.subscriptionStore.getSubscribersJIDs(en.getPackage(), en.getName());
        this.publishEvent(en.getPackage(), en.getName(), event, subscribers);
    }

    public void publishEvent(String eventPackage, String name, Element event, Collection<Subscription> subscribers) {
        try {
            Element eventElem = new Element("event", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub#event"});
            Element itemsElem = new Element("items", new String[]{"node"}, new String[]{EventName.toString(eventPackage, name)});
            eventElem.addChild((XMLNodeIfc)itemsElem);
            Element itemElem = new Element("item");
            itemElem.addChild((XMLNodeIfc)event);
            itemsElem.addChild((XMLNodeIfc)itemElem);
            if (this.log.isLoggable(Level.FINER)) {
                this.log.log(Level.FINER, "Sending event ({0}, {1}, {2}) to {3}", new Object[]{name, eventPackage, event, subscribers});
            }
            for (Subscription subscriber : subscribers) {
                String from = subscriber.getServiceJID() == null ? this.component.getComponentId().toString() : subscriber.getServiceJID().toString();
                JID toJID = subscriber.getJid();
                this.publishEvent(eventElem, from, toJID);
            }
        }
        catch (Exception e) {
            this.log.log(Level.FINEST, "Error publishing event", e);
        }
    }

    public void publishObjectEvent(Object event) {
        String eventName;
        if (!(event instanceof Serializable)) {
            return;
        }
        Class<?> eventClass = event.getClass();
        String packageName = eventClass.getPackage().getName();
        Collection<Subscription> subscribers = this.getSubscribers(packageName, eventName = eventClass.getSimpleName(), event);
        if (subscribers.isEmpty()) {
            return;
        }
        Element eventElement = this.serializer.serialize(event);
        this.publishEvent(packageName, eventName, eventElement, subscribers);
    }

    protected Collection<Subscription> getSubscribers(String packageName, String eventName, Object event) {
        Collection<Subscription> subscribers = this.subscriptionStore.getSubscribersJIDs(packageName, eventName);
        EventRoutingSelector selector = this.localEventBus.getEventRoutingSelector(event.getClass());
        if (selector != null) {
            subscribers = selector.getSubscriptions(event, subscribers);
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, "for event {0}, found subscribers using selector: {1}", new Object[]{event.getClass().getCanonicalName(), selector.getClass()});
            }
        }
        return subscribers;
    }

    private void publishEvent(Element pubsubEventElem, String from, JID toJID) throws TigaseStringprepException {
        Packet message = Packet.packetInstance(new Element("message", new String[]{"to", "from", "id"}, new String[]{toJID.toString(), from, this.nextStanzaID()}));
        message.getElement().addChild((XMLNodeIfc)pubsubEventElem);
        message.setXMLNS("jabber:client");
        message.setPermissions(Permissions.ADMIN);
        this.write(message);
    }
}

