/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.AuthRepository;
import tigase.db.AuthRepositoryImpl;
import tigase.db.AuthorizationException;
import tigase.db.DBInitException;
import tigase.db.DataSourceAware;
import tigase.db.Repository;
import tigase.db.TigaseDBException;
import tigase.db.UserExistsException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.db.xml.XMLDataSource;
import tigase.xml.db.NodeExistsException;
import tigase.xml.db.NodeNotFoundException;
import tigase.xml.db.XMLDB;
import tigase.xmpp.jid.BareJID;

@Repository.Meta(supportedUris={"memory://.*"})
public class XMLRepository
implements Repository,
DataSourceAware<XMLDataSource>,
AuthRepository,
UserRepository {
    private static final String USER_STR = "User: ";
    private static final String NOT_FOUND_STR = " has not been found in repository.";
    private static final Logger log = Logger.getLogger("tigase.db.xml.XMLRepository");
    private AuthRepository auth = null;
    private boolean autoCreateUser = false;
    private XMLDB xmldb = null;

    @Override
    public synchronized void addDataList(BareJID user, String subnode, String key, String[] list) throws UserNotFoundException, TigaseDBException {
        log.log(Level.FINEST, "Adding data list, user: {0}, subnode: {1}, key: {2}, list: {3}", new Object[]{user, subnode, key, Arrays.asList(list)});
        try {
            String[] old_data = this.getDataList(user, subnode, key);
            String[] all = null;
            if (old_data != null) {
                all = new String[old_data.length + list.length];
                System.arraycopy(old_data, 0, all, 0, old_data.length);
                System.arraycopy(list, 0, all, old_data.length, list.length);
                this.xmldb.setData(user.toString(), subnode, key, (Object)all);
            } else {
                this.xmldb.setData(user.toString(), subnode, key, (Object)list);
            }
        }
        catch (NodeNotFoundException e) {
            throw new UserNotFoundException(USER_STR + user + NOT_FOUND_STR, e);
        }
    }

    @Override
    public synchronized void addUser(BareJID user) throws UserExistsException {
        log.log(Level.FINEST, "adding new user, user: {0}", new Object[]{user});
        try {
            this.xmldb.addNode1(user.toString());
        }
        catch (NodeExistsException e) {
            throw new UserExistsException(USER_STR + user + " already exists.", e);
        }
    }

    @Override
    public synchronized void addUser(BareJID user, String password) throws UserExistsException, TigaseDBException {
        this.auth.addUser(user, password);
    }

    @Override
    public synchronized String getData(BareJID user, String subnode, String key, String def) throws UserNotFoundException, TigaseDBException {
        log.log(Level.FINEST, "Getting data, user: {0}, subnode: {1}, key: {2}", new Object[]{user, subnode, key});
        try {
            return (String)this.xmldb.getData(user.toString(), subnode, key, (Object)def);
        }
        catch (NodeNotFoundException e) {
            if (this.autoCreateUser) {
                try {
                    this.addUser(user);
                    return (String)this.xmldb.getData(user.toString(), subnode, key, (Object)def);
                }
                catch (Exception ex) {
                    throw new TigaseDBException("Unknown repository problem: ", ex);
                }
            }
            throw new UserNotFoundException(USER_STR + user + NOT_FOUND_STR, e);
        }
    }

    @Override
    public String getData(BareJID user, String subnode, String key) throws UserNotFoundException, TigaseDBException {
        return this.getData(user, subnode, key, null);
    }

    @Override
    public String getData(BareJID user, String key) throws UserNotFoundException, TigaseDBException {
        return this.getData(user, null, key, null);
    }

    @Override
    public synchronized String[] getDataList(BareJID user, String subnode, String key) throws UserNotFoundException, TigaseDBException {
        log.log(Level.FINEST, "Getting data list, user: {0}, subnode: {1}, key: {2}", new Object[]{user, subnode, key});
        try {
            return this.xmldb.getDataList(user.toString(), subnode, key);
        }
        catch (NodeNotFoundException e) {
            if (this.autoCreateUser) {
                try {
                    this.addUser(user);
                    return this.xmldb.getDataList(user.toString(), subnode, key);
                }
                catch (Exception ex) {
                    throw new TigaseDBException("Unknown repository problem: ", ex);
                }
            }
            throw new UserNotFoundException(USER_STR + user + NOT_FOUND_STR, e);
        }
    }

    @Override
    public synchronized String[] getKeys(BareJID user, String subnode) throws UserNotFoundException, TigaseDBException {
        log.log(Level.FINEST, "Getting keys, user: {0}, subnode: {1}", new Object[]{user, subnode});
        try {
            return this.xmldb.getKeys(user.toString(), subnode);
        }
        catch (NodeNotFoundException e) {
            if (this.autoCreateUser) {
                try {
                    this.addUser(user);
                    return this.xmldb.getKeys(user.toString(), subnode);
                }
                catch (Exception ex) {
                    throw new TigaseDBException("Unknown repository problem: ", ex);
                }
            }
            throw new UserNotFoundException(USER_STR + user + NOT_FOUND_STR, e);
        }
    }

    @Override
    public String[] getKeys(BareJID user) throws UserNotFoundException, TigaseDBException {
        return this.getKeys(user, null);
    }

    @Override
    public String getResourceUri() {
        return this.xmldb.getDBFileName();
    }

    @Override
    public synchronized String[] getSubnodes(BareJID user, String subnode) throws UserNotFoundException, TigaseDBException {
        log.log(Level.FINEST, "Getting subnodes, user: {0}, subnode: {1}", new Object[]{user, subnode});
        try {
            return this.xmldb.getSubnodes(user.toString(), subnode);
        }
        catch (NodeNotFoundException e) {
            if (this.autoCreateUser) {
                try {
                    this.addUser(user);
                    return this.xmldb.getSubnodes(user.toString(), subnode);
                }
                catch (Exception ex) {
                    throw new TigaseDBException("Unknown repository problem: ", ex);
                }
            }
            throw new UserNotFoundException(USER_STR + user + NOT_FOUND_STR, e);
        }
    }

    @Override
    public String[] getSubnodes(BareJID user) throws UserNotFoundException, TigaseDBException {
        return this.getSubnodes(user, null);
    }

    @Override
    public long getUserUID(BareJID user) throws TigaseDBException {
        return Math.abs(user.hashCode());
    }

    @Override
    public synchronized List<BareJID> getUsers() {
        List users = this.xmldb.getAllNode1s();
        log.log(Level.FINEST, "Getting users, users: {0}, xmldb: {1}", new Object[]{users, this.xmldb});
        ArrayList<BareJID> result = new ArrayList<BareJID>();
        for (String usr : users) {
            result.add(BareJID.bareJIDInstanceNS((String)usr));
        }
        return result;
    }

    @Override
    public synchronized long getUsersCount(String domain) {
        long res = 0L;
        List<BareJID> jids = this.getUsers();
        for (BareJID jid : jids) {
            if (!jid.getDomain().equals(domain)) continue;
            ++res;
        }
        return res;
    }

    @Override
    public synchronized long getUsersCount() {
        return this.xmldb.getAllNode1sCount();
    }

    @Override
    @Deprecated
    public synchronized void initRepository(String file, Map<String, String> params) throws DBInitException {
        if (this.xmldb == null) {
            log.log(Level.FINEST, "Initializing repository, file: {0}, params: {1}", new Object[]{file, params});
            XMLDataSource dataSource = new XMLDataSource();
            dataSource.initRepository(file, params);
            this.setDataSource(dataSource);
        }
    }

    @Override
    public synchronized void logout(BareJID user) throws UserNotFoundException, TigaseDBException {
        this.auth.logout(user);
    }

    @Override
    public void loggedIn(BareJID user) throws TigaseDBException {
        this.auth.loggedIn(user);
    }

    @Override
    public synchronized boolean otherAuth(Map<String, Object> props) throws UserNotFoundException, TigaseDBException, AuthorizationException {
        return this.auth.otherAuth(props);
    }

    @Override
    public synchronized void queryAuth(Map<String, Object> authProps) {
        this.auth.queryAuth(authProps);
    }

    @Override
    public synchronized void removeData(BareJID user, String subnode, String key) throws UserNotFoundException {
        block2: {
            log.log(Level.FINEST, "Removing data, user: {0}, subnode: {1}, key: {2}", new Object[]{user, subnode, key});
            try {
                this.xmldb.removeData(user.toString(), subnode, key);
            }
            catch (NodeNotFoundException e) {
                if (this.autoCreateUser) break block2;
                throw new UserNotFoundException(USER_STR + user + NOT_FOUND_STR, e);
            }
        }
    }

    @Override
    public void removeData(BareJID user, String key) throws UserNotFoundException {
        this.removeData(user, null, key);
    }

    @Override
    public synchronized void removeSubnode(BareJID user, String subnode) throws UserNotFoundException {
        block2: {
            log.log(Level.FINEST, "Removing subnode, user: {0}, subnode: {1}", new Object[]{user, subnode});
            try {
                this.xmldb.removeSubnode(user.toString(), subnode);
            }
            catch (NodeNotFoundException e) {
                if (this.autoCreateUser) break block2;
                throw new UserNotFoundException(USER_STR + user + NOT_FOUND_STR, e);
            }
        }
    }

    @Override
    public synchronized void removeUser(BareJID user) throws UserNotFoundException {
        try {
            log.log(Level.FINEST, "Removing user: {0}", new Object[]{user});
            this.xmldb.removeNode1(user.toString());
        }
        catch (NodeNotFoundException e) {
            throw new UserNotFoundException(USER_STR + user + NOT_FOUND_STR, e);
        }
    }

    @Override
    public synchronized void setData(BareJID user, String subnode, String key, String value) throws UserNotFoundException, TigaseDBException {
        log.log(Level.FINEST, "Setting data, user: {0}, subnode: {1}, key: {2}, value: {3}", new Object[]{user, subnode, key, value});
        try {
            this.xmldb.setData(user.toString(), subnode, key, (Object)value);
        }
        catch (NodeNotFoundException e) {
            if (this.autoCreateUser) {
                try {
                    this.addUser(user);
                    this.xmldb.setData(user.toString(), subnode, key, (Object)value);
                }
                catch (Exception ex) {
                    throw new TigaseDBException("Unknown repository problem: ", ex);
                }
            }
            throw new UserNotFoundException(USER_STR + user + NOT_FOUND_STR, e);
        }
    }

    @Override
    public void setData(BareJID user, String key, String value) throws UserNotFoundException, TigaseDBException {
        this.setData(user, null, key, value);
    }

    @Override
    public synchronized void setDataList(BareJID user, String subnode, String key, String[] list) throws UserNotFoundException, TigaseDBException {
        log.log(Level.FINEST, "Setting data list, user: {0}, subnode: {1}, key: {2}, value: {3}", new Object[]{user, subnode, key, Arrays.asList(list)});
        try {
            this.xmldb.setData(user.toString(), subnode, key, (Object)list);
        }
        catch (NodeNotFoundException e) {
            if (this.autoCreateUser) {
                try {
                    this.addUser(user);
                    this.xmldb.setData(user.toString(), subnode, key, (Object)list);
                }
                catch (Exception ex) {
                    throw new TigaseDBException("Unknown repository problem: ", ex);
                }
            }
            throw new UserNotFoundException(USER_STR + user + NOT_FOUND_STR, e);
        }
    }

    @Override
    public synchronized void updatePassword(BareJID user, String password) throws UserExistsException, TigaseDBException {
        this.auth.updatePassword(user, password);
    }

    @Override
    public synchronized boolean userExists(BareJID user) {
        return this.xmldb.findNode1(user.toString()) != null;
    }

    @Override
    public String getPassword(BareJID user) throws UserNotFoundException, TigaseDBException {
        return this.auth.getPassword(user);
    }

    @Override
    public boolean isUserDisabled(BareJID user) throws UserNotFoundException, TigaseDBException {
        return false;
    }

    @Override
    public void setUserDisabled(BareJID user, Boolean value) throws UserNotFoundException, TigaseDBException {
        throw new TigaseDBException("Feature not supported");
    }

    @Override
    public void setAccountStatus(BareJID user, AuthRepository.AccountStatus status) throws TigaseDBException {
        throw new TigaseDBException("Feature not supported");
    }

    @Override
    public AuthRepository.AccountStatus getAccountStatus(BareJID user) throws TigaseDBException {
        return AuthRepository.AccountStatus.active;
    }

    @Override
    public void setDataSource(XMLDataSource dataSource) {
        String file = dataSource.getResourceUri();
        if (file.contains("autoCreateUser=true")) {
            this.autoCreateUser = true;
        }
        this.xmldb = dataSource.getXMLDB();
        this.auth = new AuthRepositoryImpl(this);
    }
}

