/*
 * Decompiled with CFR 0.152.
 */
package tigase.db;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.db.DataSource;
import tigase.db.DataSourceAware;
import tigase.db.DataSourcePool;
import tigase.db.Repository;
import tigase.db.jdbc.DataRepositoryImpl;
import tigase.stats.StatisticsList;
import tigase.stats.StatisticsProviderIfc;
import tigase.util.Version;
import tigase.xmpp.jid.BareJID;

@Repository.Meta(supportedUris={"jdbc:[^:]+:.*"})
public class DataRepositoryPool
implements DataRepository,
DataSourcePool<DataRepository>,
StatisticsProviderIfc {
    private static final Logger log = Logger.getLogger(DataRepositoryPool.class.getName());
    private DataRepository.dbTypes database = null;
    private CopyOnWriteArrayList<DataRepository> repoPool = new CopyOnWriteArrayList();
    private String resource_uri = null;

    @Override
    public void addRepo(DataRepository repo) {
        this.repoPool.addIfAbsent(repo);
    }

    @Override
    public boolean automaticSchemaManagement() {
        if (this.repoPool.isEmpty()) {
            return true;
        }
        return this.repoPool.get(0).automaticSchemaManagement();
    }

    @Override
    public void checkConnectivity(Duration watchdogTime) {
        this.repoPool.forEach(repo -> repo.checkConnectivity(watchdogTime));
    }

    public DataRepository takeRepo(BareJID user_id) {
        int idx = user_id != null ? Math.abs(user_id.hashCode() % this.repoPool.size()) : 0;
        DataRepository result = null;
        try {
            result = this.repoPool.get(idx);
        }
        catch (IndexOutOfBoundsException ioobe) {
            result = this.repoPool.get(0);
        }
        return result;
    }

    public DataRepository takeRepo(int hashCode) {
        int idx = Math.abs(hashCode % this.repoPool.size());
        DataRepository result = null;
        try {
            result = this.repoPool.get(idx);
        }
        catch (IndexOutOfBoundsException ioobe) {
            result = this.repoPool.get(0);
        }
        return result;
    }

    @Override
    public DataRepository takeRepoHandle(BareJID user_id) {
        return this.takeRepo(user_id);
    }

    @Override
    public void releaseRepoHandle(DataRepository repo) {
    }

    @Override
    public boolean checkSchemaVersion(DataSourceAware<? extends DataSource> datasource, boolean shutdownServer) {
        DataRepository repo = this.takeRepo(null);
        if (repo != null) {
            return repo.checkSchemaVersion(datasource, shutdownServer);
        }
        log.log(Level.WARNING, "repo is NULL, pool empty? - {0}", this.repoPool.size());
        return false;
    }

    @Override
    public Optional<Version> getSchemaVersion(String component) {
        DataRepository repo = this.takeRepo(null);
        if (repo != null) {
            return repo.getSchemaVersion(component);
        }
        log.log(Level.WARNING, "repo is NULL, pool empty? - {0}", this.repoPool.size());
        return Optional.empty();
    }

    @Override
    public boolean checkTable(String tableName) throws SQLException {
        DataRepository repo = this.takeRepo(null);
        if (repo != null) {
            return repo.checkTable(tableName);
        }
        log.log(Level.WARNING, "repo is NULL, pool empty? - {0}", this.repoPool.size());
        return false;
    }

    @Override
    public boolean checkTable(String tableName, String createTableQuery) throws SQLException {
        DataRepository repo = this.takeRepo(null);
        if (repo != null) {
            return repo.checkTable(tableName, createTableQuery);
        }
        log.log(Level.WARNING, "repo is NULL, pool empty? - {0}", this.repoPool.size());
        return false;
    }

    @Override
    public Statement createStatement(BareJID user_id) throws SQLException {
        DataRepository repo = this.takeRepo(user_id);
        if (repo != null) {
            return repo.createStatement(user_id);
        }
        log.log(Level.WARNING, "repo is NULL, pool empty? - {0}", this.repoPool.size());
        return null;
    }

    @Override
    public PreparedStatement getPreparedStatement(BareJID user_id, String stIdKey) throws SQLException {
        DataRepository repo = this.takeRepo(user_id);
        if (repo != null) {
            return repo.getPreparedStatement(user_id, stIdKey);
        }
        log.log(Level.WARNING, "repo is NULL, pool empty? - {0}", this.repoPool.size());
        return null;
    }

    @Override
    public PreparedStatement getPreparedStatement(int hashCode, String stIdKey) throws SQLException {
        DataRepository repo = this.takeRepo(hashCode);
        if (repo != null) {
            return repo.getPreparedStatement(hashCode, stIdKey);
        }
        log.log(Level.WARNING, "repo is NULL, pool empty? - {0}", this.repoPool.size());
        return null;
    }

    @Override
    public String getResourceUri() {
        if (this.resource_uri == null && !this.repoPool.isEmpty()) {
            return this.takeRepo(null).getResourceUri();
        }
        return this.resource_uri;
    }

    @Override
    public DataRepository.dbTypes getDatabaseType() {
        return this.database;
    }

    @Override
    public void getStatistics(String compName, StatisticsList list) {
        list.add(compName, "uri", this.getResourceUri(), Level.FINE);
        list.add(compName, "connections count", this.repoPool.size(), Level.FINE);
        for (DataRepository repo : this.repoPool) {
            if (!(repo instanceof StatisticsProviderIfc)) continue;
            ((StatisticsProviderIfc)((Object)repo)).getStatistics(compName, list);
        }
    }

    @Override
    public void initPreparedStatement(String stIdKey, String query) throws SQLException {
        for (DataRepository dataRepository : this.repoPool) {
            dataRepository.initPreparedStatement(stIdKey, query);
        }
    }

    @Override
    public void initPreparedStatement(String stIdKey, String query, int autoGeneratedKeys) throws SQLException {
        for (DataRepository dataRepository : this.repoPool) {
            dataRepository.initPreparedStatement(stIdKey, query, autoGeneratedKeys);
        }
    }

    @Override
    public void initialize(String resource_uri) throws DBInitException {
        this.resource_uri = resource_uri;
        if (this.database == null) {
            this.database = DataRepositoryImpl.parseDatabaseType(resource_uri);
        }
    }

    @Override
    @Deprecated
    public void initRepository(String resource_uri, Map<String, String> params) throws DBInitException {
        this.initialize(resource_uri);
        for (DataRepository dataRepository : this.repoPool) {
            dataRepository.initRepository(resource_uri, params);
            this.database = dataRepository.getDatabaseType();
        }
    }

    @Override
    public void release(Statement stmt, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void startTransaction() throws SQLException {
    }

    @Override
    public void commit() throws SQLException {
    }

    @Override
    public void rollback() throws SQLException {
    }

    @Override
    public void endTransaction() throws SQLException {
    }

    @Override
    public int getPoolSize() {
        return this.repoPool.size();
    }
}

