/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import javax.security.sasl.SaslServerFactory;
import tigase.auth.MechanismSelector;
import tigase.auth.TigaseSaslProvider;
import tigase.auth.mechanisms.SaslSCRAMPlus;
import tigase.auth.mechanisms.TigaseSaslServerFactory;
import tigase.cert.CertificateUtil;
import tigase.db.AuthRepository;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.vhosts.VHostItem;
import tigase.xmpp.XMPPResourceConnection;

@Bean(name="mechanism-selector", parent=TigaseSaslProvider.class, active=true)
public class DefaultMechanismSelector
implements MechanismSelector {
    @ConfigField(desc="List of allowed SASL mechanisms", alias="allowed-mechanisms")
    private HashSet<String> allowedMechanisms = new HashSet();
    @ConfigField(desc="List of SASL mechanisms allowed with non-plain password stored in authentication repository", alias="non-plain-password-allowed-mechanisms")
    private HashSet<String> allowedMechanismsWithNonPlainPasswordInRepository = new HashSet();
    @Inject
    private AuthRepository authRepository;

    public DefaultMechanismSelector() {
        Stream.of("ANONYMOUS", "PLAIN", "EXTERNAL").forEach(this.allowedMechanismsWithNonPlainPasswordInRepository::add);
    }

    @Override
    public Collection<String> filterMechanisms(Enumeration<SaslServerFactory> serverFactories, XMPPResourceConnection session) {
        HashMap props = new HashMap();
        ArrayList<String> result = new ArrayList<String>();
        while (serverFactories.hasMoreElements()) {
            String[] x;
            SaslServerFactory ss = serverFactories.nextElement();
            for (String name : x = ss.getMechanismNames(props)) {
                if (result.contains(name) || !this.match(ss, name, session) || !this.isAllowedForDomain(name, session.getDomain())) continue;
                result.add(name);
            }
        }
        return result;
    }

    protected boolean isAllowedForDomain(String mechanismName, VHostItem vhost) {
        String[] saslAllowedMechanisms = vhost.getSaslAllowedMechanisms();
        if (saslAllowedMechanisms != null && saslAllowedMechanisms.length > 0) {
            for (String allowed : saslAllowedMechanisms) {
                if (!allowed.equals(mechanismName)) continue;
                return true;
            }
            return false;
        }
        if (!this.allowedMechanisms.isEmpty()) {
            return this.allowedMechanisms.contains(mechanismName);
        }
        return true;
    }

    protected boolean match(SaslServerFactory factory, String mechanismName, XMPPResourceConnection session) {
        if (session.isTlsRequired() && !session.isEncrypted()) {
            return false;
        }
        if (factory instanceof TigaseSaslServerFactory) {
            switch (mechanismName) {
                case "EXTERNAL": {
                    return this.isJIDInCertificate(session);
                }
                case "ANONYMOUS": {
                    return session.getDomain().isAnonymousEnabled();
                }
            }
            if (mechanismName.startsWith("SCRAM-") && mechanismName.endsWith("-PLUS") && !SaslSCRAMPlus.isAvailable(session)) {
                return false;
            }
            return this.authRepository.isMechanismSupported(session.getDomain().getKey(), mechanismName);
        }
        return false;
    }

    private boolean isJIDInCertificate(XMPPResourceConnection session) {
        Certificate cert = (Certificate)session.getSessionData("PEER_CERTIFICATE_ENTRY_KEY");
        if (cert == null) {
            return false;
        }
        List authJIDs = CertificateUtil.extractXmppAddrs((X509Certificate)((X509Certificate)cert));
        return authJIDs != null && !authJIDs.isEmpty();
    }
}

