/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.TestLogger;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.BindResource;
import tigase.xmpp.impl.ProcessorTestCase;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class BindResourceTest
extends ProcessorTestCase {
    private static final Logger log = TestLogger.getLogger(BindResourceTest.class);
    private BindResource bindResource;

    @Override
    @Before
    public void setUp() throws Exception {
        this.bindResource = new BindResource();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.bindResource = null;
    }

    @Test
    public void testPreProcess() throws TigaseStringprepException, NotAuthorizedException, NoConnectionIdException {
        JID senderJid = JID.jidInstance((String)"sender@example.com/res-1");
        JID recipientJid = JID.jidInstance((String)"recipient@example.com/res-2");
        XMPPResourceConnection senderSession = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), senderJid);
        Element messageEl = new Element("message", new String[]{"from"}, new String[]{senderJid.toString()});
        Packet p = Packet.packetInstance((Element)messageEl);
        p.setPacketFrom(senderSession.getConnectionId());
        HashMap settings = new HashMap();
        ArrayDeque results = new ArrayDeque();
        log.log(Level.FINE, p.getElement() + "");
        Assert.assertFalse((boolean)this.bindResource.preProcess(p, senderSession, null, results, settings));
        Assert.assertEquals((long)0L, (long)results.size());
        Assert.assertEquals((Object)senderJid, (Object)p.getStanzaFrom());
        log.log(Level.FINE, p.getStanzaFrom() + "\n");
        p.getElement().setAttribute("from", senderJid.getBareJID().toString());
        log.log(Level.FINE, p.getElement() + "");
        Assert.assertFalse((boolean)this.bindResource.preProcess(p, senderSession, null, results, settings));
        Assert.assertEquals((long)0L, (long)results.size());
        Assert.assertEquals((Object)senderJid, (Object)p.getStanzaFrom());
        log.log(Level.FINE, p.getStanzaFrom() + "\n");
        p.getElement().removeAttribute("from");
        log.log(Level.FINE, p.getElement() + "");
        Assert.assertFalse((boolean)this.bindResource.preProcess(p, senderSession, null, results, settings));
        Assert.assertEquals((long)0L, (long)results.size());
        Assert.assertEquals((Object)senderJid, (Object)p.getStanzaFrom());
        log.log(Level.FINE, p.getStanzaFrom() + "\n");
        log.log(Level.FINE, "=====");
        Element presenceEl = new Element("presence", new String[]{"from"}, new String[]{senderJid.toString()});
        p = Packet.packetInstance((Element)presenceEl);
        p.setPacketFrom(senderSession.getConnectionId());
        log.log(Level.FINE, p.getElement() + "");
        Assert.assertFalse((boolean)this.bindResource.preProcess(p, senderSession, null, results, settings));
        Assert.assertEquals((long)0L, (long)results.size());
        Assert.assertEquals((Object)senderJid, (Object)p.getStanzaFrom());
        log.log(Level.FINE, p.getStanzaFrom() + "\n");
        p.getElement().setAttribute("from", senderJid.getBareJID().toString());
        log.log(Level.FINE, p.getElement() + "");
        Assert.assertFalse((boolean)this.bindResource.preProcess(p, senderSession, null, results, settings));
        Assert.assertEquals((long)0L, (long)results.size());
        Assert.assertEquals((Object)senderJid, (Object)p.getStanzaFrom());
        log.log(Level.FINE, p.getStanzaFrom() + "\n");
        p.getElement().removeAttribute("from");
        log.log(Level.FINE, p.getElement() + "");
        Assert.assertFalse((boolean)this.bindResource.preProcess(p, senderSession, null, results, settings));
        Assert.assertEquals((long)0L, (long)results.size());
        Assert.assertEquals((Object)senderJid, (Object)p.getStanzaFrom());
        log.log(Level.FINE, p.getStanzaFrom() + "\n");
        log.log(Level.FINE, "=====");
        p.getElement().setAttribute("type", "subscribe");
        p.getElement().setAttribute("from", senderJid.toString());
        p = Packet.packetInstance((Element)p.getElement());
        p.setPacketFrom(senderSession.getConnectionId());
        log.log(Level.FINE, p.getElement() + "");
        Assert.assertFalse((boolean)this.bindResource.preProcess(p, senderSession, null, results, settings));
        Assert.assertEquals((long)0L, (long)results.size());
        Assert.assertEquals((Object)JID.jidInstance((BareJID)senderJid.getBareJID()), (Object)p.getStanzaFrom());
        log.log(Level.FINE, p.getStanzaFrom() + "\n");
        p.getElement().setAttribute("from", senderJid.getBareJID().toString());
        log.log(Level.FINE, p.getElement() + "");
        Assert.assertFalse((boolean)this.bindResource.preProcess(p, senderSession, null, results, settings));
        Assert.assertEquals((long)0L, (long)results.size());
        Assert.assertEquals((Object)JID.jidInstance((BareJID)senderJid.getBareJID()), (Object)p.getStanzaFrom());
        log.log(Level.FINE, p.getStanzaFrom() + "\n");
        p.getElement().removeAttribute("from");
        log.log(Level.FINE, p.getElement() + "");
        Assert.assertFalse((boolean)this.bindResource.preProcess(p, senderSession, null, results, settings));
        Assert.assertEquals((long)0L, (long)results.size());
        Assert.assertEquals((Object)JID.jidInstance((BareJID)senderJid.getBareJID()), (Object)p.getStanzaFrom());
        log.log(Level.FINE, p.getStanzaFrom() + "\n");
    }
}

