/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.amp.db;

import java.util.Date;
import java.util.UUID;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import tigase.db.AbstractDataSourceAwareTestCase;
import tigase.db.DataSource;
import tigase.db.DataSourceAware;
import tigase.server.amp.db.MsgBroadcastRepository;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.jid.BareJID;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public abstract class AbstractMsgBroadcastRepositoryTest<DS extends DataSource>
extends AbstractDataSourceAwareTestCase<DS, MsgBroadcastRepository> {
    protected static boolean checkEmoji = true;
    protected static String emoji = "\ud83d\ude97\ud83d\udca9\ud83d\ude21";
    private static BareJID jid;
    private static Element msg;
    private static String msgId;

    @BeforeClass
    public static void init() throws TigaseStringprepException {
        jid = BareJID.bareJIDInstance((String)("broadcast-" + UUID.randomUUID()), (String)"example.com");
        msgId = "test-" + UUID.randomUUID().toString();
        msg = new Element("message");
        msg.addChild((XMLNodeIfc)new Element("body", "Testing broadcast messages" + (checkEmoji ? emoji : "")));
    }

    @Test
    public void test1_addingBroadcastMessage() throws InterruptedException {
        Date expire = new Date(System.currentTimeMillis() + 300000L);
        Assert.assertTrue((String)"Not added message to broadcast list!", (boolean)((MsgBroadcastRepository)this.repo).updateBroadcastMessage(msgId, msg, expire, jid));
        Assert.assertNotNull((String)("Not found message with id = " + msgId), (Object)((MsgBroadcastRepository)this.repo).getBroadcastMsg(msgId));
        ((MsgBroadcastRepository)this.repo).loadMessagesToBroadcast();
        Assert.assertNotNull((String)("Not found message with id = " + msgId), (Object)((MsgBroadcastRepository)this.repo).getBroadcastMsg(msgId));
    }

    @Test
    public void test2_loadingBroadcastMessagesAndAddingBroadcastMessageRecipient() throws InterruptedException {
        Thread.sleep(1000L);
        ((MsgBroadcastRepository)this.repo).loadMessagesToBroadcast();
        Assert.assertNotNull((String)("Not found message with id = " + msgId), (Object)((MsgBroadcastRepository)this.repo).getBroadcastMsg(msgId));
        Assert.assertFalse((String)"Added message instead of adding message recipient!", (boolean)((MsgBroadcastRepository)this.repo).updateBroadcastMessage(msgId, null, null, jid));
    }

    @Override
    protected Class<? extends DataSourceAware> getDataSourceAwareIfc() {
        return MsgBroadcastRepository.class;
    }
}

