/*
 * Decompiled with CFR 0.152.
 */
package tigase.kernel;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.Test;
import tigase.TestLogger;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.RegistrarBean;
import tigase.kernel.core.Kernel;
import tigase.kernel.core.PlantUMLGrapher;
import tigase.kernel.core.RegistrarKernel;

public class RegistratBeanCyclicTest {
    private static final Logger log = TestLogger.getLogger(RegistratBeanCyclicTest.class);

    @Test
    public void test01() {
        RegistrarKernel k = new RegistrarKernel();
        k.setName("root");
        k.registerBean(A.class).exec();
        PlantUMLGrapher gr = new PlantUMLGrapher((Kernel)k);
        A a = (A)k.getInstance(A.class);
        B b = a.b;
        C c = a.b.c;
        Assert.assertSame((Object)a, (Object)b.a);
        Assert.assertSame((Object)a, (Object)c.a);
        Assert.assertSame((Object)b, (Object)((Kernel)k.getInstance("a#KERNEL")).getInstance("b"));
        Assert.assertSame((Object)c, (Object)((Kernel)((Kernel)k.getInstance("a#KERNEL")).getInstance("b#KERNEL")).getInstance("c"));
        log.log(Level.FINE, gr.getDependencyGraph());
    }

    @Bean(name="c", active=true)
    public static class C {
        @Inject
        A a;
    }

    @Bean(name="b", active=true)
    public static class B
    implements RegistrarBean {
        @Inject
        A a;
        @Inject
        C c;

        public void register(Kernel kernel) {
            kernel.registerBean(C.class).exec();
            kernel.getParent().ln("service", kernel, "a");
        }

        public void unregister(Kernel kernel) {
        }
    }

    @Bean(name="a", active=true)
    public static class A
    implements RegistrarBean {
        @Inject
        B b;

        public void register(Kernel kernel) {
            kernel.registerBean(B.class).exec();
        }

        public void unregister(Kernel kernel) {
        }
    }
}

