/*
 * Decompiled with CFR 0.152.
 */
package tigase.eventbus.impl;

import java.util.Arrays;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import tigase.eventbus.impl.Event1;
import tigase.eventbus.impl.EventBusSerializer;
import tigase.xml.Element;
import tigase.xmpp.jid.JID;

public class EventBusSerializerTest {
    @Test
    public void testDeserialize() {
        EventBusSerializer serializer = new EventBusSerializer();
        Event1 eo = new Event1();
        eo.setJid(JID.jidInstanceNS((String)"a@b.c/d"));
        eo.setTransientField("123");
        eo.setV1("message");
        eo.setV2(9898);
        eo.setElementField(new Element("x", "v", new String[]{"a"}, new String[]{"b"}));
        eo.setStrArrField(new String[]{"ala", "m,a", "kota"});
        eo.setSetField(new HashSet<String>(Arrays.asList("test123")));
        Element ex = serializer.serialize((Object)eo);
        Event1 ed = (Event1)serializer.deserialize(ex);
        Assert.assertNotNull((Object)ed);
        Assert.assertNotSame((Object)eo, (Object)ed);
        Assert.assertEquals((Object)JID.jidInstanceNS((String)"a@b.c/d"), (Object)ed.getJid());
        Assert.assertNull((Object)ed.getTransientField());
        Assert.assertEquals((Object)"message", (Object)ed.getV1());
        Assert.assertEquals((long)9898L, (long)ed.getV2());
        Assert.assertEquals((Object)new Element("x", "v", new String[]{"a"}, new String[]{"b"}), (Object)ed.getElementField());
        Assert.assertArrayEquals((Object[])new String[]{"ala", "m,a", "kota"}, (Object[])ed.getStrArrField());
        Assert.assertTrue((boolean)eo.getSetField().contains("test123"));
    }

    @Test
    public void testSerialize() {
        EventBusSerializer serializer = new EventBusSerializer();
        Event1 eo = new Event1();
        eo.setJid(JID.jidInstanceNS((String)"a@b.c/d"));
        eo.setTransientField("123");
        eo.setV1("message");
        eo.setV2(9898);
        eo.setElementField(new Element("x", "v", new String[]{"a"}, new String[]{"b"}));
        eo.setStrArrField(new String[]{"ala", "m,a", "kota"});
        Element ex = serializer.serialize((Object)eo);
        Assert.assertEquals((long)5L, (long)ex.getChildren().size());
        Assert.assertEquals((Object)"a@b.c/d", (Object)ex.getCData(new String[]{"tigase.eventbus.impl.Event1", "jid"}));
        Assert.assertNull((Object)ex.getCData(new String[]{"tigase.eventbus.impl.Event1", "transientField"}));
        Assert.assertEquals((Object)"message", (Object)ex.getCData(new String[]{"tigase.eventbus.impl.Event1", "v1"}));
        Assert.assertEquals((Object)"9898", (Object)ex.getCData(new String[]{"tigase.eventbus.impl.Event1", "v2"}));
        Assert.assertEquals((Object)"v", (Object)ex.getCData(new String[]{"tigase.eventbus.impl.Event1", "elementField", "x"}));
        Assert.assertNotEquals((Object)"ala,m,a,kota", (Object)ex.getCData(new String[]{"tigase.eventbus.impl.Event1", "strArrField"}));
    }
}

