/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.util;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.Assert;
import org.junit.Test;
import tigase.db.util.DBSchemaLoader;
import tigase.util.Version;

public class DBSchemaLoaderTest {
    @Test
    public void getSchemaFileNames() {
    }

    @Test
    public void getSchemaFilesCurrentEmptyRequiredSnapshot() {
        ConcurrentHashMap<Version, Path> fileVersions = new ConcurrentHashMap<Version, Path>();
        fileVersions.put(Version.of((String)"3.2.0"), Paths.get("mysql-3.2.0.sql", new String[0]));
        fileVersions.put(Version.of((String)"3.1.0"), Paths.get("mysql-3.1.0.sql", new String[0]));
        fileVersions.put(Version.of((String)"4.0.0"), Paths.get("mysql-4.0.0.sql", new String[0]));
        fileVersions.put(Version.of((String)"3.0.0"), Paths.get("mysql-3.0.0.sql", new String[0]));
        Optional currentVersion = Optional.empty();
        Version requiredVersion = Version.of((String)"4.0.0-SNAPSHOT");
        Map result = DBSchemaLoader.getSchemaFileNamesInRange(fileVersions, currentVersion, (Version)requiredVersion);
        Assert.assertEquals((String)"Should contain all available files", result.keySet(), fileVersions.keySet());
    }

    @Test
    public void getSchemaFilesSameVersionCurrentSnapshotRequiredSnapshot() {
        ConcurrentHashMap<Version, Path> fileVersions = new ConcurrentHashMap<Version, Path>();
        fileVersions.put(Version.of((String)"3.2.0"), Paths.get("mysql-3.2.0.sql", new String[0]));
        fileVersions.put(Version.of((String)"3.1.0"), Paths.get("mysql-3.1.0.sql", new String[0]));
        fileVersions.put(Version.of((String)"3.0.0"), Paths.get("mysql-3.0.0.sql", new String[0]));
        fileVersions.put(Version.of((String)"4.0.0"), Paths.get("mysql-4.0.0.sql", new String[0]));
        Optional<Version> currentVersion = Optional.of(Version.of((String)"4.0.0-SNAPSHOT"));
        Version requiredVersion = Version.of((String)"4.0.0-SNAPSHOT");
        Map result = DBSchemaLoader.getSchemaFileNamesInRange(fileVersions, currentVersion, (Version)requiredVersion);
        Assert.assertEquals((String)"Should contain only latest version (same as required)", result.keySet(), new TreeSet<Version>(Arrays.asList(Version.of((String)"4.0.0"))));
    }

    @Test
    public void getSchemaFilesSameVersionCurrentFinalRequiredFinal() {
        ConcurrentHashMap<Version, Path> fileVersions = new ConcurrentHashMap<Version, Path>();
        fileVersions.put(Version.of((String)"3.2.0"), Paths.get("mysql-3.2.0.sql", new String[0]));
        fileVersions.put(Version.of((String)"3.0.0"), Paths.get("mysql-3.0.0.sql", new String[0]));
        fileVersions.put(Version.of((String)"4.0.0"), Paths.get("mysql-4.0.0.sql", new String[0]));
        fileVersions.put(Version.of((String)"3.1.0"), Paths.get("mysql-3.1.0.sql", new String[0]));
        Optional<Version> currentVersion = Optional.of(Version.of((String)"4.0.0"));
        Version requiredVersion = Version.of((String)"4.0.0");
        Map result = DBSchemaLoader.getSchemaFileNamesInRange(fileVersions, currentVersion, (Version)requiredVersion);
        Assert.assertTrue((String)"Should be empty", (boolean)result.isEmpty());
    }

    @Test
    public void getSchemaFilesSameVersionCurrentFinalRequiredSnapshot() {
        ConcurrentHashMap<Version, Path> fileVersions = new ConcurrentHashMap<Version, Path>();
        fileVersions.put(Version.of((String)"3.2.0"), Paths.get("mysql-3.2.0.sql", new String[0]));
        fileVersions.put(Version.of((String)"3.0.0"), Paths.get("mysql-3.0.0.sql", new String[0]));
        fileVersions.put(Version.of((String)"4.0.0"), Paths.get("mysql-4.0.0.sql", new String[0]));
        fileVersions.put(Version.of((String)"3.1.0"), Paths.get("mysql-3.1.0.sql", new String[0]));
        Optional<Version> currentVersion = Optional.of(Version.of((String)"4.0.0"));
        Version requiredVersion = Version.of((String)"4.0.0-SNAPSHOT");
        Map result = DBSchemaLoader.getSchemaFileNamesInRange(fileVersions, currentVersion, (Version)requiredVersion);
        Assert.assertEquals((String)"Should contain only latest version (same as required)", result.keySet(), new TreeSet<Object>(Arrays.asList(new Object[0])));
    }

    @Test
    public void getSchemaFilesSameVersionCurrentSnapshotRequiredFinal() {
        ConcurrentHashMap<Version, Path> fileVersions = new ConcurrentHashMap<Version, Path>();
        fileVersions.put(Version.of((String)"3.1.0"), Paths.get("mysql-3.1.0.sql", new String[0]));
        fileVersions.put(Version.of((String)"4.0.0"), Paths.get("mysql-4.0.0.sql", new String[0]));
        fileVersions.put(Version.of((String)"3.2.0"), Paths.get("mysql-3.2.0.sql", new String[0]));
        fileVersions.put(Version.of((String)"3.0.0"), Paths.get("mysql-3.0.0.sql", new String[0]));
        Optional<Version> currentVersion = Optional.of(Version.of((String)"4.0.0-SNAPSHOT"));
        Version requiredVersion = Version.of((String)"4.0.0");
        Map result = DBSchemaLoader.getSchemaFileNamesInRange(fileVersions, currentVersion, (Version)requiredVersion);
        Assert.assertEquals((String)"Should contain only latest version (same as required)", result.keySet(), new TreeSet<Version>(Arrays.asList(Version.of((String)"4.0.0"))));
    }

    @Test
    public void getSchemaFileNamesInRangeOrderTest() {
        ConcurrentHashMap<Version, Path> fileVersions = new ConcurrentHashMap<Version, Path>();
        fileVersions.put(Version.of((String)"3.1.0"), Paths.get("mysql-3.1.0.sql", new String[0]));
        fileVersions.put(Version.of((String)"4.0.0"), Paths.get("mysql-4.0.0.sql", new String[0]));
        fileVersions.put(Version.of((String)"3.2.0"), Paths.get("mysql-3.2.0.sql", new String[0]));
        fileVersions.put(Version.of((String)"3.0.0"), Paths.get("mysql-3.0.0.sql", new String[0]));
        Optional<Version> currentVersion = Optional.of(Version.of((String)"3.0.0-SNAPSHOT"));
        Version requiredVersion = Version.of((String)"4.0.0");
        Map result = DBSchemaLoader.getSchemaFileNamesInRange(fileVersions, currentVersion, (Version)requiredVersion);
        Assert.assertEquals((Object[])result.keySet().toArray(), (Object[])new Object[]{Version.of((String)"3.0.0"), Version.of((String)"3.1.0"), Version.of((String)"3.2.0"), Version.of((String)"4.0.0")});
    }
}

