/*
 * Decompiled with CFR 0.152.
 */
package tigase.conf;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;
import tigase.conf.ConfigHolder;
import tigase.conf.ConfigReader;
import tigase.conf.ConfigWriter;
import tigase.conf.OldConfigHolder;
import tigase.kernel.beans.config.AbstractBeanConfigurator;
import tigase.server.CmdAcl;
import tigase.server.ext.ComponentProtocol;
import tigase.xmpp.impl.roster.DynamicRosterTest;
import tigase.xmpp.impl.roster.DynamicRosterTest123;

public class ConfigHolderTest {
    @Test
    public void testFormatDetection() throws IOException, ConfigReader.ConfigException {
        OldConfigHolder holder = new OldConfigHolder();
        File tmp = File.createTempFile("test_", ".properties");
        try (FileWriter w = new FileWriter(tmp);){
            ((Writer)w).append("--auth-db[domain4.com]=tigase-custom").append("\n").append("--auth-db-uri[domain4.com]=jdbc:mysql://db14.domain4.com/dbname?user&password").append("\n").append("basic-conf/auth-repo-params/domain4.com/user-login-query={ call UserLogin(?, ?) }").append("\n").append("basic-conf/auth-repo-params/domain4.com/user-logout-query={ call UserLogout(?) }").append("\n").append("basic-conf/auth-repo-params/domain4.com/sasl-mechs=PLAIN,DIGEST-MD5").append("\n").append("--user-db[domain4.com]=mysql").append("\n").append("--user-db-uri[domain4.com]=jdbc:mysql://db14.domain4.com/dbname?user&password").append("\n");
        }
        holder.getProperties().put("--property-file", tmp.getAbsolutePath());
        OldConfigHolder.Format format = holder.detectPathAndFormat();
        tmp.delete();
        Assert.assertEquals((Object)OldConfigHolder.Format.properties, (Object)format);
        tmp = File.createTempFile("test_", ".properties");
        try (FileWriter w = new FileWriter(tmp);){
            ((Writer)w).append("authRepository () {").append("\n").append("'domain4.com' () {").append("\n").append("'user-login-query' = '{ call UserLogin(?, ?) }'").append("\n").append("'user-logout-query' = \"{ call UserLogout(?) }\"").append("\n").append("'sasl-mechs' = 'PLAIN,DIGEST-MD5'").append("\n").append("}").append("\n").append("}").append("\n");
        }
        holder.getProperties().put("--property-file", tmp.getAbsolutePath());
        format = holder.detectPathAndFormat();
        tmp.delete();
        Assert.assertEquals((Object)OldConfigHolder.Format.dsl, (Object)format);
    }

    @Test
    public void testConversionOfAuthRepositoryOptions() throws IOException, ConfigReader.ConfigException {
        StringBuilder w = new StringBuilder();
        w.append("--auth-db[domain4.com]=tigase-custom").append("\n").append("--auth-db-uri[domain4.com]=jdbc:mysql://db14.domain4.com/dbname?user&password").append("\n").append("basic-conf/auth-repo-params/domain4.com/user-login-query={ call UserLogin(?, ?) }").append("\n").append("basic-conf/auth-repo-params/domain4.com/user-logout-query={ call UserLogout(?) }").append("\n").append("basic-conf/auth-repo-params/domain4.com/sasl-mechs=PLAIN,DIGEST-MD5").append("\n").append("--user-db[domain4.com]=mysql").append("\n").append("--user-db-uri[domain4.com]=jdbc:mysql://db14.domain4.com/dbname?user&password").append("\n");
        File tmp = File.createTempFile("test_", ".properties");
        try (FileWriter writer = new FileWriter(tmp);){
            writer.write(w.toString());
        }
        OldConfigHolder holder = new OldConfigHolder();
        holder.getProperties().put("--property-file", tmp.getAbsolutePath());
        OldConfigHolder.Format format = holder.detectPathAndFormat();
        tmp.delete();
        Assert.assertEquals((Object)OldConfigHolder.Format.properties, (Object)format);
    }

    @Test
    public void testConversionOfAdHocCommandsACLs() throws IOException, ConfigReader.ConfigException {
        String cfgStr = Stream.of("sess-man/command/http\\://jabber.org/protocol/admin#add-user=LOCAL", "sess-man/command/http\\://jabber.org/protocol/admin#delete-user=DOMAIN:test.com", "sess-man/command/http\\://jabber.org/protocol/admin#change-user-password=LOCAL", "sess-man/command/http\\://jabber.org/protocol/admin#get-user-roster=JID:ala1@test.com", "sess-man/command/http\\://jabber.org/protocol/admin#user-stats=LOCAL", "sess-man/command/http\\://jabber.org/protocol/admin#get-active-users-num=LOCAL, DOMAIN:test.com", "sess-man/command/http\\://jabber.org/protocol/admin#get-idle-users-num=LOCAL", "sess-man/command/http\\://jabber.org/protocol/admin#get-registered-users-list=JID:ala@test.coms", "sess-man/command/http\\://jabber.org/protocol/admin#get-online-users-list=LOCAL", "sess-man/command/http\\://jabber.org/protocol/admin#get-active-users=DOMAIN:example.com", "sess-man/command/http\\://jabber.org/protocol/admin#get-idle-users=LOCAL", "sess-man/command/http\\://jabber.org/protocol/admin#announce=LOCAL", "sess-man/command/http\\://jabber.org/protocol/admin#add-user-tracker=LOCAL", "sess-man/command/http\\://jabber.org/protocol/admin#get-top-active-users=LOCAL", "sess-man/command/http\\://jabber.org/protocol/admin#remove-user-tracker=LOCAL", "basic-conf/command/user-domain-perm=LOCAL", "sess-man/command/connection-time=LOCAL", "s2s/command/roster-fixer=LOCAL", "sess-man/command/roster-fixer-cluster=LOCAL", "s2s/command/user-roster-management=LOCAL", "c2s/command/user-roster-management-ext=LOCAL").collect(Collectors.joining("\n"));
        File tmp = File.createTempFile("test_", ".properties");
        try (FileWriter writer = new FileWriter(tmp);){
            writer.write(cfgStr);
        }
        File tdslFile = File.createTempFile("test_", ".tdsl");
        tdslFile.delete();
        OldConfigHolder holder = new OldConfigHolder();
        holder.convert(new String[]{"--property-file", tmp.getAbsolutePath()}, tdslFile.toPath());
        Map result = ConfigWriter.buildTree((Map)holder.getProperties());
        result.remove("config-type");
        result.forEach((comp, properties) -> {
            Assert.assertTrue((boolean)Map.class.isAssignableFrom(properties.getClass()));
            Map map = (Map)properties;
            map.values().forEach(x -> {
                Map map1 = (Map)x;
                map1.values().forEach(y -> {
                    if (y instanceof List) {
                        ((List)y).forEach(z -> Assert.assertNotNull((Object)new CmdAcl((String)z)));
                    } else {
                        Assert.assertNotNull((Object)new CmdAcl((String)y));
                    }
                });
            });
        });
    }

    @Test
    public void testConversionOfDynamicRosterClasses() throws IOException, ConfigReader.ConfigException {
        OldConfigHolder holder = new OldConfigHolder();
        Map props = holder.loadFromPropertyStrings(Arrays.asList("sess-man/plugins-conf/dynamic-roster-classes=tigase.xmpp.impl.roster.DynamicRosterTest, tigase.xmpp.impl.roster.DynamicRosterTest123"));
        holder.convertFromOldFormat();
        Map result = ConfigWriter.buildTree((Map)props);
        Map sessMan = (Map)result.get("sess-man");
        Assert.assertNotNull((Object)sessMan);
        AbstractBeanConfigurator.BeanDefinition dynamicRoster = (AbstractBeanConfigurator.BeanDefinition)sessMan.get("dynamic-rosters");
        Assert.assertNotNull((Object)dynamicRoster);
        Assert.assertTrue((boolean)dynamicRoster.isActive());
        Assert.assertNull((Object)dynamicRoster.getClazzName());
        Assert.assertFalse((boolean)dynamicRoster.isEmpty());
        AbstractBeanConfigurator.BeanDefinition roster = (AbstractBeanConfigurator.BeanDefinition)dynamicRoster.get((Object)"DynamicRosterTest");
        Assert.assertNotNull((Object)roster);
        Assert.assertTrue((boolean)roster.isActive());
        Assert.assertEquals((Object)DynamicRosterTest.class.getCanonicalName(), (Object)roster.getClazzName());
        roster = (AbstractBeanConfigurator.BeanDefinition)dynamicRoster.get((Object)"DynamicRosterTest123");
        Assert.assertNotNull((Object)roster);
        Assert.assertTrue((boolean)roster.isActive());
        Assert.assertEquals((Object)DynamicRosterTest123.class.getCanonicalName(), (Object)roster.getClazzName());
    }

    @Test
    public void testConversionOfGlobalProperties() throws IOException, ConfigReader.ConfigException {
        OldConfigHolder holder = new OldConfigHolder();
        Map props = holder.loadFromPropertyStrings(Arrays.asList("--max-queue-size=10000"));
        holder.convertFromOldFormat();
        Map result = ConfigWriter.buildTree((Map)props);
        Assert.assertEquals((Object)10000, result.get("max-queue-size"));
    }

    @Test
    public void testConversionOfExtComponentProperties() throws IOException, ConfigReader.ConfigException {
        OldConfigHolder holder = new OldConfigHolder();
        Map props = holder.loadFromPropertyStrings(Arrays.asList("--external=muc1.devel.tigase.org:passwd1, muc2.devel.tigase.org:passwd2", "--comp-name-1=ext", "--comp-class-1=" + ComponentProtocol.class.getCanonicalName()));
        holder.convertFromOldFormat();
        Map result = ConfigWriter.buildTree((Map)props);
        Map ext = (Map)result.get("ext");
        Assert.assertNotNull((Object)ext);
        Map repo = (Map)ext.get("repository");
        Assert.assertNull((Object)repo);
        new File("etc/externalComponentItems").delete();
    }

    @Test
    public void testConversionOfPriorityQueue() throws ConfigReader.ConfigException {
        OldConfigHolder holder = new OldConfigHolder();
        Map props = holder.loadFromPropertyStrings(Collections.singletonList("--queue-implementation = tigase.util.PriorityQueueStrict"));
        Map result = ConfigWriter.buildTree((Map)props);
        ConfigHolder.upgradeDSL((Map)result);
        Assert.assertEquals((Object)"tigase.util.workqueue.PriorityQueueStrict", result.get("priority-queue-implementation"));
    }

    @Test
    public void testConversionOfVHostsList() throws ConfigReader.ConfigException {
        OldConfigHolder holder = new OldConfigHolder();
        Map props = holder.loadFromPropertyStrings(Collections.singletonList("--virt-hosts = international.com, dev.com, qa.com, int.com"));
        holder.convertFromOldFormat();
        Map result = ConfigWriter.buildTree((Map)props);
        ConfigHolder.upgradeDSL((Map)result);
        Optional<String> defaultVHost = Optional.ofNullable(result.get("default-virtual-host")).filter(String.class::isInstance).map(String.class::cast);
        Assert.assertTrue((boolean)defaultVHost.isPresent());
        Assert.assertEquals((Object)"international.com", (Object)defaultVHost.get());
    }

    @Test
    public void testConversionOfAdmins() throws ConfigReader.ConfigException {
        OldConfigHolder holder = new OldConfigHolder();
        Map props = holder.loadFromPropertyStrings(Collections.singletonList("--admins = admin@dev.com, admin@qa.com, admin@int.com"));
        holder.convertFromOldFormat();
        Map result = ConfigWriter.buildTree((Map)props);
        ConfigHolder.upgradeDSL((Map)result);
        Assert.assertArrayEquals((Object[])new String[]{"admin@dev.com", "admin@qa.com", "admin@int.com"}, (Object[])((List)result.get("admins")).toArray(new String[0]));
    }

    @Test
    public void testConversionOfLogging1() throws ConfigReader.ConfigException, IOException {
        OldConfigHolder holder = new OldConfigHolder();
        Map props = holder.loadFromPropertyStrings(Arrays.asList("basic-conf/logging/handlers=java.util.logging.ConsoleHandler java.util.logging.FileHandler", "basic-conf/logging/java.util.logging.ConsoleHandler.formatter=tigase.util.LogFormatter", "basic-conf/logging/java.util.logging.ConsoleHandler.level=WARNING", "basic-conf/logging/tigase.useParentHandlers=true", "basic-conf/logging/tigase.server.level=FINEST", "basic-conf/logging/java.util.logging.FileHandler.limit=100000000", "basic-conf/logging/java.util.logging.FileHandler.count=10", "basic-conf/logging/java.util.logging.FileHandler.pattern=/data/logs/tigase.log"));
        holder.convertFromOldFormat();
        Map result = ConfigWriter.buildTree((Map)props);
        ConfigHolder.upgradeDSL((Map)result);
        Assert.assertEquals(Arrays.asList("java.util.logging.ConsoleHandler", "java.util.logging.FileHandler"), ((Map)result.get("logging")).get("rootHandlers"));
        Assert.assertEquals((Object)"tigase.util.LogFormatter", ((Map)((Map)((Map)result.get("logging")).get("handlers")).get("java.util.logging.ConsoleHandler")).get("formatter"));
        Assert.assertEquals((Object)"/data/logs/tigase.log", ((Map)((Map)((Map)result.get("logging")).get("handlers")).get("java.util.logging.FileHandler")).get("pattern"));
        Assert.assertEquals((Object)"FINEST", ((Map)((Map)((Map)result.get("logging")).get("loggers")).get("tigase.server")).get("level"));
    }

    @Test
    public void testConversionOfLogging2() throws ConfigReader.ConfigException, IOException {
        OldConfigHolder holder = new OldConfigHolder();
        Map props = holder.loadFromPropertyStrings(Arrays.asList("basic-conf/logging/java.util.logging.ConsoleHandler.formatter=tigase.util.LogFormatter", "basic-conf/logging/tigase.server.level=FINEST", "basic-conf/logging/java.util.logging.FileHandler.pattern=/data/logs/tigase.log"));
        holder.convertFromOldFormat();
        Map result = ConfigWriter.buildTree((Map)props);
        ConfigHolder.upgradeDSL((Map)result);
        Assert.assertNull(((Map)result.get("logging")).get("rootHandlers"));
        Assert.assertEquals((Object)"tigase.util.LogFormatter", ((Map)((Map)((Map)result.get("logging")).get("handlers")).get("java.util.logging.ConsoleHandler")).get("formatter"));
        Assert.assertEquals((Object)"/data/logs/tigase.log", ((Map)((Map)((Map)result.get("logging")).get("handlers")).get("java.util.logging.FileHandler")).get("pattern"));
        Assert.assertEquals((Object)"FINEST", ((Map)((Map)((Map)result.get("logging")).get("loggers")).get("tigase.server")).get("level"));
    }

    @Test
    public void testConversionOfCustomVirtHostsCerts() throws ConfigReader.ConfigException {
        OldConfigHolder holder = new OldConfigHolder();
        Map props = holder.loadFromPropertyStrings(Arrays.asList("basic-conf/virtual-hosts-cert-host1.example.net=/home/tigase/certs/host1.pem", "basic-conf/virt-hosts-cert-host2.example.net=/home/tigase/certs/host2.pem", "basic-conf/virtual-hosts-cert-host3.example.net=/home/tigase/certs/host3.pem", "basic-conf/virtual-hosts-cert-*.hostx.example.net=/home/tigase/certs/hostx.pem"));
        holder.convertFromOldFormat();
        Map result = ConfigWriter.buildTree((Map)props);
        ConfigHolder.upgradeDSL((Map)result);
        ConfigHolderTest.dumpConfig(result);
        Assert.assertNotNull((Object)((Map)result.get("certificate-container")));
        Assert.assertEquals((Object)"/home/tigase/certs/host1.pem", ((Map)((Map)result.get("certificate-container")).get("custom-certificates")).get("host1.example.net"));
        Assert.assertEquals((Object)"/home/tigase/certs/host2.pem", ((Map)((Map)result.get("certificate-container")).get("custom-certificates")).get("host2.example.net"));
        Assert.assertEquals((Object)"/home/tigase/certs/host3.pem", ((Map)((Map)result.get("certificate-container")).get("custom-certificates")).get("host3.example.net"));
        Assert.assertEquals((Object)"/home/tigase/certs/hostx.pem", ((Map)((Map)result.get("certificate-container")).get("custom-certificates")).get("*.hostx.example.net"));
    }

    private static final void dumpConfig(Map result) {
        try {
            StringWriter sw = new StringWriter();
            new ConfigWriter().write((Writer)sw, result);
            System.out.println("\n" + sw.toString());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

