/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.mam;

import java.text.SimpleDateFormat;
import java.util.TimeZone;
import tigase.component.PacketWriter;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Message;
import tigase.server.Priority;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.mam.MAMRepository;
import tigase.xmpp.mam.Query;
import tigase.xmpp.mam.modules.QueryModule;

@Bean(name="mamItemHandler", parent=QueryModule.class, active=true)
public class MAMItemHandler
implements MAMRepository.ItemHandler {
    private static final SimpleDateFormat TIMESTAMP_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXX");
    @Inject
    private PacketWriter packetWriter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void itemFound(Query query, MAMRepository.Item item) {
        String timestampStr;
        Element m = new Element("message");
        Element result = new Element("result", new String[]{"xmlns", "id"}, new String[]{"urn:xmpp:mam:1", item.getId()});
        if (query.getId() != null) {
            result.setAttribute("queryid", query.getId());
        }
        m.addChild((XMLNodeIfc)result);
        Element forwarded = new Element("forwarded", new String[]{"xmlns"}, new String[]{"urn:xmpp:forward:0"});
        result.addChild((XMLNodeIfc)forwarded);
        SimpleDateFormat simpleDateFormat = TIMESTAMP_FORMATTER;
        synchronized (simpleDateFormat) {
            timestampStr = TIMESTAMP_FORMATTER.format(item.getTimestamp());
        }
        Element delay = new Element("delay", new String[]{"xmlns", "stamp"}, new String[]{"urn:xmpp:delay", timestampStr});
        forwarded.addChild((XMLNodeIfc)delay);
        forwarded.addChild((XMLNodeIfc)item.getMessage());
        Message packet = new Message(m, query.getComponentJID(), query.getQuestionerJID());
        packet.setPriority(Priority.HIGH);
        if (query.getRsm().getFirst() == null) {
            query.getRsm().setFirst(item.getId());
        }
        query.getRsm().setLast(item.getId());
        this.packetWriter.write(packet);
    }

    static {
        TIMESTAMP_FORMATTER.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

