/*
 * Decompiled with CFR 0.152.
 */
package tigase.vhosts;

import java.util.concurrent.ConcurrentSkipListSet;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.config.ConfigField;
import tigase.vhosts.VHostItem;
import tigase.vhosts.VHostManager;
import tigase.vhosts.filter.DomainFilterPolicy;
import tigase.xmpp.jid.JID;

@Bean(name="defaults", parent=VHostManager.class, active=true, exportable=true)
public class VHostItemDefaults {
    @ConfigField(desc="ANONYMOUS authentication enabled", alias="vhost-anonymous-enabled")
    private boolean anonymousEnabled = VHostItem.VHOST_ANONYMOUS_ENABLED_PROP_DEF;
    @ConfigField(desc="Check DNS for domain", alias="vhost-disable-dns-check")
    private boolean disableDnsCheck = false;
    private DomainFilterPolicy domainFilter = VHostItem.DOMAIN_FILTER_POLICY_PROP_DEF;
    private String[] domainFilterDomains = null;
    @ConfigField(desc="Domain filter policy", alias="domain-filter-policy")
    private String domainFilterStr = null;
    @ConfigField(desc="Hardened mode", alias="hardened-mode")
    private boolean hardenedMode = false;
    @ConfigField(desc="Maximal number of users", alias="vhost-max-users")
    private long maxUsersNumber = VHostItem.VHOST_MAX_USERS_PROP_DEF;
    @ConfigField(desc="Message forward JID", alias="vhost-message-forward-jid")
    private JID messageForward = JID.jidInstanceNS((String)VHostItem.VHOST_MESSAGE_FORWARD_PROP_DEF);
    @ConfigField(desc="Presence forward JID", alias="vhost-presence-forward-jid")
    private JID presenceForward = JID.jidInstanceNS((String)VHostItem.VHOST_PRESENCE_FORWARD_PROP_DEF);
    @ConfigField(desc="Registration allowed", alias="vhost-register-enabled")
    private boolean registerEnabled = VHostItem.VHOST_REGISTER_ENABLED_PROP_DEF;
    @ConfigField(desc="S2S secret", alias="s2s-secret")
    private String s2sSecret = VHostItem.S2S_SECRET_PROP_DEF;
    @ConfigField(desc="TLS required", alias="vhost-tls-required")
    private boolean tlsRequired = VHostItem.VHOST_TLS_REQUIRED_PROP_DEF;
    @ConfigField(desc="Global trusted jids", alias="trusted")
    private ConcurrentSkipListSet<String> trusted = null;

    public DomainFilterPolicy getDomainFilter() {
        return this.domainFilter;
    }

    public String[] getDomainFilterDomains() {
        return this.domainFilterDomains;
    }

    public long getMaxUsersNumber() {
        return this.maxUsersNumber;
    }

    public JID getMessageForward() {
        return this.messageForward;
    }

    public JID getPresenceForward() {
        return this.presenceForward;
    }

    public String getS2sSecret() {
        return this.s2sSecret;
    }

    public ConcurrentSkipListSet<String> getTrusted() {
        return this.trusted;
    }

    public boolean isAnonymousEnabled() {
        return this.anonymousEnabled;
    }

    public boolean isCheckDns() {
        return !this.disableDnsCheck;
    }

    public boolean isHardenedMode() {
        return this.hardenedMode;
    }

    public boolean isRegisterEnabled() {
        return this.registerEnabled;
    }

    public boolean isTlsRequired() {
        return this.tlsRequired;
    }

    public void setDomainFilterStr(String value) {
        this.domainFilter = VHostItem.getPolicyFromConfString(value);
        this.domainFilterDomains = VHostItem.getDomainsFromConfString(value);
    }
}

