/*
 * Decompiled with CFR 0.152.
 */
package tigase.monitor.tasks;

import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.monitor.TimerTaskService;
import tigase.monitor.tasks.AbstractConfigurableTask;
import tigase.util.common.TimerTask;

public abstract class AbstractConfigurableTimerTask
extends AbstractConfigurableTask
implements UnregisterAware {
    private static final String PERIOD_VAR = "x-task#period";
    private final TimerTask worker = new TimerTask(){

        @Override
        public void run() {
            AbstractConfigurableTimerTask.this.run();
        }
    };
    @ConfigField(desc="Task execute period [ms]")
    private long period = 1000L;
    @Inject(bean="timerTaskService")
    private TimerTaskService timerTaskService;

    @Override
    public void beforeUnregister() {
        this.setEnabled(false);
    }

    @Override
    public Form getCurrentConfiguration() {
        Form f = super.getCurrentConfiguration();
        f.addField(Field.fieldTextSingle((String)PERIOD_VAR, (String)("" + this.period), (String)"Period [ms]"));
        return f;
    }

    public long getPeriod() {
        return this.period;
    }

    public void setPeriod(long value) {
        if (this.period != value) {
            this.period = value;
            if (this.isEnabled()) {
                this.worker.cancel();
                this.timerTaskService.addTimerTask(this.worker, 1000L, this.period);
            }
        }
    }

    public TimerTaskService getTimerTaskService() {
        return this.timerTaskService;
    }

    public void setTimerTaskService(TimerTaskService timerTaskService) {
        this.timerTaskService = timerTaskService;
    }

    @Override
    public void setNewConfiguration(Form form) {
        Field f = form.get(PERIOD_VAR);
        if (f != null) {
            long value = Long.parseLong(f.getValue());
            this.setPeriod(value);
        }
        super.setNewConfiguration(form);
    }

    @Override
    protected void disable() {
        super.disable();
        this.worker.cancel();
    }

    @Override
    protected void enable() {
        super.enable();
        this.timerTaskService.addTimerTask(this.worker, 1000L, this.period);
    }

    protected abstract void run();
}

