/*
 * Decompiled with CFR 0.152.
 */
package tigase.eventbus.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.eventbus.EventBus;
import tigase.eventbus.EventBusException;
import tigase.eventbus.EventListener;
import tigase.eventbus.EventRoutedTransientFiller;
import tigase.eventbus.EventRoutingSelector;
import tigase.eventbus.EventSourceListener;
import tigase.eventbus.impl.AbstractHandler;
import tigase.eventbus.impl.ElementListenerHandler;
import tigase.eventbus.impl.ElementSourceListenerHandler;
import tigase.eventbus.impl.EventBusSerializer;
import tigase.eventbus.impl.EventName;
import tigase.eventbus.impl.EventsNameMap;
import tigase.eventbus.impl.EventsRegistrar;
import tigase.eventbus.impl.ObjectEventsListenerHandler;
import tigase.eventbus.impl.ObjectEventsSourceListenerHandler;
import tigase.eventbus.impl.ReflectEventListenerHandlerFactory;
import tigase.eventbus.impl.ReflectEventRoutedTransientFillerFactory;
import tigase.eventbus.impl.ReflectEventRoutingSelectorFactory;
import tigase.eventbus.impl.Serializer;
import tigase.xml.Element;

public class EventBusImplementation
implements EventBus {
    private static final Logger log = Logger.getLogger(EventBusImplementation.class.getName());
    private final EventsNameMap<AbstractHandler> listeners = new EventsNameMap();
    private final ReflectEventListenerHandlerFactory reflectEventListenerFactory = new ReflectEventListenerHandlerFactory();
    private final ReflectEventRoutedTransientFillerFactory reflectEventRoutedTransientFillerFactory = new ReflectEventRoutedTransientFillerFactory();
    private final ReflectEventRoutingSelectorFactory reflectEventRoutingSelectorFactory = new ReflectEventRoutingSelectorFactory();
    private final EventsRegistrar registrar = new EventsRegistrar();
    private final Map<Class<?>, Set<EventRoutedTransientFiller>> routedTransientFillers = new ConcurrentHashMap();
    private final Map<Class<?>, EventRoutingSelector> routingSelectors = new ConcurrentHashMap();
    private final Serializer serializer = new EventBusSerializer();
    private boolean acceptOnlyRegisteredEvents = false;
    private Executor executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 4);

    public void addHandler(AbstractHandler listenerHandler) {
        this.listeners.put(listenerHandler.getPackageName(), listenerHandler.getEventName(), listenerHandler);
    }

    @Override
    public <T> void addListener(Class<T> eventClass, EventListener<T> listener) {
        String packageName = eventClass.getPackage().getName();
        String eventName = eventClass.getSimpleName();
        ObjectEventsListenerHandler handler = new ObjectEventsListenerHandler(packageName, eventName, listener);
        this.addHandler(handler);
        this.fireListenerAddedEvent(packageName, eventName);
    }

    public <T> void addListener(Class<T> eventClass, EventSourceListener<T> listener) {
        String packageName = eventClass.getPackage().getName();
        String eventName = eventClass.getSimpleName();
        ObjectEventsSourceListenerHandler handler = new ObjectEventsSourceListenerHandler(packageName, eventName, listener);
        this.addHandler(handler);
        this.fireListenerAddedEvent(packageName, eventName);
    }

    @Override
    public void addListener(String packageName, String eventName, EventListener<Element> listener) {
        ElementListenerHandler handler = new ElementListenerHandler(packageName, eventName, listener);
        this.addHandler(handler);
        this.fireListenerAddedEvent(packageName, eventName);
    }

    public void addListener(String packageName, String eventName, EventSourceListener<Element> listener) {
        ElementSourceListenerHandler handler = new ElementSourceListenerHandler(packageName, eventName, listener);
        this.addHandler(handler);
        this.fireListenerAddedEvent(packageName, eventName);
    }

    @Override
    public void fire(Object event) {
        this.fire(event, null, false);
    }

    public void fire(Object event, Object source) {
        this.fire(event, source, false);
    }

    public void fire(Object event, Object source, boolean remotelyGeneratedEvent) {
        try {
            HashSet<AbstractHandler> listeners;
            if (event instanceof Element) {
                String eventFullName = ((Element)event).getName();
                int i = eventFullName.lastIndexOf(".");
                String packageName = i >= 0 ? eventFullName.substring(0, i) : "";
                String eventName = eventFullName.substring(i + 1);
                this.checkIfEventIsRegistered(eventFullName);
                listeners = this.getListenersForEvent(packageName, eventName);
            } else {
                this.checkIfEventIsRegistered(event.getClass().getName());
                listeners = this.getListenersForEvent(event.getClass());
            }
            this.doFireThreadPerHandler(event, source, remotelyGeneratedEvent, listeners);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Problem on firing event", e);
        }
    }

    public Collection<AbstractHandler> getAllHandlers() {
        return this.listeners.getAllData();
    }

    public Set<EventName> getAllListenedEvents() {
        return this.listeners.getAllListenedEvents();
    }

    public Collection<EventRoutedTransientFiller> getEventRoutedTransientFillers(Class<?> eventClass) {
        HashSet<EventRoutedTransientFiller> result = new HashSet<EventRoutedTransientFiller>();
        Class<?> tmp = eventClass;
        do {
            Collection fillers;
            if ((fillers = (Collection)this.routedTransientFillers.get(tmp)) == null) continue;
            result.addAll(fillers);
        } while (!(tmp = tmp.getSuperclass()).equals(Object.class));
        return result;
    }

    public EventRoutingSelector getEventRoutingSelector(Class<?> eventClass) {
        Class<?> tmp = eventClass;
        EventRoutingSelector handler = null;
        while ((handler = this.routingSelectors.get(tmp)) == null && !(tmp = tmp.getSuperclass()).equals(Object.class)) {
        }
        return handler;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public EventsRegistrar getRegistrar() {
        return this.registrar;
    }

    public Serializer getSerializer() {
        return this.serializer;
    }

    public boolean isAcceptOnlyRegisteredEvents() {
        return this.acceptOnlyRegisteredEvents;
    }

    public void setAcceptOnlyRegisteredEvents(boolean acceptOnlyRegisteredEvents) {
        this.acceptOnlyRegisteredEvents = acceptOnlyRegisteredEvents;
    }

    public boolean isListened(String eventPackage, String eventName) {
        return this.listeners.hasData(eventPackage, eventName);
    }

    @Override
    public void registerAll(Object consumer) {
        Collection<AbstractHandler> listeners = this.reflectEventListenerFactory.create(consumer);
        for (AbstractHandler abstractHandler : listeners) {
            this.addHandler(abstractHandler);
        }
        Collection<EventRoutedTransientFiller> fillers = this.reflectEventRoutedTransientFillerFactory.create(consumer);
        for (EventRoutedTransientFiller f : fillers) {
            Set eventFillers = this.routedTransientFillers.computeIfAbsent(f.getEventClass(), c -> new CopyOnWriteArraySet());
            eventFillers.add(f);
        }
        Collection<EventRoutingSelector> collection = this.reflectEventRoutingSelectorFactory.create(consumer);
        for (EventRoutingSelector s : collection) {
            this.routingSelectors.put(s.getEventClass(), s);
        }
    }

    @Override
    public void registerEvent(String event, String description, boolean privateEvent) {
        this.registrar.register(event, description, privateEvent);
    }

    public void registerEvent(Class<?> event, String description, boolean privateEvent) {
        this.registrar.register(event.getName(), description, privateEvent);
    }

    public void removeHandler(AbstractHandler listenerHandler) {
        this.listeners.delete(listenerHandler);
    }

    public <T> void removeListener(EventSourceListener<T> listener) {
        ObjectEventsSourceListenerHandler handler = new ObjectEventsSourceListenerHandler(null, null, listener);
        this.removeHandler(handler);
    }

    @Override
    public <T> void removeListener(EventListener<T> listener) {
        if (listener == null) {
            return;
        }
        ObjectEventsListenerHandler handler = new ObjectEventsListenerHandler(null, null, listener);
        this.removeHandler(handler);
    }

    @Override
    public void unregisterAll(Object consumer) {
        Collection<AbstractHandler> listeners = this.reflectEventListenerFactory.create(consumer);
        for (AbstractHandler abstractHandler : listeners) {
            this.removeHandler(abstractHandler);
        }
        Collection<EventRoutingSelector> selectors = this.reflectEventRoutingSelectorFactory.create(consumer);
        for (EventRoutingSelector s : selectors) {
            this.routingSelectors.remove(s.getEventClass(), s);
        }
        Collection<EventRoutedTransientFiller> collection = this.reflectEventRoutedTransientFillerFactory.create(consumer);
        for (EventRoutedTransientFiller f : collection) {
            Set<EventRoutedTransientFiller> eventFillers = this.routedTransientFillers.get(f.getEventClass());
            if (eventFillers == null) continue;
            eventFillers.remove(f);
        }
    }

    List<EventListener> getEventListeners(String packageName, String eventName) {
        ArrayList<EventListener> result = new ArrayList<EventListener>();
        Collection<AbstractHandler> ls = this.listeners.get(packageName, eventName);
        result.addAll(ls);
        ls = this.listeners.get(null, eventName);
        result.addAll(ls);
        return result;
    }

    HashSet<AbstractHandler> getListenersForEvent(Class<?> eventClass) {
        HashSet<AbstractHandler> result = new HashSet<AbstractHandler>();
        for (Class<?> cls : eventClass.getInterfaces()) {
            this.fillListenersForEvent(result, cls);
        }
        Class<?> cls = eventClass;
        while (!cls.equals(Object.class)) {
            this.fillListenersForEvent(result, cls);
            cls = cls.getSuperclass();
        }
        result.addAll(this.listeners.get(null, null));
        return result;
    }

    HashSet<AbstractHandler> getListenersForEvent(String packageName, String eventName) {
        HashSet<AbstractHandler> result = new HashSet<AbstractHandler>();
        result.addAll(this.listeners.get(packageName, eventName));
        result.addAll(this.listeners.get(packageName, null));
        result.addAll(this.listeners.get(null, null));
        return result;
    }

    protected void doFireThreadPerHandler(Object event, Object source, boolean remotelyGeneratedEvent, HashSet<AbstractHandler> handlers) {
        Element eventConverted = null;
        for (AbstractHandler listenerHandler : handlers) {
            Object eventObject;
            if (listenerHandler.getRequiredEventType() == AbstractHandler.Type.asIs) {
                eventObject = event;
            } else if (listenerHandler.getRequiredEventType() == AbstractHandler.Type.element && !(event instanceof Element)) {
                if (eventConverted == null) {
                    eventConverted = this.serializer.serialize(event);
                }
                eventObject = eventConverted;
            } else {
                if (listenerHandler.getRequiredEventType() != AbstractHandler.Type.element && event instanceof Element) continue;
                eventObject = event;
            }
            Runnable task = () -> {
                try {
                    listenerHandler.dispatch(eventObject, source, remotelyGeneratedEvent);
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, "Exception during execution of event: " + event.getClass().getCanonicalName(), e);
                }
            };
            this.executor.execute(task);
        }
    }

    private void checkIfEventIsRegistered(String eventName) throws EventBusException {
        if (!this.registrar.isRegistered(eventName)) {
            if (this.acceptOnlyRegisteredEvents) {
                throw new EventBusException("Event " + eventName + " is not registered.");
            }
            log.log(Level.FINEST, "Event " + eventName + " in not registered.");
        }
    }

    private void fillListenersForEvent(HashSet<AbstractHandler> result, Class<?> cls) {
        String packageName = cls.getPackage().getName();
        String eventName = cls.getSimpleName();
        result.addAll(this.listeners.get(packageName, eventName));
        result.addAll(this.listeners.get(packageName, null));
    }

    private void fireListenerAddedEvent(String packageName, String eventName) {
        ListenerAddedEvent event = new ListenerAddedEvent();
        event.setEventName(eventName);
        event.setPackageName(packageName);
        this.fire(event);
    }

    public static class ListenerRemovedEvent
    implements InternalEventbusEvent {
        private String eventName;
        private String packageName;

        public String getEventName() {
            return this.eventName;
        }

        public void setEventName(String eventName) {
            this.eventName = eventName;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }
    }

    public static class ListenerAddedEvent
    implements InternalEventbusEvent {
        private String eventName;
        private String packageName;

        public String getEventName() {
            return this.eventName;
        }

        public void setEventName(String eventName) {
            this.eventName = eventName;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }
    }

    public static interface InternalEventbusEvent {
    }
}

