/*
 * Decompiled with CFR 0.152.
 */
package tigase.component.adhoc;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.adhoc.AdHocCommand;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdHocSession;
import tigase.component.adhoc.AdhHocRequest;
import tigase.component.exceptions.ComponentException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.server.Packet;
import tigase.util.cache.SimpleCache;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.jid.JID;

@Bean(name="adHocCommandManager", active=true)
public class AdHocCommandManager {
    private static final Logger log = Logger.getLogger(AdHocCommandManager.class.getCanonicalName());
    private final Map<String, AdHocCommand> commands = new HashMap<String, AdHocCommand>();
    private final SimpleCache<String, AdHocSession> sessions = new SimpleCache(100, 10000L);
    @Inject(nullAllowed=true)
    private AdHocCommand[] allCommands;

    public Collection<AdHocCommand> getAllCommands() {
        return this.commands.values();
    }

    public void setAllCommands(AdHocCommand[] allCommands) {
        this.allCommands = allCommands;
        this.commands.clear();
        if (allCommands != null) {
            for (AdHocCommand adHocCommand : allCommands) {
                this.commands.put(adHocCommand.getNode(), adHocCommand);
            }
        }
    }

    public AdHocCommand getCommand(String nodeName) {
        return this.commands.get(nodeName);
    }

    public boolean hasCommand(String node) {
        return this.commands.containsKey(node);
    }

    public void process(Packet packet, Consumer<Packet> resultConsumer) throws AdHocCommandException {
        Element element = packet.getElement();
        JID senderJid = packet.getStanzaFrom();
        Element command2 = element.getChild("command", "http://jabber.org/protocol/commands");
        String node = command2.getAttributeStaticStr("node");
        String action = command2.getAttributeStaticStr("action");
        String sessionId = command2.getAttributeStaticStr("sessionid");
        AdHocCommand adHocCommand = this.getCommand(node);
        if (adHocCommand != null) {
            this.process(packet, command2, node, action, sessionId, adHocCommand, resultConsumer);
        }
    }

    public void process(Packet packet, Element commandElement, String node, String action, String sessionId, AdHocCommand adHocCommand, Consumer<Packet> resultConsumer) throws AdHocCommandException {
        AdHocResponse.State currentState = null;
        AdhHocRequest request = new AdhHocRequest(packet, commandElement, node, packet.getStanzaFrom(), action, sessionId);
        AdHocResponse response = new AdHocResponse(sessionId, currentState);
        AdHocSession session = sessionId == null ? new AdHocSession() : (AdHocSession)this.sessions.get((Object)sessionId);
        adHocCommand.execute(request, response, () -> {
            Element commandResult = new Element("command", new String[]{"xmlns", "node"}, new String[]{"http://jabber.org/protocol/commands", node});
            commandResult.addAttribute("status", response.getNewState().name());
            if (response.getCurrentState() == null && response.getNewState() == AdHocResponse.State.executing) {
                this.sessions.put((Object)response.getSessionid(), (Object)session);
            } else if (response.getSessionid() != null && (response.getNewState() == AdHocResponse.State.canceled || response.getNewState() == AdHocResponse.State.completed)) {
                this.sessions.remove((Object)response.getSessionid());
            }
            if (response.getSessionid() != null) {
                commandResult.addAttribute("sessionid", response.getSessionid());
            }
            for (Element r : response.getElements()) {
                commandResult.addChild((XMLNodeIfc)r);
            }
            resultConsumer.accept(packet.okResult(commandResult, 0));
        }, ex -> {
            block2: {
                try {
                    Packet errorResponse = new ComponentException(ex.getErrorCondition(), ex.getMessage()).makeElement(packet, true);
                    resultConsumer.accept(errorResponse);
                }
                catch (PacketErrorTypeException e1) {
                    if (!log.isLoggable(Level.WARNING)) break block2;
                    log.log(Level.WARNING, "Problem during generate error response", e1);
                }
            }
        });
    }

    public void registerCommand(AdHocCommand command2) {
        if (!this.commands.containsKey(command2.getNode())) {
            this.commands.put(command2.getNode(), command2);
        }
    }
}

