/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.SaslException;
import tigase.annotations.TigaseDeprecated;
import tigase.auth.AuthRepositoryAware;
import tigase.auth.DomainAware;
import tigase.auth.callbacks.VerifyPasswordCallback;
import tigase.auth.mechanisms.AbstractSasl;
import tigase.auth.mechanisms.AbstractSaslSCRAM;
import tigase.db.AuthRepository;
import tigase.db.TigaseDBException;
import tigase.util.Base64;
import tigase.xmpp.jid.BareJID;

@Deprecated
@TigaseDeprecated(since="8.0.0")
public class PlainSPCallbackHandler
implements CallbackHandler,
AuthRepositoryAware,
DomainAware {
    protected String domain;
    protected BareJID jid = null;
    protected Logger log = Logger.getLogger(this.getClass().getName());
    protected AuthRepository repo;

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, "Callback: {0}", callbacks[i].getClass().getSimpleName());
            }
            this.handleCallback(callbacks[i]);
        }
    }

    @Override
    public void setAuthRepository(AuthRepository repo) {
        this.repo = repo;
    }

    @Override
    public void setDomain(String domain) {
        this.domain = domain;
    }

    protected void handleAuthorizeCallback(AuthorizeCallback authCallback) {
        String authenId;
        block7: {
            authenId = authCallback.getAuthenticationID();
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, "AuthorizeCallback: authenId: {0}", authenId);
            }
            try {
                if (this.repo.isUserDisabled(this.jid)) {
                    authCallback.setAuthorized(false);
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.log(Level.FINEST, "User {0} is disabled", this.jid);
                    }
                    return;
                }
            }
            catch (TigaseDBException e) {
                if (!this.log.isLoggable(Level.FINEST)) break block7;
                this.log.log(Level.FINEST, "Cannot check if user " + this.jid + " is enabled", e);
            }
        }
        String authorId = authCallback.getAuthorizationID();
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "AuthorizeCallback: authorId: {0}", authorId);
        }
        if (AbstractSasl.isAuthzIDIgnored() || authenId.equals(authorId)) {
            authCallback.setAuthorized(true);
        }
    }

    protected void handleCallback(Callback callback) throws UnsupportedCallbackException, IOException {
        if (callback instanceof RealmCallback) {
            this.handleRealmCallback((RealmCallback)callback);
        } else if (callback instanceof NameCallback) {
            this.handleNameCallback((NameCallback)callback);
        } else if (callback instanceof VerifyPasswordCallback) {
            this.handleVerifyPasswordCallback((VerifyPasswordCallback)callback);
        } else if (callback instanceof AuthorizeCallback) {
            this.handleAuthorizeCallback((AuthorizeCallback)callback);
        } else {
            throw new UnsupportedCallbackException(callback, "Unrecognized Callback");
        }
    }

    protected void handleNameCallback(NameCallback nc) throws IOException {
        String user_name = nc.getDefaultName();
        this.jid = BareJID.bareJIDInstanceNS((String)user_name, (String)this.domain);
        nc.setName(this.jid.toString());
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "NameCallback: {0}", user_name);
        }
    }

    protected void handleRealmCallback(RealmCallback rc) throws IOException {
        String realm = this.domain;
        if (realm != null) {
            rc.setText(realm);
        }
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "RealmCallback: {0}", realm);
        }
    }

    protected void handleVerifyPasswordCallback(VerifyPasswordCallback pc) throws IOException {
        String password = pc.getPassword();
        try {
            String pwd = this.repo.getPassword(this.jid);
            if (pwd == null) {
                throw new SaslException("User " + this.jid + " not found.");
            }
            byte[] buffer = Base64.decode((String)pwd);
            byte[] salt = new byte[20];
            byte[] saltedPassword = new byte[20];
            System.arraycopy(buffer, 0, salt, 0, salt.length);
            System.arraycopy(buffer, salt.length, saltedPassword, 0, saltedPassword.length);
            byte[] np = AbstractSaslSCRAM.hi("SHA1", AbstractSaslSCRAM.normalize(password), salt, 4096);
            pc.setVerified(Arrays.equals(saltedPassword, np));
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, "VerifyPasswordCallback: {0}", "******");
            }
        }
        catch (Exception e) {
            pc.setVerified(false);
            throw new IOException("Password verification problem.", e);
        }
    }
}

