/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.eventbus.EventBus;
import tigase.eventbus.HandleEvent;
import tigase.kernel.DefaultTypesConverter;
import tigase.kernel.TypesConverter;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.map.ClusterMapFactory;
import tigase.server.xmppsession.SessionManager;
import tigase.stats.ComponentStatisticsProvider;
import tigase.stats.StatisticsList;
import tigase.vhosts.VHostItem;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="brute-force-locker", parent=SessionManager.class, active=true)
public class BruteForceLockerBean
implements Initializable,
UnregisterAware,
ComponentStatisticsProvider {
    private static final String ANY = "*";
    private static final String LOCK_ENABLED_KEY = "brute-force-lock-enabled";
    private static final String LOCK_AFTER_FAILS_KEY = "brute-force-lock-after-fails";
    private static final String LOCK_DISABLE_ACCOUNT_FAILS_KEY = "brute-force-disable-after-fails";
    private static final String LOCK_TIME_KEY = "brute-force-lock-time";
    private static final String LOCK_PERIOD_TIME_KEY = "brute-force-period-time";
    private static final String LOCK_MODE_KEY = "brute-force-mode";
    private static final String MAP_TYPE = "brute-force-invalid-logins";
    private final Logger log = Logger.getLogger(this.getClass().getName());
    private final Map<String, StatHolder> otherStatHolders = new ConcurrentHashMap<String, StatHolder>();
    private final StatHolder statHolder = new StatHolder();
    @Inject
    private EventBus eventBus;
    private Map<Key, Value> map;
    @Inject
    private SessionManager sessionManager;

    public static String getClientIp(XMPPResourceConnection session) {
        try {
            return Optional.ofNullable(session.getConnectionId()).map(JID::getResource).map(res -> res.split("_")[2]).orElse(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void addInvalidLogin(XMPPResourceConnection session, String ip, BareJID jid) {
        this.addInvalidLogin(session, ip, jid, System.currentTimeMillis());
    }

    public void addInvalidLogin(XMPPResourceConnection session, String ip, BareJID jid, long currentTime) {
        long lockAfterFails;
        if (ip == null) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("IP is null. Skip adding entry.");
            }
            return;
        }
        if (this.map == null) {
            this.log.warning("Brute Force Locker is no initialized yet!");
            return;
        }
        Key key = this.createKey(session, ip, jid);
        Value value = this.map.get(key);
        if (value == null) {
            value = new Value(session != null ? session.getDomain().getVhost().toString() : null, ip, jid);
            value.setBadLoginCounter(0);
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("Entry didn't exists. Create new one.");
            }
        }
        if (value.getInvalidateAtTime() < currentTime) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("Entry exists and is old, reset counter.");
            }
            value.setBadLoginCounter(0);
        }
        value.setBadLoginCounter(value.getBadLoginCounter() + 1);
        long l = lockAfterFails = session == null ? 3L : (Long)session.getDomain().getData(LOCK_AFTER_FAILS_KEY);
        if ((long)value.getBadLoginCounter() <= lockAfterFails) {
            long periodTime = (session == null ? 10L : (Long)session.getDomain().getData(LOCK_PERIOD_TIME_KEY)) * 1000L;
            value.setInvalidateAtTime(currentTime + periodTime);
        } else {
            long lockTime = (session == null ? 10L : (Long)session.getDomain().getData(LOCK_TIME_KEY)) * 1000L;
            value.setInvalidateAtTime(currentTime + lockTime);
        }
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("New invalidate time for " + key + " == " + value.getInvalidateAtTime() + "; getBadLoginCounter == " + value.getBadLoginCounter());
        }
        this.map.put(key, value);
        this.addToStatistic(value);
    }

    public boolean canUserBeDisabled(XMPPResourceConnection session, String ip, BareJID jid) {
        long disableAfterFails;
        Key key = this.createKey(session, ip, jid);
        if (!key.isJIDPresent()) {
            return false;
        }
        Value value = this.map.get(key);
        if (value == null) {
            return false;
        }
        long l = disableAfterFails = session == null ? 20L : (Long)session.getDomain().getData(LOCK_DISABLE_ACCOUNT_FAILS_KEY);
        if (disableAfterFails == 0L) {
            return false;
        }
        return (long)value.getBadLoginCounter() > disableAfterFails;
    }

    public void clearAll() {
        if (this.map == null) {
            this.log.warning("Brute Force Locker is no initialized yet!");
            return;
        }
        this.map.clear();
    }

    public void clearOutdated() {
        this.clearOutdated(System.currentTimeMillis());
    }

    public void clearOutdated(long currentTime) {
        if (this.map == null) {
            this.log.warning("Brute Force Locker is no initialized yet!");
            return;
        }
        HashSet toRemove = new HashSet();
        this.map.forEach((key, value) -> {
            if (value.getInvalidateAtTime() < currentTime) {
                toRemove.add(key);
            }
        });
        toRemove.forEach(key -> this.map.remove(key));
    }

    @Override
    public void getStatistics(String compName, StatisticsList list) {
        this.clearOutdated();
        String keyName = compName + "/BruteForceLocker";
        ArrayList<Value> l = new ArrayList<Value>(this.map.values());
        for (Value value : l) {
            list.add(keyName, "Present locks: " + value.jid + " from " + value.ip, value.badLoginCounter, Level.FINER);
        }
        StatHolder tmp = new StatHolder();
        this.statHolder.ips.forEach((ip, count) -> tmp.addIP((String)ip, (int)count));
        this.statHolder.jids.forEach((jid, count) -> tmp.addJID((BareJID)jid, (int)count));
        this.otherStatHolders.values().forEach(otherSH -> {
            ((StatHolder)otherSH).ips.forEach((ip, count) -> tmp.addIP((String)ip, (int)count));
            ((StatHolder)otherSH).jids.forEach((jid, count) -> tmp.addJID((BareJID)jid, (int)count));
        });
        tmp.ips.forEach((ip, count) -> list.add(keyName, "From IP: " + ip, (int)count, Level.INFO));
        tmp.jids.forEach((jid, count) -> list.add(keyName, "For JID: " + jid, (int)count, Level.INFO));
    }

    @Override
    public void initialize() {
        this.map = ClusterMapFactory.get().createMap(MAP_TYPE, Key.class, Value.class, new String[0]);
        assert (this.map != null) : "Distributed Map is NULL!";
        assert (this.sessionManager != null) : "SessionManager is NULL!";
        if (this.eventBus != null) {
            this.eventBus.registerAll(this);
        }
    }

    public boolean isEnabled(XMPPResourceConnection session) {
        return session == null || (Boolean)session.getDomain().getData(LOCK_ENABLED_KEY) != false;
    }

    @HandleEvent(filter=HandleEvent.Type.remote)
    public void handleStatisticsEmitEvent(StatisticsEmitEvent event) {
        if (event.getNodeName() == null) {
            return;
        }
        this.otherStatHolders.put(event.getNodeName(), event.getStatHolder());
    }

    public boolean isLoginAllowed(XMPPResourceConnection session, String ip, BareJID jid) {
        return this.isLoginAllowed(session, ip, jid, System.currentTimeMillis());
    }

    public boolean isLoginAllowed(XMPPResourceConnection session, String ip, BareJID jid, long currentTime) {
        if (ip == null) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("IP is null. Return true.");
            }
            return true;
        }
        if (this.map == null) {
            this.log.warning("Brute Force Locker is no initialized yet!");
            return false;
        }
        Key key = this.createKey(session, ip, jid);
        Value value = this.map.get(key);
        if (value == null) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("No entry for " + key + ". Return true.");
            }
            return true;
        }
        return this.isLoginAllowed(session, key, value, currentTime);
    }

    @Override
    public void beforeUnregister() {
        this.eventBus.unregisterAll(this);
    }

    @Override
    public void everyHour() {
    }

    @Override
    public void everyMinute() {
        String clusterNode = this.sessionManager.getComponentId().getDomain();
        this.eventBus.fire(new StatisticsEmitEvent(clusterNode, this.statHolder));
    }

    @Override
    public void everySecond() {
    }

    void setMap(HashMap<Key, Value> map) {
        this.map = map;
    }

    final Key createKey(XMPPResourceConnection session, String ip, BareJID jid) {
        Mode mode = session == null ? Mode.IpJid : Mode.valueOf((String)session.getDomain().getData(LOCK_MODE_KEY));
        return this.createKey(mode, session, ip, jid);
    }

    final Key createKey(Mode mode, XMPPResourceConnection session, String ip, BareJID jid) {
        String domain = session == null ? ANY : session.getDomain().getVhost().toString();
        switch (mode) {
            case Jid: {
                return new Key(ANY, jid == null ? ANY : jid.toString(), domain);
            }
            case Ip: {
                return new Key(ip == null ? ANY : ip, ANY, domain);
            }
            case IpJid: {
                return new Key(ip == null ? ANY : ip, jid == null ? ANY : jid.toString(), domain);
            }
        }
        throw new RuntimeException("Unknown mode " + (Object)((Object)mode));
    }

    private void addToStatistic(Value v) {
        this.statHolder.addIP(v.ip);
        this.statHolder.addJID(v.jid);
    }

    private boolean isLoginAllowed(XMPPResourceConnection session, Key key, Value value, long currentTime) {
        boolean r;
        if (value.getInvalidateAtTime() < currentTime) {
            this.map.remove(key);
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("Entry existed, but was too old. Entry removed. Return true.");
            }
            return true;
        }
        long lockAfterFails = session == null ? 3L : (Long)session.getDomain().getData(LOCK_AFTER_FAILS_KEY);
        boolean bl = r = (long)value.badLoginCounter <= lockAfterFails;
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Entry exist. lockAfterFails=" + lockAfterFails + ", value.badLoginCounter=" + value.badLoginCounter + ", result=" + r);
        }
        return r;
    }

    static {
        ArrayList<VHostItem.DataType> types = new ArrayList<VHostItem.DataType>();
        types.add(new VHostItem.DataType(LOCK_ENABLED_KEY, "Brute Force Prevention Enabled", Boolean.class, Boolean.TRUE));
        types.add(new VHostItem.DataType(LOCK_AFTER_FAILS_KEY, "Number of allowed invalid login", Long.class, (Object)3L));
        types.add(new VHostItem.DataType(LOCK_DISABLE_ACCOUNT_FAILS_KEY, "Disable account after failed login", Long.class, (Object)20L));
        types.add(new VHostItem.DataType(LOCK_PERIOD_TIME_KEY, "Failed login in period of time [sec]", Long.class, (Object)60L));
        types.add(new VHostItem.DataType(LOCK_TIME_KEY, "Lock time [sec]", Long.class, (Object)60L));
        types.add(new VHostItem.DataType(LOCK_MODE_KEY, "Brute Force Prevention Mode", Mode.class, Mode.IpJid));
        VHostItem.registerData(types);
    }

    public static class Value
    implements TypesConverter.Parcelable {
        private final String domain;
        private final String ip;
        private final BareJID jid;
        private int badLoginCounter;
        private long invalidateAtTime;

        Value(String domain, String ip, BareJID jid) {
            this.domain = domain;
            this.ip = ip;
            this.jid = jid;
        }

        @Override
        public String[] encodeToStrings() {
            return new String[]{Integer.toString(this.badLoginCounter), Long.toString(this.invalidateAtTime)};
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Value value = (Value)o;
            if (this.badLoginCounter != value.badLoginCounter) {
                return false;
            }
            return this.invalidateAtTime == value.invalidateAtTime;
        }

        @Override
        public void fillFromString(String[] encoded) {
            this.badLoginCounter = Integer.valueOf(encoded[0]);
            this.invalidateAtTime = Long.valueOf(encoded[1]);
        }

        public int getBadLoginCounter() {
            return this.badLoginCounter;
        }

        public void setBadLoginCounter(int badLoginCounter) {
            this.badLoginCounter = badLoginCounter;
        }

        public long getInvalidateAtTime() {
            return this.invalidateAtTime;
        }

        public void setInvalidateAtTime(long invalidateAtTime) {
            this.invalidateAtTime = invalidateAtTime;
        }

        public int hashCode() {
            int result = this.badLoginCounter;
            result = 31 * result + (int)(this.invalidateAtTime ^ this.invalidateAtTime >>> 32);
            return result;
        }
    }

    public static class StatisticsEmitEvent
    implements Serializable {
        private String nodeName;
        private StatHolder statHolder;

        public StatisticsEmitEvent() {
        }

        public StatisticsEmitEvent(String nodeName, StatHolder statHolder) {
            this.nodeName = nodeName;
            this.statHolder = statHolder;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        public StatHolder getStatHolder() {
            return this.statHolder;
        }

        public void setStatHolder(StatHolder statHolder) {
            this.statHolder = statHolder;
        }
    }

    public static class StatHolder
    implements TypesConverter.Parcelable {
        private final Map<String, Integer> ips = new ConcurrentHashMap<String, Integer>();
        private final Map<BareJID, Integer> jids = new ConcurrentHashMap<BareJID, Integer>();
        private final DefaultTypesConverter typesConverter = new DefaultTypesConverter();

        public Map<String, Integer> getIps() {
            return this.ips;
        }

        public Map<BareJID, Integer> getJids() {
            return this.jids;
        }

        public void clear() {
            this.ips.clear();
            this.jids.clear();
        }

        public int addIP(String ip) {
            return this.add(this.ips, ip, 1);
        }

        public int addJID(BareJID jid) {
            return this.add(this.jids, jid, 1);
        }

        public int addIP(String ip, int value) {
            return this.add(this.ips, ip, value);
        }

        public int addJID(BareJID jid, int value) {
            return this.add(this.jids, jid, value);
        }

        @Override
        public String[] encodeToStrings() {
            String[] r = new String[2 + this.ips.size() * 2 + this.jids.size() * 2];
            r[0] = String.valueOf(this.ips.size());
            r[1] = String.valueOf(this.jids.size());
            this.fillTab(this.ips, r, 2);
            this.fillTab(this.jids, r, 2 + this.ips.size() * 2);
            return r;
        }

        @Override
        public void fillFromString(String[] encoded) {
            int lenIps = Integer.parseInt(encoded[0]);
            int lenJids = Integer.parseInt(encoded[1]);
            this.ips.clear();
            this.ips.putAll(this.read(encoded, 2, lenIps, key -> key));
            this.jids.clear();
            this.jids.putAll(this.read(encoded, 4 + lenIps, lenJids, BareJID::bareJIDInstanceNS));
        }

        private <T> HashMap<T, Integer> read(String[] src, int offset, int len, Function<String, T> keyCnv) {
            HashMap<T, Integer> r = new HashMap<T, Integer>();
            for (int i = 0; i < len; ++i) {
                r.put(keyCnv.apply(src[offset + 2 * i]), Integer.parseInt(src[offset + 2 * i + 1]));
            }
            return r;
        }

        private <T> void fillTab(Map<T, Integer> src, String[] dst, int offset) {
            int idx = offset;
            for (Map.Entry<T, Integer> x : src.entrySet()) {
                String key = x.getKey().toString();
                Integer value = x.getValue();
                dst[idx] = key;
                dst[idx + 1] = String.valueOf(value);
                idx += 2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> int add(Map<T, Integer> map, T key, int value) {
            Map<T, Integer> map2 = map;
            synchronized (map2) {
                Integer v = map.get(key);
                v = (v == null ? 0 : v) + value;
                map.put(key, v);
                return v;
            }
        }
    }

    public static class LoginLockedException
    extends Exception {
    }

    public static class Key
    implements TypesConverter.Parcelable {
        private String domain;
        private String ip;
        private String jid;

        public Key() {
        }

        public Key(String ip, String jid, String domain) {
            this.ip = ip;
            this.jid = jid;
            this.domain = domain;
        }

        @Override
        public String[] encodeToStrings() {
            return new String[]{this.jid, this.ip, this.domain};
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (!this.domain.equals(key.domain)) {
                return false;
            }
            if (!this.ip.equals(key.ip)) {
                return false;
            }
            return this.jid.equals(key.jid);
        }

        @Override
        public void fillFromString(String[] encoded) {
            this.jid = encoded[0];
            this.ip = encoded[1];
            this.domain = encoded[2];
        }

        public String getIp() {
            return this.ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public String getJid() {
            return this.jid;
        }

        public void setJid(String jid) {
            this.jid = jid;
        }

        public int hashCode() {
            int result = this.domain.hashCode();
            result = 31 * result + this.ip.hashCode();
            result = 31 * result + this.jid.hashCode();
            return result;
        }

        public boolean isJIDPresent() {
            return this.jid != null && !this.jid.equals(BruteForceLockerBean.ANY);
        }

        public String toString() {
            return "Key[ip=" + this.ip + ", jid=" + this.jid + ", domain=" + this.domain + "]";
        }
    }

    public static enum Mode {
        Ip,
        IpJid,
        Jid;

    }
}

