/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.UUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.kernel.core.Kernel;
import tigase.server.Packet;
import tigase.server.amp.db.MsgRepository;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.Message;
import tigase.xmpp.impl.MessageAmp;
import tigase.xmpp.impl.ProcessorTestCase;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class MessageAmpTest
extends ProcessorTestCase {
    private static final String XMLNS = "http://jabber.org/protocol/amp";
    private JID ampJid;
    private MessageAmp messageAmp;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.messageAmp = this.getInstance(MessageAmp.class);
        HashMap settings = new HashMap();
        this.ampJid = JID.jidInstance((String)"amp@example1.com");
        Field f = this.messageAmp.getClass().getDeclaredField("ampJID");
        f.setAccessible(true);
        f.set(this.messageAmp, this.ampJid);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.messageAmp = null;
        super.tearDown();
    }

    @Test
    public void testMessageProcessingWithAmp() throws Exception {
        JID senderJid = JID.jidInstance((String)"sender@example.com/res-1");
        JID recipientJid = JID.jidInstance((String)"recipient@example.com/res-2");
        XMPPResourceConnection senderSession = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), senderJid);
        XMPPResourceConnection recipientSession = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), recipientJid);
        Element messageEl = new Element("message", new String[]{"from", "to", "type"}, new String[]{senderJid.toString(), recipientJid.toString(), "chat"});
        messageEl.addChild((XMLNodeIfc)new Element("body", "Test 123"));
        Element ampEl = new Element("amp", new String[]{"xmlns"}, new String[]{XMLNS});
        ampEl.addChild((XMLNodeIfc)new Element("rule", new String[]{"condition", "action", "value"}, new String[]{"expire-at", "drop", "2024-01-01T00:00:00Z"}));
        messageEl.addChild((XMLNodeIfc)ampEl);
        Packet message = Packet.packetInstance((Element)messageEl);
        message.setPacketFrom(senderSession.getConnectionId());
        HashMap settings = new HashMap();
        ArrayDeque results = new ArrayDeque();
        Assert.assertFalse((boolean)this.messageAmp.preProcess(message, senderSession, null, results, settings));
        Assert.assertEquals((long)0L, (long)results.size());
        this.messageAmp.process(message, senderSession, null, results, settings);
        Assert.assertEquals((long)1L, (long)results.size());
        message = (Packet)results.poll();
        Assert.assertEquals((Object)senderSession.getConnectionId().toString(), (Object)message.getAttributeStaticStr("from-conn-id"));
        Assert.assertEquals((Object)this.ampJid, (Object)message.getPacketTo());
        message.getElement().removeAttribute("from-conn-id");
        message.setPacketTo(null);
        Assert.assertFalse((boolean)this.messageAmp.preProcess(message, senderSession, null, results, settings));
        Assert.assertEquals((long)0L, (long)results.size());
        Assert.assertTrue((boolean)this.messageAmp.preProcess(message, recipientSession, null, results, settings));
        Assert.assertEquals((long)1L, (long)results.size());
        message = (Packet)results.poll();
        Assert.assertEquals(null, (Object)message.getAttributeStaticStr("from-conn-id"));
        Assert.assertEquals((Object)this.ampJid, (Object)message.getPacketTo());
        message.setPacketFrom(this.ampJid);
        message.setPacketTo(null);
        Assert.assertFalse((boolean)this.messageAmp.preProcess(message, recipientSession, null, results, settings));
        Assert.assertEquals((long)0L, (long)results.size());
        this.messageAmp.process(message, recipientSession, null, results, settings);
        Assert.assertEquals((long)1L, (long)results.size());
        message = (Packet)results.poll();
        Assert.assertEquals(null, (Object)message.getAttributeStaticStr("from-conn-id"));
        Assert.assertEquals((Object)recipientSession.getConnectionId(), (Object)message.getPacketTo());
    }

    @Test
    public void testSilentlyIgnoringMessages() throws Exception {
        BareJID userJid = BareJID.bareJIDInstance((String)"user1@example.com");
        JID res1 = JID.jidInstance((BareJID)userJid, (String)"res1");
        Element packetEl = new Element("message", new String[]{"from", "to"}, new String[]{"remote-user@test.com/res1", res1.toString()});
        Packet packet = Packet.packetInstance((Element)packetEl);
        ArrayDeque results = new ArrayDeque();
        this.messageAmp.process(packet, null, null, results, null);
        Assert.assertTrue((String)"no error was generated", (!results.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((String)"generated result is not an error", (boolean)((Packet)results.poll()).getType().equals((Object)StanzaType.error));
        results.clear();
        Message messageProcessor = (Message)((Kernel)this.getInstance("amp#KERNEL")).getInstance(Message.class);
        Field f = messageProcessor.getClass().getDeclaredField("silentlyIgnoreError");
        f.setAccessible(true);
        f.set(messageProcessor, true);
        this.messageAmp.process(packet, null, null, results, null);
        Assert.assertTrue((String)"result was generated", (boolean)results.isEmpty());
    }

    @Test
    public void testMessageProcessingWithoutAmp() throws Exception {
        JID senderJid = JID.jidInstance((String)"sender@example.com/res-1");
        JID recipientJid = JID.jidInstance((String)"recipient@example.com/res-2");
        XMPPResourceConnection senderSession = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), senderJid);
        XMPPResourceConnection recipientSession = this.getSession(JID.jidInstance((String)("c2s@example.com/" + UUID.randomUUID().toString())), recipientJid);
        Element messageEl = new Element("message", new String[]{"from", "to", "type"}, new String[]{senderJid.toString(), recipientJid.toString(), "chat"});
        messageEl.addChild((XMLNodeIfc)new Element("body", "Test 123"));
        Packet message = Packet.packetInstance((Element)messageEl);
        message.setPacketFrom(senderSession.getConnectionId());
        HashMap settings = new HashMap();
        ArrayDeque results = new ArrayDeque();
        Assert.assertFalse((boolean)this.messageAmp.preProcess(message, senderSession, null, results, settings));
        Assert.assertEquals((long)0L, (long)results.size());
        this.messageAmp.process(message, senderSession, null, results, settings);
        Assert.assertEquals((long)1L, (long)results.size());
        message = (Packet)results.poll();
        Assert.assertEquals(null, (Object)message.getAttributeStaticStr("from-conn-id"));
        Assert.assertEquals(null, (Object)message.getPacketFrom());
        Assert.assertEquals(null, (Object)message.getPacketTo());
        Assert.assertFalse((boolean)this.messageAmp.preProcess(message, recipientSession, null, results, settings));
        Assert.assertEquals((long)0L, (long)results.size());
        this.messageAmp.process(message, recipientSession, null, results, settings);
        Assert.assertEquals((long)1L, (long)results.size());
        message = (Packet)results.poll();
        Assert.assertEquals(null, (Object)message.getAttributeStaticStr("from-conn-id"));
        Assert.assertEquals((Object)recipientSession.getConnectionId(), (Object)message.getPacketTo());
    }

    @Override
    protected void registerBeans(Kernel kernel) {
        kernel.setForceAllowNull(true);
        super.registerBeans(kernel);
        MsgRepository.MsgRepositoryMDBean msgRepo = new MsgRepository.MsgRepositoryMDBean();
        kernel.registerBean("msgRepository").asInstance((Object)msgRepo).exportable().exec();
        kernel.registerBean(MessageAmp.class).exec();
    }
}

