/*
 * Decompiled with CFR 0.152.
 */
package tigase.kernel;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import tigase.TestLogger;
import tigase.kernel.Bean1;
import tigase.kernel.Bean10;
import tigase.kernel.Bean2;
import tigase.kernel.Bean3;
import tigase.kernel.Bean4;
import tigase.kernel.Bean5;
import tigase.kernel.Bean5Factory;
import tigase.kernel.Bean6;
import tigase.kernel.Bean7;
import tigase.kernel.Bean8;
import tigase.kernel.DefaultTypesConverter;
import tigase.kernel.KernelException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.config.AbstractBeanConfigurator;
import tigase.kernel.core.BeanConfig;
import tigase.kernel.core.DependencyGrapher;
import tigase.kernel.core.Kernel;
import tigase.kernel.core.PlantUMLGrapher;

public class KernelTest {
    private static final Logger log = TestLogger.getLogger(KernelTest.class);

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Test
    public void test() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Kernel krnl = new Kernel();
        Bean4 bean4_1_o = new Bean4();
        krnl.registerBean(Bean1.class).exec();
        krnl.registerBean("bean2").asClass(Bean2.class).exec();
        krnl.registerBean("bean3").asClass(Bean3.class).exec();
        krnl.registerBean("bean4").asClass(Bean4.class).exec();
        krnl.registerBean("bean4_1").asInstance((Object)bean4_1_o).exec();
        krnl.registerBean("bean5").asClass(Bean5.class).withFactory(Bean5Factory.class).exec();
        DependencyGrapher dg = new DependencyGrapher(krnl);
        log.log(Level.FINE, dg.getDependencyGraph());
        Bean1 b1 = (Bean1)krnl.getInstance("bean1");
        Bean2 b2 = (Bean2)krnl.getInstance("bean2");
        Bean3 b3 = (Bean3)krnl.getInstance("bean3");
        Bean4 b4 = (Bean4)krnl.getInstance("bean4");
        Bean4 b41 = (Bean4)krnl.getInstance("bean4_1");
        Assert.assertNotNull((Object)b1);
        Assert.assertNotNull((Object)b2);
        Assert.assertNotNull((Object)b3);
        Assert.assertNotNull((Object)b4);
        Assert.assertNotNull((Object)b41);
        Assert.assertEquals((Object)b41, (Object)bean4_1_o);
        Assert.assertTrue((boolean)(b1 instanceof Bean1));
        Assert.assertTrue((boolean)(b2 instanceof Bean2));
        Assert.assertTrue((boolean)(b3 instanceof Bean3));
        Assert.assertTrue((boolean)(b4 instanceof Bean4));
        Assert.assertTrue((boolean)(b41 instanceof Bean4));
        Assert.assertEquals((Object)b2, (Object)b1.getBean2());
        Assert.assertEquals((Object)b3, (Object)b1.getBean3());
        Assert.assertEquals((Object)b3, (Object)b2.getBean3());
        Assert.assertEquals((Object)b41, (Object)b2.getBean4());
        Assert.assertEquals((Object)b4, (Object)b3.getBean4());
        Assert.assertEquals((Object)b41, (Object)b3.getBean41());
        Assert.assertNotNull((Object)b1.getTableOfSpecial());
        Assert.assertEquals((long)3L, (long)b1.getTableOfSpecial().length);
        Assert.assertEquals((long)3L, (long)b1.getCollectionOfSpecial().size());
        Assert.assertTrue((boolean)b1.getCollectionOfSpecial().contains(b3));
        Assert.assertTrue((boolean)b1.getCollectionOfSpecial().contains(b4));
        Assert.assertTrue((boolean)b1.getCollectionOfSpecial().contains(b41));
        krnl.unregister("bean4_1");
        try {
            Assert.assertNull((Object)krnl.getInstance("bean4_1"));
            Assert.fail();
        }
        catch (KernelException e) {
            Assert.assertEquals((Object)"Unknown bean 'bean4_1'.", (Object)e.getMessage());
        }
        Assert.assertNull((Object)b3.getBean41());
        Assert.assertNull((Object)b2.getBean4());
        Assert.assertNotNull((Object)b1.getBean2());
        Assert.assertNotNull((Object)b1.getBean3());
        Assert.assertEquals((long)2L, (long)b1.getTableOfSpecial().length);
        Assert.assertEquals((long)2L, (long)b1.getCollectionOfSpecial().size());
        Assert.assertTrue((boolean)b1.getCollectionOfSpecial().contains(b3));
        Assert.assertTrue((boolean)b1.getCollectionOfSpecial().contains(b4));
        krnl.registerBean("bean6").asClass(Bean6.class).exec();
        Assert.assertEquals((long)3L, (long)b1.getTableOfSpecial().length);
        Assert.assertEquals((long)3L, (long)b1.getCollectionOfSpecial().size());
        log.log(Level.FINE, dg.getDependencyGraph());
    }

    @Test
    public void test2() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Kernel krnl = new Kernel();
        krnl.registerBean("bean7").asClass(Bean7.class).exec();
        krnl.registerBean("beanX").asClass(Bean4.class).exec();
        krnl.registerBean("beanX").asClass(Bean5.class).withFactory(Bean5Factory.class).exec();
        Assert.assertEquals(Bean5.class, ((Bean7)krnl.getInstance(Bean7.class)).getObj().getClass());
        Assert.assertEquals(Bean5.class, krnl.getInstance("beanX").getClass());
        krnl.registerBean("beanX").asClass(Bean6.class).exec();
        Assert.assertEquals(Bean6.class, krnl.getInstance("beanX").getClass());
        Assert.assertEquals(Bean6.class, ((Bean7)krnl.getInstance(Bean7.class)).getObj().getClass());
    }

    @Test
    public void test3() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Kernel krnl = new Kernel();
        krnl.registerBean(Bean1.class).exec();
        krnl.registerBean("bean4").asClass(Bean4.class).exec();
        Bean1 b1 = (Bean1)krnl.getInstance("bean1");
        Assert.assertNotNull((Object)b1);
        Assert.assertNotNull((Object)b1.getTableOfSpecial());
        Assert.assertEquals((long)1L, (long)b1.getTableOfSpecial().length);
        Assert.assertEquals((long)1L, (long)b1.getCollectionOfSpecial().size());
    }

    @Test
    public void test4() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Kernel krnl = new Kernel();
        krnl.registerBean(Bean1.class).exec();
        Bean1 b1 = (Bean1)krnl.getInstance("bean1");
        Assert.assertNotNull((Object)b1);
        Assert.assertNull((Object)b1.getTableOfSpecial());
        Assert.assertEquals((long)0L, (long)b1.getCollectionOfSpecial().size());
    }

    @Test
    public void test5() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Kernel krnl = new Kernel();
        krnl.registerBean(Bean8.class).exec();
        try {
            krnl.getInstance("bean8");
            Assert.fail((String)"This bean shouldn't be initialized because of empty dependency.");
        }
        catch (KernelException e) {
            Assert.assertEquals((Object)"tigase.kernel.KernelException: Can't inject <null> to field tigase.kernel.Bean8.bean6", (Object)e.getMessage());
        }
    }

    @Test
    public void testBeanConfiguration() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Kernel krnl = new Kernel();
        krnl.registerBean(CustomTypesConverter.class).exec();
        krnl.registerBean("bean5").asClass(Bean5.class).exec();
        krnl.registerBean(DefaultTypesConverter.class).exec();
        krnl.registerBean("defaultBeanConfigurator").asClass(TestBeanConfigurationProvider.class).exec();
        krnl.registerBean("bean6").asClass(Bean6.class).exec();
        krnl.registerBean(Bean8.class).exec();
        Bean5 b5 = (Bean5)krnl.getInstance(Bean5.class);
        Bean6 b6 = (Bean6)krnl.getInstance(Bean6.class);
        Bean8 b8 = (Bean8)krnl.getInstance(Bean8.class);
        Assert.assertEquals((Object)"yytestxx", (Object)b6.getTestValue());
        Assert.assertEquals((long)9987L, (long)b5.getValue());
        Assert.assertEquals((Object)"EXAMPLE", (Object)b8.getSample());
        ((TestBeanConfigurationProvider)((Object)krnl.getInstance("defaultBeanConfigurator"))).restoreDefaults("bean5");
        Assert.assertEquals((Object)"yytestxx", (Object)b6.getTestValue());
        Assert.assertEquals((long)15L, (long)b5.getValue());
        ((TestBeanConfigurationProvider)((Object)krnl.getInstance("defaultBeanConfigurator"))).restoreDefaults("bean6");
        Assert.assertNull((Object)b6.getTestValue());
        Assert.assertEquals((long)15L, (long)b5.getValue());
    }

    @Test
    public void testCascadeKernels() throws Exception {
        Kernel krnlParent = new Kernel("Parent");
        krnlParent.registerBean("bean1").asClass(Bean1.class).exec();
        krnlParent.registerBean("bean40").asClass(Bean4.class).exportable().exec();
        krnlParent.registerBean("bean41").asClass(Bean4.class).exec();
        krnlParent.registerBean("bean42").asClass(Bean4.class).exportable().exec();
        krnlParent.registerBean("bean5").asClass(Bean5.class).exportable().exec();
        Bean5 b5parent = new Bean5();
        Bean5 b51parent = new Bean5();
        krnlParent.registerBean("bean5").asInstance((Object)b5parent).exportable().exec();
        krnlParent.registerBean("bean51").asInstance((Object)b51parent).exportable().exec();
        Kernel krnlChild1 = new Kernel("Child01");
        krnlChild1.registerBean("bean40").asClass(Bean4.class).exportable().exec();
        Bean5 b5ch1 = new Bean5();
        krnlChild1.registerBean("bean5").asInstance((Object)b5ch1).exportable().exec();
        Kernel krnlChild2 = new Kernel("Child02");
        krnlChild2.registerBean("bean1").asClass(Bean1.class).exec();
        krnlChild2.registerBean("bean43").asClass(Bean4.class).exec();
        krnlParent.registerBean(krnlChild1.getName()).asInstance((Object)krnlChild1).exec();
        krnlParent.registerBean(krnlChild2.getName()).asInstance((Object)krnlChild2).exec();
        Bean1 bean1 = (Bean1)krnlChild2.getInstance(Bean1.class);
        Assert.assertEquals((long)3L, (long)bean1.getCollectionOfSpecial().size());
        Assert.assertTrue((String)"Bean should be located in parent", (boolean)krnlChild2.isBeanClassRegistered("bean40"));
        Assert.assertNotNull((String)"Bean should be get from parent!", (Object)krnlChild2.getInstance("bean40"));
        Assert.assertEquals((Object)krnlParent.getInstance("bean40"), (Object)krnlChild2.getInstance("bean40"));
        Assert.assertTrue((boolean)bean1.getCollectionOfSpecial().contains(krnlParent.getInstance("bean40")));
        Assert.assertTrue((boolean)bean1.getCollectionOfSpecial().contains(krnlParent.getInstance("bean42")));
        Assert.assertEquals((long)3L, (long)bean1.getTableOfSpecial().length);
        DependencyGrapher dg = new DependencyGrapher(krnlParent);
        log.log(Level.FINE, dg.getDependencyGraph());
        Assert.assertEquals((Object)b5ch1, (Object)krnlChild1.getInstance("bean5"));
        Assert.assertEquals((Object)b51parent, (Object)krnlChild1.getInstance("bean51"));
        Assert.assertNotNull((Object)krnlChild1.getInstance(Bean5.class));
        try {
            krnlChild1.getInstance(Bean1.class);
            Assert.fail();
        }
        catch (KernelException e) {
            Assert.assertEquals((Object)"Can't find bean implementing class tigase.kernel.Bean1", (Object)e.getMessage());
        }
        try {
            krnlChild1.getInstance(Bean3.class);
            Assert.fail();
        }
        catch (KernelException e) {
            Assert.assertEquals((Object)"Can't find bean implementing class tigase.kernel.Bean3", (Object)e.getMessage());
        }
        try {
            krnlChild1.getInstance("zzz");
            Assert.fail();
        }
        catch (KernelException e) {
            Assert.assertEquals((Object)"Unknown bean 'zzz'.", (Object)e.getMessage());
        }
    }

    @Test
    public void testGc() throws Exception {
        Kernel krnl = new Kernel();
        krnl.registerBean(DefaultTypesConverter.class).exec();
        krnl.registerBean(Bean10.class).setPinned(false).exec();
        krnl.registerBean("a_1").asClass(Bean6.class).setPinned(false).exec();
        krnl.registerBean(Bean1.class).setPinned(false).exec();
        krnl.registerBean("bean2").asClass(Bean2.class).setPinned(false).setActive(true).exec();
        krnl.registerBean("bean3").asClass(Bean3.class).setPinned(false).exec();
        krnl.registerBean("bean4").asClass(Bean4.class).setPinned(false).exec();
        krnl.registerBean("bean5").asClass(Bean5.class).setPinned(false).withFactory(Bean5Factory.class).exec();
        PlantUMLGrapher g = new PlantUMLGrapher(krnl);
        log.log(Level.FINE, g.getDependencyGraph());
        Assert.assertEquals((long)1L, (long)krnl.getDependencyManager().getBeanConfigs().stream().filter(bc -> bc.getState() == BeanConfig.State.initialized).count());
        krnl.getInstance(Bean1.class);
        krnl.getInstance(Bean10.class);
        Assert.assertEquals((long)7L, (long)krnl.getDependencyManager().getBeanConfigs().stream().filter(bc -> bc.getState() == BeanConfig.State.initialized).count());
        krnl.gc();
        Assert.assertEquals((long)1L, (long)krnl.getDependencyManager().getBeanConfigs().stream().filter(bc -> bc.getState() == BeanConfig.State.initialized).count());
        krnl.getInstance(Bean5.class);
        Assert.assertEquals((long)8L, (long)krnl.getDependencyManager().getBeanConfigs().stream().filter(bc -> bc.getState() == BeanConfig.State.initialized).count());
        krnl.gc();
        Assert.assertEquals((long)1L, (long)krnl.getDependencyManager().getBeanConfigs().stream().filter(bc -> bc.getState() == BeanConfig.State.initialized).count());
        krnl.getDependencyManager().getBeanConfig("bean10").setPinned(true);
        krnl.getInstance(Bean1.class);
        krnl.getInstance(Bean10.class);
        Assert.assertEquals((long)7L, (long)krnl.getDependencyManager().getBeanConfigs().stream().filter(bc -> bc.getState() == BeanConfig.State.initialized).count());
        krnl.gc();
        Assert.assertEquals((long)5L, (long)krnl.getDependencyManager().getBeanConfigs().stream().filter(bc -> bc.getState() == BeanConfig.State.initialized).count());
    }

    @Test
    public void testInactiveBean() throws Exception {
        Kernel krnl = new Kernel();
        krnl.registerBean(DefaultTypesConverter.class).exec();
        krnl.registerBean(Bean10.class).exec();
        krnl.registerBean("a_1").asClass(Bean6.class).exec();
        krnl.registerBean("a_2").asClass(Bean6.class).exec();
        krnl.registerBean("a_3").asClass(Bean6.class).setActive(false).exec();
        krnl.registerBean(Bean1.class).exec();
        krnl.registerBean("bean2").asClass(Bean2.class).setActive(false).exec();
        krnl.registerBean("bean3").asClass(Bean3.class).exec();
        krnl.registerBean("bean4").asClass(Bean4.class).exec();
        krnl.registerBean("bean5").asClass(Bean5.class).withFactory(Bean5Factory.class).exec();
        Bean1 b1 = (Bean1)krnl.getInstance(Bean1.class);
        Bean10 b10 = (Bean10)krnl.getInstance("bean10");
        Assert.assertNull((Object)b1.getBean2());
        Assert.assertEquals((long)4L, (long)b10.getTableOfSpecial().length);
        krnl.setBeanActive("a_3", true);
        krnl.setBeanActive("bean2", true);
        Assert.assertNotNull((Object)b1.getBean2());
        Assert.assertEquals((long)5L, (long)b10.getTableOfSpecial().length);
        krnl.setBeanActive("bean2", false);
        krnl.setBeanActive("a_1", false);
        Assert.assertNull((Object)b1.getBean2());
        Assert.assertEquals((long)4L, (long)b10.getTableOfSpecial().length);
        krnl.setBeanActive("a_1", false);
        Assert.assertNull((Object)b1.getBean2());
        Assert.assertEquals((long)4L, (long)b10.getTableOfSpecial().length);
    }

    public static class TestBeanConfigurationProvider
    extends AbstractBeanConfigurator {
        public Map<String, Object> getProperties() {
            return new HashMap<String, Object>();
        }

        public Map<String, Object> getConfiguration(BeanConfig beanConfig) {
            if (beanConfig.getBeanName().equals("bean5")) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("value", 9987L);
                return result;
            }
            if (beanConfig.getBeanName().equals("bean6")) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("testValue", "yytestxx");
                return result;
            }
            if (beanConfig.getBeanName().equals("bean8")) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("sample", "___EXAMPLE");
                return result;
            }
            return null;
        }

        protected boolean hasDirectConfiguration(BeanConfig bc) {
            return false;
        }
    }

    @Bean(name="customTypesConverter", active=true)
    public static class CustomTypesConverter
    extends DefaultTypesConverter {
        public <T> T convert(Object value, Class<T> expectedType, Type type) {
            return (T)super.convert((Object)value.toString().substring(3), expectedType, type);
        }

        public String toString(Object value) {
            return "___" + super.toString(value);
        }
    }
}

