/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth.mechanisms;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import tigase.TestLogger;
import tigase.auth.callbacks.AuthorizationIdCallback;
import tigase.auth.callbacks.ChannelBindingCallback;
import tigase.auth.callbacks.PBKDIterationsCallback;
import tigase.auth.callbacks.SaltCallback;
import tigase.auth.callbacks.SaltedPasswordCallback;
import tigase.auth.callbacks.XMPPSessionCallback;
import tigase.auth.mechanisms.AbstractSaslSCRAM;
import tigase.auth.mechanisms.SaslSCRAM;
import tigase.tests.SlowTest;
import tigase.util.Base64;

public class SaslSCRAMTest
extends TestCase {
    private static final Logger log = TestLogger.getLogger(SaslSCRAMTest.class);

    @Test
    public void testH() {
        try {
            SaslSCRAM m = this.create("QSXCR+Q6sek8bf92", "3rfcNHYJY1ZVvWVs7j", "pencil");
            byte[] r = m.h("The quick brown fox jumps over the lazy cog".getBytes());
            Assert.assertArrayEquals((byte[])Base64.decode((String)"3p8sf9JeGzr60+haC9F9mxANtLM="), (byte[])r);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            SaslSCRAMTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testHi() {
        try {
            byte[] r = AbstractSaslSCRAM.hi((String)"SHA1", (byte[])"password".getBytes(), (byte[])"salt".getBytes(), (int)1);
            Assert.assertArrayEquals((byte[])new byte[]{12, 96, -56, 15, -106, 31, 14, 113, -13, -87, -75, 36, -81, 96, 18, 6, 47, -32, 55, -90}, (byte[])r);
            r = AbstractSaslSCRAM.hi((String)"SHA1", (byte[])"password".getBytes(), (byte[])"salt".getBytes(), (int)2);
            Assert.assertArrayEquals((byte[])new byte[]{-22, 108, 1, 77, -57, 45, 111, -116, -51, 30, -39, 42, -50, 29, 65, -16, -40, -34, -119, 87}, (byte[])r);
            r = AbstractSaslSCRAM.hi((String)"SHA1", (byte[])"password".getBytes(), (byte[])"salt".getBytes(), (int)4096);
            Assert.assertArrayEquals((byte[])new byte[]{75, 0, 121, 1, -73, 101, 72, -102, -66, -83, 73, -39, 38, -9, 33, -48, 101, -92, 41, -63}, (byte[])r);
        }
        catch (Exception e) {
            e.printStackTrace();
            SaslSCRAMTest.fail((String)e.getMessage());
        }
    }

    @Category(value={SlowTest.class})
    @Test
    public void testHiLong() {
        try {
            byte[] r = AbstractSaslSCRAM.hi((String)"SHA1", (byte[])"password".getBytes(), (byte[])"salt".getBytes(), (int)0x1000000);
            Assert.assertArrayEquals((byte[])new byte[]{-18, -2, 61, 97, -51, 77, -92, -28, -23, -108, 91, 61, 107, -94, 21, -116, 38, 52, -23, -124}, (byte[])r);
        }
        catch (Exception e) {
            e.printStackTrace();
            SaslSCRAMTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testHmac() {
        SaslSCRAM m = this.create("QSXCR+Q6sek8bf92", "3rfcNHYJY1ZVvWVs7j", "pencil");
        try {
            byte[] r = AbstractSaslSCRAM.hmac((SecretKey)m.key("foo".getBytes()), (byte[])"foobar".getBytes());
            Assert.assertArrayEquals((byte[])new byte[]{-92, -18, -70, -114, 99, 61, 119, -120, 105, -11, 104, -48, 90, 27, 61, -57, 43, -3, 4, -35}, (byte[])r);
        }
        catch (Exception e) {
            e.printStackTrace();
            SaslSCRAMTest.fail((String)e.getMessage());
        }
    }

    @Test
    public void testServerFirstMessage() {
        byte[] CFM = "n,,n=user,r=fyko+d2lbbFgONRv9qkxdawL".getBytes();
        byte[] SFM = "r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,s=QSXCR+Q6sek8bf92,i=4096".getBytes();
        byte[] CSM = "c=biws,r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,p=v0X8v3Bz2T0CJGbJQyF0X+HI4Ts=".getBytes();
        byte[] SSM = "v=rmF9pqV8S7suAoZWja4dJRkFsKQ=".getBytes();
        SaslSCRAM m = this.create("QSXCR+Q6sek8bf92", "3rfcNHYJY1ZVvWVs7j", "pencil");
        try {
            log.log(Level.FINE, ">> " + new String(CFM));
            byte[] sfm = m.evaluateResponse(CFM);
            log.log(Level.FINE, "<< " + new String(sfm));
            Assert.assertArrayEquals((byte[])SFM, (byte[])sfm);
            log.log(Level.FINE, ">> " + new String(CSM));
            byte[] ssm = m.evaluateResponse(CSM);
            log.log(Level.FINE, "<< " + new String(ssm));
            Assert.assertArrayEquals((byte[])SSM, (byte[])ssm);
        }
        catch (Exception e) {
            e.printStackTrace();
            SaslSCRAMTest.fail((String)e.getMessage());
        }
        SaslSCRAMTest.assertTrue((boolean)m.isComplete());
        SaslSCRAMTest.assertEquals((String)"user@domain.com", (String)m.getAuthorizationID());
    }

    @Test
    public void testServerFirstMessageFail_1() {
        try {
            SaslSCRAM m = this.create("QSXCR+Q6sek8bf92", "3rfcNHYJY1ZVvWVs7j", "pencil");
            byte[] r = m.evaluateResponse("p=tls-unique,,n=bmalkow,r=SpiXKmhi57DBp5sdE5G3H3ms".getBytes());
            SaslSCRAMTest.fail();
        }
        catch (SaslException e) {
            Assert.assertEquals((Object)"Invalid request for SCRAM-SHA-1", (Object)e.getMessage());
        }
    }

    @Test
    public void testDataExchange01() throws Exception {
        byte[] CFM = Base64.decode((String)"biwsbj1qZW5raW5zLHI9YmdId0xRSEJkNFMrK3F2VEIzZis0QT09");
        byte[] SFM = Base64.decode((String)"cj1iZ0h3TFFIQmQ0UysrcXZUQjNmKzRBPT1lWXY4REhIMk81dHRxNlRtV3pncyxzPUZSelkraGM5TitMc0FnPT0saT00MDk2");
        byte[] CSM = Base64.decode((String)"Yz1iaXdzLHI9YmdId0xRSEJkNFMrK3F2VEIzZis0QT09ZVl2OERISDJPNXR0cTZUbVd6Z3MscD1JTlpKaDljTkQyeFJlYzZBQytSYlBoRVdVakk9");
        SaslSCRAM m = this.create("FRzY+hc9N+LsAg==", "eYv8DHH2O5ttq6TmWzgs", "test");
        try {
            log.log(Level.FINE, ">> " + new String(CFM));
            byte[] sfm = m.evaluateResponse(CFM);
            log.log(Level.FINE, "<< " + new String(sfm));
            Assert.assertArrayEquals((byte[])SFM, (byte[])sfm);
            log.log(Level.FINE, ">> " + new String(CSM));
            byte[] ssm = m.evaluateResponse(CSM);
            log.log(Level.FINE, "<< " + new String(ssm));
        }
        catch (Exception e) {
            e.printStackTrace();
            SaslSCRAMTest.fail((String)e.getMessage());
        }
    }

    private SaslSCRAM create(String salt, String snonce, String password) {
        TestCallbackHandler h = new TestCallbackHandler();
        h.setSalt(salt);
        h.setPassword(password);
        SaslSCRAM m = new SaslSCRAM(null, h, snonce){};
        return m;
    }

    static class TestCallbackHandler
    implements CallbackHandler {
        private String authorizedId = "user@domain.com";
        private byte[] bindingData;
        private int iterations = 4096;
        private String name = "user@domain.com";
        private String password;
        private String salt;

        public byte[] getBindingData() {
            return this.bindingData;
        }

        public void setBindingData(byte[] bindingData) {
            this.bindingData = bindingData;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAuthorizedId() {
            return this.authorizedId;
        }

        public void setAuthorizedId(String authorizedId) {
            this.authorizedId = authorizedId;
        }

        public String getSalt() {
            return this.salt;
        }

        public void setSalt(String salt) {
            this.salt = salt;
        }

        public int getIterations() {
            return this.iterations;
        }

        public void setIterations(int iterations) {
            this.iterations = iterations;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof XMPPSessionCallback) continue;
                if (callback instanceof ChannelBindingCallback) {
                    if (((ChannelBindingCallback)callback).getRequestedBindType() != AbstractSaslSCRAM.BindType.tls_unique) continue;
                    ((ChannelBindingCallback)callback).setBindingData(this.bindingData);
                    continue;
                }
                if (callback instanceof PBKDIterationsCallback) {
                    ((PBKDIterationsCallback)callback).setInterations(this.iterations);
                    continue;
                }
                if (callback instanceof SaltedPasswordCallback) {
                    try {
                        byte[] r = AbstractSaslSCRAM.hi((String)"SHA1", (byte[])this.password.getBytes(), (byte[])Base64.decode((String)this.salt), (int)this.iterations);
                        ((SaltedPasswordCallback)callback).setSaltedPassword(r);
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (callback instanceof NameCallback) {
                    ((NameCallback)callback).setName(this.name);
                    continue;
                }
                if (callback instanceof AuthorizationIdCallback) continue;
                if (callback instanceof SaltCallback) {
                    ((SaltCallback)callback).setSalt(Base64.decode((String)this.salt));
                    continue;
                }
                if (callback instanceof AuthorizeCallback) {
                    ((AuthorizeCallback)callback).setAuthorized(true);
                    ((AuthorizeCallback)callback).setAuthorizedID(this.authorizedId);
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unrecognized Callback " + callback);
            }
        }
    }
}

