/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth.credentials.entries;

import org.junit.Assert;
import org.junit.Test;
import tigase.auth.credentials.entries.ScramCredentialsEntry;
import tigase.xmpp.jid.BareJID;

public class ScramCredentialsEntryTest {
    @Test
    public void testEncodingAndDecoding() {
        String testPassword = "some-password-do-protect";
        BareJID user = BareJID.bareJIDInstanceNS((String)"user@domain");
        ScramCredentialsEntry.Encoder encoder = new ScramCredentialsEntry.Encoder("SHA1");
        String encPassword = encoder.encode(user, testPassword);
        ScramCredentialsEntry.Decoder decoder = new ScramCredentialsEntry.Decoder("SHA1");
        ScramCredentialsEntry entry = (ScramCredentialsEntry)decoder.decode(user, encPassword);
        Assert.assertTrue((boolean)entry.verifyPlainPassword(testPassword));
    }

    @Test
    public void testDecodingOfStoredValue() {
        String testPassword = "some-password-do-protect";
        BareJID user = BareJID.bareJIDInstanceNS((String)"user@domain");
        String encPassword = "s=a526P5eUQMim7g==,i=4096,p=lMVlJo/obJ9xI7P9+vZdbwrHjoA=";
        ScramCredentialsEntry.Decoder decoder = new ScramCredentialsEntry.Decoder("SHA1");
        ScramCredentialsEntry entry = (ScramCredentialsEntry)decoder.decode(user, encPassword);
        Assert.assertTrue((boolean)entry.verifyPlainPassword(testPassword));
    }
}

