/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import tigase.auth.BruteForceLockerBean;
import tigase.eventbus.impl.EventBusSerializer;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;

public class BruteForceLockerBeanTest {
    @Test
    public void testNestedMaps() {
        EventBusSerializer converter = new EventBusSerializer();
        Event event = new Event();
        event.getHolder().addIP("1.2.3.4");
        event.getHolder().addIP("1.2.3.4");
        event.getHolder().addIP("1.2.3.4");
        event.getHolder().addIP("1.2.3.4");
        event.getHolder().addIP("1.2.3.5");
        event.getHolder().addJID(BareJID.bareJIDInstanceNS((String)"a@b.c"));
        event.getHolder().addJID(BareJID.bareJIDInstanceNS((String)"b@b.c"));
        event.getHolder().addJID(BareJID.bareJIDInstanceNS((String)"c@b.c"));
        event.getHolder().addJID(BareJID.bareJIDInstanceNS((String)"c@b.c"));
        event.getHolder().addJID(BareJID.bareJIDInstanceNS((String)"c@b.c"));
        Element s = converter.serialize((Object)event);
        System.out.println(s.toString());
    }

    @Test
    public void testStatsSerializer() {
        BruteForceLockerBean.StatHolder sh1 = new BruteForceLockerBean.StatHolder();
        sh1.addIP("1.2.3.4");
        sh1.addIP("1.2.3.4");
        sh1.addIP("1.2.3.4");
        sh1.addIP("1.2.3.5");
        sh1.addJID(BareJID.bareJIDInstanceNS((String)"a@b.c"));
        sh1.addJID(BareJID.bareJIDInstanceNS((String)"b@b.c"));
        sh1.addJID(BareJID.bareJIDInstanceNS((String)"c@b.c"));
        sh1.addJID(BareJID.bareJIDInstanceNS((String)"c@b.c"));
        sh1.addJID(BareJID.bareJIDInstanceNS((String)"c@b.c"));
        String[] parcel = sh1.encodeToStrings();
        BruteForceLockerBean.StatHolder sh2 = new BruteForceLockerBean.StatHolder();
        sh2.fillFromString(parcel);
        Assert.assertEquals((long)sh1.getIps().size(), (long)sh2.getIps().size());
        Assert.assertEquals((long)sh1.getJids().size(), (long)sh2.getJids().size());
        sh1.getIps().forEach((ip, count) -> Assert.assertEquals((Object)count, sh2.getIps().get(ip)));
        sh1.getJids().forEach((jid, count) -> Assert.assertEquals((Object)count, sh2.getJids().get(jid)));
    }

    @Test
    public void test3InvalidLoginsAndWait() {
        BruteForceLockerBean bean = new BruteForceLockerBean();
        bean.setMap(new HashMap());
        bean.clearAll();
        bean.addInvalidLogin(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 100000L);
        Assert.assertTrue((boolean)bean.isLoginAllowed(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 100001L));
        bean.addInvalidLogin(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 100002L);
        Assert.assertTrue((boolean)bean.isLoginAllowed(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 100003L));
        bean.addInvalidLogin(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 100004L);
        Assert.assertTrue((boolean)bean.isLoginAllowed(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 100005L));
        bean.addInvalidLogin(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 110006L);
        Assert.assertTrue((boolean)bean.isLoginAllowed(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 100007L));
    }

    @Test
    public void test4InvalidLogins() {
        BruteForceLockerBean bean = new BruteForceLockerBean();
        bean.setMap(new HashMap());
        bean.clearAll();
        Assert.assertTrue((boolean)bean.isLoginAllowed(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 99999L));
        bean.addInvalidLogin(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 100000L);
        Assert.assertTrue((boolean)bean.isLoginAllowed(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 100001L));
        bean.addInvalidLogin(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 100002L);
        Assert.assertTrue((boolean)bean.isLoginAllowed(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 100003L));
        bean.addInvalidLogin(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 100004L);
        Assert.assertTrue((boolean)bean.isLoginAllowed(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 100005L));
        bean.addInvalidLogin(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 100006L);
        Assert.assertFalse((boolean)bean.isLoginAllowed(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 100007L));
        Assert.assertTrue((boolean)bean.isLoginAllowed(null, "1.2.3.5", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 100007L));
        Assert.assertTrue((boolean)bean.isLoginAllowed(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"b@bc.d"), 100007L));
        Assert.assertTrue((boolean)bean.isLoginAllowed(null, "1.2.3.4", BareJID.bareJIDInstanceNS((String)"a@bc.d"), 110007L));
    }

    public class Event {
        private BruteForceLockerBean.StatHolder holder = new BruteForceLockerBean.StatHolder();
        private String name;

        public BruteForceLockerBean.StatHolder getHolder() {
            return this.holder;
        }

        public void setHolder(BruteForceLockerBean.StatHolder holder) {
            this.holder = holder;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

