/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import tigase.stats.StatisticsList;

public class AllHistoryCache {
    private StatisticsList[] buffer = null;
    private int start = 0;
    private int count = 0;

    public AllHistoryCache(int limit) {
        this.buffer = new StatisticsList[limit];
    }

    public synchronized void addItem(StatisticsList item) {
        int ix = (this.start + this.count) % this.buffer.length;
        this.buffer[ix] = item;
        if (this.count < this.buffer.length) {
            ++this.count;
        } else {
            ++this.start;
            this.start %= this.buffer.length;
        }
    }

    public synchronized StatisticsList[] getCurrentHistory() {
        StatisticsList[] result = new StatisticsList[this.count];
        for (int i = 0; i < this.count; ++i) {
            int ix = (this.start + i) % this.buffer.length;
            result[i] = this.buffer[ix];
        }
        return result;
    }
}

