/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppsession;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.osgi.ModulesManagerImpl;
import tigase.xmpp.ProcessorFactory;
import tigase.xmpp.XMPPImplIfc;
import tigase.xmpp.XMPPPacketFilterIfc;
import tigase.xmpp.XMPPPostprocessorIfc;
import tigase.xmpp.XMPPPreprocessorIfc;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPStopListenerIfc;

public abstract class SessionManagerConfig {
    public static final String defaultHandlerProcId = "default-handler";
    public static final String PLUGINS_CONCURRENCY_PROP_KEY = "plugins-concurrency";
    public static final String PLUGINS_CONF_PROP_KEY = "plugins-conf";
    public static final String PLUGINS_PROP_KEY = "plugins";
    public static final String sessionCloseProcId = "session-close";
    public static final String sessionOpenProcId = "session-open";
    protected static final String ADMIN_SCRIPTS_PROP_KEY = "admin-scripts-dir";
    protected static final String ADMIN_SCRIPTS_PROP_VAL = "scripts/admin/";
    protected static final String AUTO_CREATE_OFFLINE_USER_PROP_KEY = "offline-user-autocreate";
    protected static final String AUTO_CREATE_OFFLINE_USER_PROP_VAL = "false";
    protected static final String FORCE_DETAIL_STALE_CONNECTION_CHECK = "force-detail-stale-connection-check";
    protected static final String SKIP_PRIVACY_PROP_KEY = "skip-privacy";
    protected static final String SM_THREADS_POOL_CUSTOM_PROP_VAL = "custom";
    protected static final String SM_THREADS_POOL_PROP_KEY = "sm-threads-pool";
    protected static final String SM_THREADS_POOL_PROP_VAL = "default";
    protected static final String SM_THREADS_FACTOR_PROP_KEY = "sm-threads-factor";
    protected static final int SM_THREADS_FACTOR_PROP_VAL = 1;
    protected static final String AUTH_TIMEOUT_PROP_KEY = "auth-timeout";
    protected static final long AUTH_TIMEOUT_PROP_VAL = 120L;
    protected static final String ACTIVE_USER_TIMEFRAME_KEY = "active-user-timeframe";
    protected static final long ACTIVE_USER_TIMEFRAME_VAL = 300000L;
    protected static final String STALE_CONNECTION_CLOSER_QUEUE_SIZE_KEY = "stale-connection-closer-queue-size";
    private static final String[] PLUGINS_NO_REG_PROP_VAL = new String[]{"session-close", "session-open", "default-handler", "jabber:iq:auth", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-bind", "urn:ietf:params:xml:ns:xmpp-session", "jabber:iq:roster", "jabber:iq:privacy", "jabber:iq:version", "http://jabber.org/protocol/stats", "starttls", "vcard-temp", "http://jabber.org/protocol/commands", "jabber:iq:private", "urn:xmpp:ping", "presence-state", "presence-subscription", "disco", "domain-filter", "zlib", "amp", "message-carbons", "vcard-xep-0292", "urn:xmpp:time", "urn:xmpp:csi:0"};
    private static final String[] PLUGINS_TEST_PROP_VAL = new String[]{"session-close", "session-open", "default-handler", "jabber:iq:register", "jabber:iq:auth", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-bind", "urn:ietf:params:xml:ns:xmpp-session", "jabber:iq:roster", "jabber:iq:privacy", "jabber:iq:version", "http://jabber.org/protocol/stats", "starttls", "vcard-temp", "http://jabber.org/protocol/commands", "jabber:iq:private", "urn:xmpp:ping", "presence-state", "presence-subscription", "disco", "domain-filter", "zlib", "amp", "message-carbons", "vcard-xep-0292", "urn:xmpp:time", "urn:xmpp:csi:0"};
    private static final String[] PLUGINS_FULL_PROP_VAL = new String[]{"session-close", "session-open", "default-handler", "jabber:iq:register", "jabber:iq:auth", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-bind", "urn:ietf:params:xml:ns:xmpp-session", "jabber:iq:roster", "jabber:iq:privacy", "jabber:iq:version", "http://jabber.org/protocol/stats", "starttls", "vcard-temp", "http://jabber.org/protocol/commands", "jabber:iq:private", "urn:xmpp:ping", "presence-state", "presence-subscription", "disco", "domain-filter", "zlib", "amp", "message-carbons", "vcard-xep-0292", "urn:xmpp:time", "urn:xmpp:csi:0"};
    private static String[] TRUSTED_PROP_VAL = new String[]{"admin@localhost", "admin@hostname"};
    private static final boolean SKIP_PRIVACY_PROP_VAL = false;

    public static String[] getActivePlugins(Map<String, Object> props) {
        String[] allPlugins = (String[])props.get(PLUGINS_PROP_KEY);
        ArrayList<String> plugins = new ArrayList<String>();
        for (String plugin_id : allPlugins) {
            if (sessionCloseProcId.equals(plugin_id) || sessionOpenProcId.equals(plugin_id) || defaultHandlerProcId.equals(plugin_id)) {
                plugins.add(plugin_id);
                continue;
            }
            if (!ModulesManagerImpl.getInstance().hasPluginForId(plugin_id) && !ProcessorFactory.hasImplementation(plugin_id)) continue;
            plugins.add(plugin_id);
        }
        return plugins.toArray(new String[plugins.size()]);
    }

    public static void getDefaults(Map<String, Object> props, Map<String, Object> params) {
        props.put(ADMIN_SCRIPTS_PROP_KEY, ADMIN_SCRIPTS_PROP_VAL);
        boolean full_comps = params.get("--auth-db") == null || params.get("--auth-db").toString().equals("mysql") || params.get("--auth-db").toString().equals("pgsql") || params.get("--auth-db").toString().equals("derby") || params.get("--auth-db").toString().equals("sqlserver") || params.get("--auth-db").toString().equals("tigase.mongodb.MongoRepository") || params.get("--auth-db").toString().equals("tigase-auth");
        LinkedHashSet<String> plugins = new LinkedHashSet<String>(32);
        if (((Boolean)params.get("--test")).booleanValue()) {
            Collections.addAll(plugins, PLUGINS_TEST_PROP_VAL);
        } else if (full_comps) {
            Collections.addAll(plugins, PLUGINS_FULL_PROP_VAL);
        } else {
            Collections.addAll(plugins, PLUGINS_NO_REG_PROP_VAL);
        }
        String str_plugins = (String)params.get("--sm-plugins");
        String plugin_concurrency = "";
        if (str_plugins != null) {
            String[] conf_plugins;
            str_plugins = str_plugins.replaceAll("\\s+", "");
            block4: for (String plugin : conf_plugins = str_plugins.split(",")) {
                switch (plugin.charAt(0)) {
                    case '+': {
                        if (!SessionManagerConfig.addPlugin(plugins, plugin.substring(1))) continue block4;
                        plugin_concurrency = plugin_concurrency + plugin.substring(1) + ",";
                        continue block4;
                    }
                    case '-': {
                        plugins.remove(plugin.substring(1));
                        continue block4;
                    }
                    default: {
                        if (!SessionManagerConfig.addPlugin(plugins, plugin)) continue block4;
                        plugin_concurrency = plugin_concurrency + plugin + ",";
                    }
                }
            }
        }
        props.put(PLUGINS_PROP_KEY, plugins.toArray(new String[plugins.size()]));
        props.put(PLUGINS_CONCURRENCY_PROP_KEY, plugin_concurrency);
        String skip_privacy = (String)params.get("--skip-privacy");
        props.put(SKIP_PRIVACY_PROP_KEY, skip_privacy != null && skip_privacy.equals("true"));
        props.put(AUTO_CREATE_OFFLINE_USER_PROP_KEY, AUTO_CREATE_OFFLINE_USER_PROP_VAL);
        String sm_threads_pool = SM_THREADS_POOL_PROP_VAL;
        if (params.get("--sm-threads-pool") != null) {
            sm_threads_pool = (String)params.get("--sm-threads-pool");
        }
        props.put(SM_THREADS_POOL_PROP_KEY, sm_threads_pool);
    }

    public static XMPPPacketFilterIfc getPacketFilter(String plug_id) {
        XMPPImplIfc proc = SessionManagerConfig.getXMPPImplIfc(plug_id);
        if (proc == null) {
            return ProcessorFactory.getPacketFilter(plug_id);
        }
        if (proc instanceof XMPPPacketFilterIfc) {
            return (XMPPPacketFilterIfc)proc;
        }
        return null;
    }

    public static XMPPPostprocessorIfc getPostprocessor(String plug_id) {
        XMPPImplIfc proc = SessionManagerConfig.getXMPPImplIfc(plug_id);
        if (proc == null) {
            return ProcessorFactory.getPostprocessor(plug_id);
        }
        if (proc instanceof XMPPPostprocessorIfc) {
            return (XMPPPostprocessorIfc)proc;
        }
        return null;
    }

    public static XMPPPreprocessorIfc getPreprocessor(String plug_id) {
        XMPPImplIfc proc = SessionManagerConfig.getXMPPImplIfc(plug_id);
        if (proc == null) {
            return ProcessorFactory.getPreprocessor(plug_id);
        }
        if (proc instanceof XMPPPreprocessorIfc) {
            return (XMPPPreprocessorIfc)proc;
        }
        return null;
    }

    public static XMPPProcessorIfc getProcessor(String plug_id) {
        XMPPImplIfc proc = SessionManagerConfig.getXMPPImplIfc(plug_id);
        if (proc == null) {
            return ProcessorFactory.getProcessor(plug_id);
        }
        if (proc instanceof XMPPProcessorIfc) {
            return (XMPPProcessorIfc)proc;
        }
        return null;
    }

    public static XMPPStopListenerIfc getStopListener(String plug_id) {
        XMPPImplIfc proc = SessionManagerConfig.getXMPPImplIfc(plug_id);
        if (proc == null) {
            return ProcessorFactory.getStopListener(plug_id);
        }
        if (proc instanceof XMPPStopListenerIfc) {
            return (XMPPStopListenerIfc)proc;
        }
        return null;
    }

    private static boolean addPlugin(LinkedHashSet<String> plugins, String plugin) {
        String[] pla = plugin.split("=");
        plugins.add(pla[0]);
        return pla.length > 1;
    }

    private static XMPPImplIfc getXMPPImplIfc(String plug_id) {
        XMPPImplIfc proc = null;
        try {
            proc = ModulesManagerImpl.getInstance().getPlugin(plug_id);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(SessionManagerConfig.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(SessionManagerConfig.class.getName()).log(Level.SEVERE, null, ex);
        }
        return proc;
    }
}

