/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.ssender;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.server.ssender.SenderTask;
import tigase.server.ssender.StanzaHandler;
import tigase.util.TigaseStringprepException;
import tigase.xml.XMLUtils;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public class DrupalForumTask
extends SenderTask {
    private static final Logger log = Logger.getLogger("tigase.server.ssender.DrupalForumTask");
    private static final long SECOND = 1000L;
    private Connection conn = null;
    private PreparedStatement conn_valid_st = null;
    private long connectionValidateInterval = 60000L;
    private String db_conn = null;
    private long forumId = -1L;
    private PreparedStatement get_new_comments = null;
    private PreparedStatement get_new_topics = null;
    private StanzaHandler handler = null;
    private JID jid = null;
    protected long lastCommentsCheck = -1L;
    private long lastConnectionValidated = 0L;
    protected long lastTopicsCheck = -1L;

    @Override
    public boolean cancel() {
        boolean result = super.cancel();
        try {
            this.conn_valid_st.close();
            this.get_new_topics.close();
            this.get_new_comments.close();
            this.conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    public String getInitString() {
        return this.db_conn;
    }

    @Override
    public void init(StanzaHandler handler, String initString) throws IOException {
        this.handler = handler;
        this.db_conn = initString;
        try {
            this.findExtraParams(this.db_conn);
        }
        catch (TigaseStringprepException ex) {
            throw new IOException("Destination address problem, stringprep processing failed", ex);
        }
        this.lastTopicsCheck = System.currentTimeMillis() / 1000L;
        this.lastCommentsCheck = System.currentTimeMillis() / 1000L;
        try {
            this.initRepo();
        }
        catch (SQLException e) {
            throw new IOException("Problem initializing SenderTask.", e);
        }
    }

    @Override
    public void run() {
        Queue<Packet> results = this.getNewPackets();
        this.handler.handleStanzas(results);
    }

    protected Queue<Packet> getNewPackets() {
        ArrayDeque<Packet> results = new ArrayDeque<Packet>();
        this.newTopics(results);
        this.newComments(results);
        return results;
    }

    private boolean checkConnection() throws SQLException {
        try {
            long tmp = System.currentTimeMillis();
            if (tmp - this.lastConnectionValidated >= this.connectionValidateInterval) {
                this.conn_valid_st.executeQuery();
                this.lastConnectionValidated = tmp;
            }
        }
        catch (Exception e) {
            this.initRepo();
        }
        return true;
    }

    private void findExtraParams(String db_str) throws TigaseStringprepException {
        String[] params;
        for (String par : params = db_str.split("&")) {
            if (par.startsWith("jid=")) {
                this.jid = JID.jidInstance(par.substring("jid=".length(), par.length()));
            }
            if (!par.startsWith("forum")) continue;
            try {
                this.forumId = Long.parseLong(par.substring("forum=".length(), par.length()));
            }
            catch (NumberFormatException e) {
                this.forumId = -1L;
                log.warning("Forum ID number is incorrect: " + par.substring("forum=".length(), par.length()));
            }
        }
    }

    private void initRepo() throws SQLException {
        this.conn = DriverManager.getConnection(this.db_conn);
        this.conn.setAutoCommit(true);
        String query = "select 1;";
        this.conn_valid_st = this.conn.prepareStatement(query);
        query = "select users.name as name, node_revisions.title as title, node_revisions.body as body from forum, node_revisions, users where (status = 1) and (node_revisions.timestamp > ?) and forum.tid = ? and users.uid = node_revisions.uid and node_revisions.vid = forum.vid;";
        this.get_new_topics = this.conn.prepareStatement(query);
        query = "select name, thread, subject, comment from comments where (status = 0) and (timestamp > ?) and (nid in (select nid from forum where tid = ?));";
        this.get_new_comments = this.conn.prepareStatement(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newComments(Queue<Packet> results) {
        ResultSet rs = null;
        try {
            this.checkConnection();
            log.info("New comment check, timestamp = " + this.lastCommentsCheck);
            this.get_new_comments.setLong(1, this.lastCommentsCheck);
            this.lastCommentsCheck = System.currentTimeMillis() / 1000L;
            this.get_new_comments.setLong(2, this.forumId);
            rs = this.get_new_comments.executeQuery();
            while (rs.next()) {
                String name = rs.getString("name");
                String thread = rs.getString("thread");
                String subject = rs.getString("subject");
                String comment = rs.getString("comment");
                Packet msg = Message.getMessage(this.getName(), this.jid, StanzaType.normal, "New comment by " + name + ":\n\n" + XMLUtils.escape(comment), XMLUtils.escape(subject), thread, null);
                log.fine("Sending new comment: " + msg.toString());
                results.offer(msg);
            }
            this.release(rs);
            rs = null;
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Error retrieving stanzas from database: ", e);
        }
        finally {
            this.release(rs);
            rs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newTopics(Queue<Packet> results) {
        ResultSet rs = null;
        try {
            this.checkConnection();
            this.get_new_topics.setLong(1, this.lastTopicsCheck);
            this.lastTopicsCheck = System.currentTimeMillis() / 1000L;
            this.get_new_topics.setLong(2, this.forumId);
            rs = this.get_new_topics.executeQuery();
            while (rs.next()) {
                String name = rs.getString("name");
                String title = rs.getString("title");
                String body = rs.getString("body");
                Packet msg = Message.getMessage(this.getName(), this.jid, StanzaType.normal, "New post by " + name + ":\n\n" + XMLUtils.escape(body), XMLUtils.escape(title), null, null);
                log.fine("Sending new topic: " + msg.toString());
                results.offer(msg);
            }
            this.release(rs);
            rs = null;
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Error retrieving stanzas from database: ", e);
        }
        finally {
            this.release(rs);
            rs = null;
        }
    }

    private void release(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

