/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.sreceiver;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.TigaseDBException;
import tigase.db.UserExistsException;
import tigase.db.UserRepository;
import tigase.server.Packet;
import tigase.server.sreceiver.AbstractReceiverTask;
import tigase.server.sreceiver.RosterItem;
import tigase.server.sreceiver.TaskCommons;
import tigase.util.TigaseStringprepException;
import tigase.xmpp.JID;

public abstract class RepoRosterTask
extends AbstractReceiverTask {
    private static Logger log = Logger.getLogger("tigase.server.sreceiver.RepoRosterTask");
    private static final String roster_node = "/roster";
    private static final String subscribed_key = "subscribed";
    private static final String owner_key = "owner";
    private static final String admin_key = "admin";
    private static final String moderation_accepted_key = "moderation-accepted";
    private boolean loaded = false;
    private UserRepository repository = null;

    @Override
    public RosterItem addToRoster(JID jid) {
        RosterItem ri = super.addToRoster(jid);
        this.saveToRepository(ri);
        return ri;
    }

    @Override
    public void destroy(Queue<Packet> results) {
        super.destroy(results);
        try {
            this.repository.removeUser(this.getJID().getBareJID());
        }
        catch (TigaseDBException e) {
            log.log(Level.SEVERE, "Problem removing task data from repository", e);
        }
    }

    public void loadRoster() throws TigaseDBException {
        String[] roster = this.repository.getSubnodes(this.getJID().getBareJID(), roster_node);
        if (roster != null) {
            for (String jid : roster) {
                try {
                    JID rjid = JID.jidInstance(jid);
                    log.fine(this.getJID() + ":  loadin from repository: " + rjid);
                    this.addToRoster(this.loadFromRepository(rjid));
                }
                catch (TigaseStringprepException ex) {
                    Logger.getLogger(RepoRosterTask.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    @Override
    public RosterItem removeFromRoster(JID jid) {
        RosterItem ri = super.removeFromRoster(jid);
        if (ri != null) {
            this.removeFromRepository(ri);
        }
        return ri;
    }

    @Override
    public void setParams(Map<String, Object> map) {
        if (map.get("user-repository") != null) {
            this.repository = (UserRepository)map.get("user-repository");
        }
        if (this.repository != null && !this.loaded) {
            try {
                try {
                    this.repository.addUser(this.getJID().getBareJID());
                }
                catch (UserExistsException userExistsException) {
                    // empty catch block
                }
                this.loaded = true;
                this.loadRoster();
            }
            catch (TigaseDBException e) {
                log.log(Level.SEVERE, "Problem loading roster from repository", e);
            }
        }
        super.setParams(map);
    }

    @Override
    public void setRosterItemAdmin(RosterItem ri, boolean admin) {
        super.setRosterItemAdmin(ri, admin);
        this.saveToRepository(ri);
    }

    @Override
    public void setRosterItemModerationAccepted(RosterItem ri, boolean accepted) {
        super.setRosterItemModerationAccepted(ri, accepted);
        this.saveToRepository(ri);
    }

    @Override
    public void setRosterItemOwner(RosterItem ri, boolean owner) {
        super.setRosterItemOwner(ri, owner);
        this.saveToRepository(ri);
    }

    @Override
    public void setRosterItemSubscribed(RosterItem ri, boolean subscribed) {
        super.setRosterItemSubscribed(ri, subscribed);
        log.fine(this.getJID() + ": Updating subscription for " + ri.getJid() + " to " + subscribed);
        this.saveToRepository(ri);
    }

    private RosterItem loadFromRepository(JID jid) {
        log.info(this.getJID() + ": Loading roster item for: " + jid);
        String repo_node = "/roster/" + jid;
        RosterItem ri = new RosterItem(jid);
        try {
            String tmp = this.repository.getData(this.getJID().getBareJID(), repo_node, subscribed_key);
            log.info(this.getJID() + ": " + jid + ": subscribed = " + tmp);
            ri.setSubscribed(TaskCommons.parseBool(tmp));
            tmp = this.repository.getData(this.getJID().getBareJID(), repo_node, owner_key);
            ri.setOwner(TaskCommons.parseBool(tmp));
            tmp = this.repository.getData(this.getJID().getBareJID(), repo_node, admin_key);
            ri.setAdmin(TaskCommons.parseBool(tmp));
            tmp = this.repository.getData(this.getJID().getBareJID(), repo_node, moderation_accepted_key);
            ri.setModerationAccepted(TaskCommons.parseBool(tmp));
        }
        catch (TigaseDBException e) {
            log.log(Level.SEVERE, "Problem loading roster data for: " + jid, e);
        }
        return ri;
    }

    private void removeFromRepository(RosterItem ri) {
        String repo_node = "/roster/" + ri.getJid();
        try {
            this.repository.removeSubnode(this.getJID().getBareJID(), repo_node);
        }
        catch (TigaseDBException e) {
            log.log(Level.SEVERE, "Problem removing from roster data for: " + ri.getJid(), e);
        }
    }

    private void saveToRepository(RosterItem ri) {
        log.info(this.getJID() + ": Saving roster item for: " + ri.getJid());
        String repo_node = "/roster/" + ri.getJid();
        try {
            String tmp = Boolean.valueOf(ri.isSubscribed()).toString();
            log.info(this.getJID() + ": " + ri.getJid() + ": subscribed = " + tmp);
            this.repository.setData(this.getJID().getBareJID(), repo_node, subscribed_key, tmp);
            this.repository.setData(this.getJID().getBareJID(), repo_node, owner_key, Boolean.valueOf(ri.isOwner()).toString());
            this.repository.setData(this.getJID().getBareJID(), repo_node, admin_key, Boolean.valueOf(ri.isAdmin()).toString());
            this.repository.setData(this.getJID().getBareJID(), repo_node, moderation_accepted_key, Boolean.valueOf(ri.isModerationAccepted()).toString());
        }
        catch (TigaseDBException e) {
            log.log(Level.SEVERE, "Problem saving roster data for: JID = " + this.getJID() + ", node = " + repo_node + ", RosterItem = " + ri.getJid(), e);
        }
    }
}

