/*
 * Decompiled with CFR 0.152.
 */
package tigase.component.modules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.Context;
import tigase.component.exceptions.ComponentException;
import tigase.component.modules.ContextAware;
import tigase.component.modules.InitializingModule;
import tigase.component.modules.Module;
import tigase.component.modules.ModuleProvider;
import tigase.criteria.Criteria;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;

public class ModulesManager
implements ModuleProvider {
    private Context context;
    private boolean dirty = true;
    private final Set<Module> initializationRequired = Collections.newSetFromMap(new ConcurrentHashMap());
    private Logger log = Logger.getLogger(this.getClass().getName());
    private final ArrayList<Module> modules = new ArrayList();
    private final HashMap<String, Module> modulesById = new HashMap();

    public ModulesManager(Context context) {
        this.context = context;
    }

    @Override
    public Set<String> getAvailableFeatures() {
        HashSet<String> features = new HashSet<String>();
        for (Module m : this.modules) {
            String[] fs = m.getFeatures();
            if (fs == null) continue;
            for (String string : fs) {
                features.add(string);
            }
        }
        return features;
    }

    @Override
    public <T extends Module> T getModule(String id) {
        this.initIfRequired();
        return (T)this.modulesById.get(id);
    }

    @Override
    public List<Module> getModules() {
        return Collections.unmodifiableList(this.modules);
    }

    @Override
    public Collection<String> getModulesId() {
        return Collections.unmodifiableCollection(this.modulesById.keySet());
    }

    public void initIfRequired() {
        Iterator<Module> it = this.initializationRequired.iterator();
        while (it.hasNext()) {
            Module module = it.next();
            it.remove();
            if (!(module instanceof InitializingModule)) continue;
            ((InitializingModule)((Object)module)).afterRegistration();
        }
        this.dirty = false;
    }

    public boolean isRegistered(Module module) {
        return this.modules.contains(module);
    }

    public boolean isRegistered(String id) {
        return this.modulesById.containsKey(id);
    }

    public boolean process(Packet packet) throws ComponentException, TigaseStringprepException {
        if (this.dirty) {
            this.initIfRequired();
        }
        boolean handled = false;
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finest("Processing packet: " + packet.toString());
        }
        for (Module module : this.modules) {
            Criteria criteria = module.getModuleCriteria();
            if (criteria == null || !criteria.match(packet.getElement())) continue;
            handled = true;
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Handled by module " + module.getClass());
            }
            module.process(packet);
            if (!this.log.isLoggable(Level.FINEST)) break;
            this.log.finest("Finished " + module.getClass());
            break;
        }
        return handled;
    }

    public synchronized <T extends Module> T register(String id, T module) {
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("Register Component module " + id + ": " + module.getClass().getCanonicalName());
        }
        this.dirty = true;
        if (this.modulesById.containsKey(id)) {
            this.log.config("Module " + id + " already registered. Skipped.");
            return null;
        }
        if (module instanceof ContextAware) {
            ((ContextAware)((Object)module)).setContext(this.context);
        }
        if (module instanceof InitializingModule) {
            ((InitializingModule)((Object)module)).beforeRegister();
        }
        this.modules.add(module);
        this.modulesById.put(id, module);
        this.initializationRequired.add(module);
        return module;
    }

    public synchronized void reset() {
        this.modules.clear();
        this.modulesById.clear();
        this.initializationRequired.clear();
    }

    public synchronized void unregister(Module module) {
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("Unregister Component module: " + module.getClass().getCanonicalName());
        }
        this.modules.remove(module);
        Iterator<Map.Entry<String, Module>> it = this.modulesById.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Module> e = it.next();
            if (!e.getValue().equals(module)) continue;
            it.remove();
        }
        this.initializationRequired.remove(module);
        if (module instanceof InitializingModule) {
            ((InitializingModule)((Object)module)).unregisterModule();
        }
    }

    public void unregister(String id) {
        Object m = this.getModule(id);
        this.unregister((Module)m);
    }
}

