/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.form.Field;
import tigase.form.Form;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.JID;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.XMPPProcessorAbstract;
import tigase.xmpp.XMPPResourceConnection;

public class RemoteRosterManagement
extends XMPPProcessorAbstract {
    private static final String[][] ELEMENT_PATHS = new String[][]{{"iq", "query"}, {"message", "x"}};
    private static final String ID = "remote-roster-management";
    private static final Logger log = Logger.getLogger("eu.hilow.xtigase.server.xmpp.RemoteRosterManagement");
    private static final String XMLNS = "http://spectrum.im/protocol/remote-roster";
    private static final String[] XMLNSS = new String[]{"http://spectrum.im/protocol/remote-roster", "jabber:x:data"};

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void processFromUserToServerPacket(JID connectionId, Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        if (packet.getElemName() == "message") {
            try {
                this.processMessageFormResponse(packet, session, repo, results);
            }
            catch (NotAuthorizedException ex) {
                results.offer(Authorization.FORBIDDEN.getResponseMessage(packet, null, false));
            }
            catch (TigaseDBException ex) {
                results.offer(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, null, true));
            }
        } else {
            results.offer(packet);
        }
    }

    @Override
    public void processServerSessionPacket(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
    }

    @Override
    public void processToUserPacket(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        if (packet.getElemName() == "iq") {
            this.processIq(packet, session, repo, results, settings);
        } else {
            super.processToUserPacket(packet, session, repo, results, settings);
        }
    }

    private void processIq(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        Element query = packet.getElement().getChild("query", XMLNS);
        if (query == null) {
            super.processToUserPacket(packet, session, repo, results, settings);
            return;
        }
        switch (packet.getType()) {
            case set: {
                if ("request".equals(query.getAttributeStaticStr("type"))) {
                    JID from = JID.jidInstanceNS(packet.getStanzaTo().getDomain());
                    Element msg = new Element("message");
                    msg.setAttribute("from", from.toString());
                    msg.setAttribute("to", packet.getStanzaTo().toString());
                    Form form = new Form("from", "Roster change permission", packet.getStanzaFrom().getBareJID().toString() + " wants to edit your roster with following reason: " + query.getAttributeStaticStr("reason") + ". Do you want to allow it?");
                    form.addField(Field.fieldHidden("FORM_TYPE", XMLNS));
                    form.addField(Field.fieldHidden("jid", packet.getStanzaFrom().getBareJID().toString()));
                    form.addField(Field.fieldBoolean("answer", true, "Allow roster edit"));
                    msg.addChildren(Collections.singletonList(form.getElement()));
                    Packet resp = Packet.packetInstance(msg, from, packet.getStanzaTo());
                    results.offer(resp);
                    break;
                }
                results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Unknown request type", false));
                break;
            }
            default: {
                results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Bad request", true));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMessageFormResponse(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) throws NotAuthorizedException, TigaseDBException {
        Element x = packet.getElement().getChild("x");
        if (x != null) {
            Form form = new Form(x);
            if (!XMLNS.equals(form.getAsString("FORM_TYPE")) && !session.isLocalDomain(packet.getStanzaTo().toString(), false)) {
                results.offer(packet);
            }
            JID jid = JID.jidInstanceNS(form.get("jid").getValue());
            Boolean answer = false;
            String answerStr = form.get("answer").getValue();
            if ("true".equals(answerStr) || "1".equals(answerStr)) {
                answer = true;
            }
            XMPPResourceConnection xMPPResourceConnection = session;
            synchronized (xMPPResourceConnection) {
                Set<JID> allowed = RemoteRosterManagement.getAllowed(session);
                if (answer.booleanValue()) {
                    allowed.add(jid);
                } else {
                    allowed.remove(jid);
                }
                RemoteRosterManagement.setAllowed(session, allowed);
            }
            Element iq = new Element("iq");
            iq.setAttribute("from", packet.getStanzaFrom().getBareJID().toString());
            iq.setAttribute("to", jid.toString());
            Element query = new Element("query");
            query.setAttribute("xmlns", XMLNS);
            query.setAttribute("type", answer != false ? "allowed" : "rejected");
            iq.addChildren(Collections.singletonList(query));
            results.offer(Packet.packetInstance(iq, packet.getStanzaFrom().copyWithoutResource(), jid));
        } else {
            results.offer(packet);
        }
    }

    @Override
    public String[][] supElementNamePaths() {
        return ELEMENT_PATHS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<JID> getAllowed(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        XMPPResourceConnection xMPPResourceConnection = session;
        synchronized (xMPPResourceConnection) {
            HashSet<JID> allowed = (HashSet<JID>)session.getCommonSessionData("remote-roster-allowed");
            if (allowed == null) {
                String data = session.getData(ID, "allowed", null);
                allowed = new HashSet<JID>();
                if (data != null) {
                    if (data.contains("/")) {
                        String[] jidsStr;
                        for (String jidStr : jidsStr = data.split("/")) {
                            if (jidStr.length() <= 0) continue;
                            allowed.add(JID.jidInstanceNS(jidStr));
                        }
                    } else {
                        allowed.add(JID.jidInstanceNS(data));
                    }
                }
                session.putCommonSessionData("remote-roster-allowed", allowed);
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "read list of jids allowed to modify roster = {0}", allowed);
                }
            }
            return allowed;
        }
    }

    private static void setAllowed(XMPPResourceConnection session, Set<JID> allowed) throws NotAuthorizedException, TigaseDBException {
        StringBuilder buf = new StringBuilder(1024);
        session.putCommonSessionData("remote-roster-allowed", allowed);
        boolean first = true;
        for (JID jid : allowed) {
            if (!first) {
                buf.append("/");
            } else {
                first = false;
            }
            buf.append(jid.toString());
        }
        session.setData(ID, "allowed", buf.toString());
    }

    public static boolean isRemoteAllowed(JID jid, XMPPResourceConnection session) {
        try {
            if (session == null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "no session to check if {0} is allowed", jid.toString());
                }
                return false;
            }
            Set<JID> allowed = RemoteRosterManagement.getAllowed(session);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "checking if sender jid = {0} is in allowed set = {1}", new Object[]{jid, allowed});
            }
            return allowed.contains(jid);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static void updateBuddyChange(XMPPResourceConnection session, Element item, Element update, Queue<Packet> results) throws NotAuthorizedException, TigaseDBException {
        JID jid = JID.jidInstanceNS(item.getAttributeStaticStr("jid"));
        if (jid.getLocalpart() == null) {
            return;
        }
        if (RemoteRosterManagement.isRemoteAllowed(jid = JID.jidInstanceNS(jid.getDomain()), session)) {
            Element iq = update.clone();
            iq.setAttribute("from", session.getBareJID().toString());
            iq.setAttribute("to", jid.getDomain());
            iq.setAttribute("id", "rst" + session.nextStanzaId());
            results.offer(Packet.packetInstance(iq, JID.jidInstance(session.getBareJID()), jid));
        }
    }
}

