/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp;

import java.util.Objects;
import tigase.util.TigaseStringprepException;
import tigase.xmpp.BareJID;

public final class JID
implements Comparable<JID> {
    private final BareJID bareJid;
    private final String resource;
    private final String to_string;
    private final int hashcode;

    private JID(BareJID bareJid, String resource) {
        this.bareJid = bareJid;
        this.resource = resource;
        this.to_string = BareJID.toString(bareJid, resource);
        this.hashcode = Objects.hash(bareJid, resource);
    }

    public static JID jidInstance(BareJID bareJid, String p_resource) throws TigaseStringprepException {
        String f_resource;
        String string = f_resource = p_resource == null ? null : BareJID.stringPrep.resourceprep(p_resource);
        if (bareJid == null) {
            throw new TigaseStringprepException("BareJID can't be null");
        }
        return new JID(bareJid, f_resource);
    }

    public static JID jidInstance(BareJID bareJid) {
        return bareJid != null ? new JID(bareJid, null) : null;
    }

    public static JID jidInstance(String jid) throws TigaseStringprepException {
        String[] parsedJid = BareJID.parseJID(jid);
        return JID.jidInstance(parsedJid[0], parsedJid[1], parsedJid[2]);
    }

    public static JID jidInstance(String localpart, String domain) throws TigaseStringprepException {
        return JID.jidInstance(BareJID.bareJIDInstance(localpart, domain));
    }

    public static JID jidInstance(String localpart, String domain, String resource) throws TigaseStringprepException {
        return JID.jidInstance(BareJID.bareJIDInstance(localpart, domain), resource);
    }

    public static JID jidInstanceNS(BareJID bareJid) {
        return bareJid != null ? new JID(bareJid, null) : null;
    }

    public static JID jidInstanceNS(BareJID bareJid, String p_resource) {
        return bareJid != null ? new JID(bareJid, p_resource) : null;
    }

    public static JID jidInstanceNS(String jid) {
        if (jid == null) {
            return null;
        }
        String[] parsedJid = BareJID.parseJID(jid);
        return JID.jidInstanceNS(parsedJid[0], parsedJid[1], parsedJid[2]);
    }

    public static JID jidInstanceNS(String localpart, String domain, String resource) {
        return JID.jidInstanceNS(BareJID.bareJIDInstanceNS(localpart, domain), resource);
    }

    public static JID jidInstanceNS(String localpart, String domain) {
        return JID.jidInstanceNS(BareJID.bareJIDInstanceNS(localpart, domain));
    }

    @Override
    public int compareTo(JID o) {
        return this.to_string.compareTo(o.to_string);
    }

    public JID copyWithResource(String resource) throws TigaseStringprepException {
        return JID.jidInstance(this.bareJid, resource);
    }

    public JID copyWithResourceNS(String resource) {
        return JID.jidInstanceNS(this.bareJid, resource);
    }

    public JID copyWithoutResource() {
        return new JID(this.bareJid, null);
    }

    public boolean equals(Object b) {
        boolean result = false;
        if (b instanceof JID) {
            JID jid = (JID)b;
            result = this.bareJid.equals(jid.bareJid) && (this.resource == jid.resource || this.resource != null && this.resource.equals(jid.resource));
        }
        return result;
    }

    public BareJID getBareJID() {
        return this.bareJid;
    }

    public String getDomain() {
        return this.bareJid.getDomain();
    }

    public String getLocalpart() {
        return this.bareJid.getLocalpart();
    }

    public String getResource() {
        return this.resource;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public String toString() {
        return this.to_string;
    }
}

