/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.stats.StatisticsArchivizerIfc;
import tigase.stats.StatisticsProvider;

public class CounterDataFileLogger
implements StatisticsArchivizerIfc {
    private static final Logger log = Logger.getLogger(CounterDataFileLogger.class.getName());
    private static final String DIRECTORY_KEY = "stats-directory";
    private static final String FILENAME_KEY = "stats-filename";
    private static final String UNIXTIME_KEY = "stats-unixtime";
    private static final String DATETIME_KEY = "stats-datetime";
    private static final String DATETIME_FORMAT_KEY = "stats-datetime-format";
    private static final String STATISTICS_LEVE_KEY = "stats-level";
    private static String directory = "logs/stats";
    private static String filename = "stats";
    private static boolean includeUnixTime = true;
    private static boolean includeDateTime = true;
    private static String dateTimeFormat = "yyyy-MM-dd_HH:mm:ss";
    private static Level statsLevel = Level.ALL;
    private static SimpleDateFormat sdf;

    @Override
    public void execute(StatisticsProvider sp) {
        Date currTime = new Date();
        String path = directory + "/" + filename + (includeUnixTime ? "_" + currTime.getTime() : "") + (includeDateTime ? "_" + sdf.format(currTime) : "") + ".txt";
        log.log(Level.FINEST, "Dumping server statistics to: {0}", path);
        Path p = Paths.get(path, new String[0]);
        Map<String, String> stats = sp.getAllStats(statsLevel.intValue());
        try (BufferedWriter writer = Files.newBufferedWriter(p, StandardCharsets.UTF_8, new OpenOption[0]);){
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : stats.entrySet()) {
                sb.append(entry.getKey()).append("\t");
                sb.append(entry.getValue()).append("\n");
            }
            sb.append("Statistics time: ").append(sdf.format(currTime)).append("\n");
            sb.append("Statistics time (linux): ").append(currTime.getTime()).append("\n");
            writer.write(sb.toString());
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, "Error dumping server statistics to file", ex);
        }
    }

    @Override
    public void init(Map<String, Object> archivizerConf) {
        if (null != archivizerConf.get(DIRECTORY_KEY)) {
            directory = String.valueOf(archivizerConf.get(DIRECTORY_KEY));
        }
        new File(directory).mkdirs();
        log.log(Level.CONFIG, "Setting CounterDataFileLogger directory to: {0}", directory);
        if (null != archivizerConf.get(FILENAME_KEY)) {
            filename = (String)archivizerConf.get(FILENAME_KEY);
        }
        log.log(Level.CONFIG, "Setting CounterDataFileLogger filename to: {0}", filename);
        if (null != archivizerConf.get(UNIXTIME_KEY)) {
            includeUnixTime = Boolean.valueOf((String)archivizerConf.get(UNIXTIME_KEY));
        }
        log.log(Level.CONFIG, "Setting CounterDataFileLogger includeUnixTime to: {0}", includeUnixTime);
        if (null != archivizerConf.get(DATETIME_KEY)) {
            includeDateTime = Boolean.valueOf((String)archivizerConf.get(DATETIME_KEY));
        }
        log.log(Level.CONFIG, "Setting CounterDataFileLogger includeDateTime to: {0}", includeDateTime);
        if (null != archivizerConf.get(DATETIME_FORMAT_KEY)) {
            dateTimeFormat = (String)archivizerConf.get(DATETIME_FORMAT_KEY);
        }
        log.log(Level.CONFIG, "Setting CounterDataFileLogger dateTimeFormat to: {0}", dateTimeFormat);
        sdf = new SimpleDateFormat(dateTimeFormat);
        if (null != archivizerConf.get(STATISTICS_LEVE_KEY)) {
            statsLevel = Level.parse((String)archivizerConf.get(STATISTICS_LEVE_KEY));
        }
        log.log(Level.CONFIG, "Setting CounterDataFileLogger statsLevel to: {0}", statsLevel);
    }

    @Override
    public void release() {
    }
}

