/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.db.RepositoryFactory;
import tigase.server.XMPPServer;
import tigase.stats.StatisticsArchivizerIfc;
import tigase.stats.StatisticsProvider;
import tigase.sys.TigaseRuntime;

public class CounterDataArchivizer
implements StatisticsArchivizerIfc {
    public static final String DB_URL_PROP_KEY = "db-url";
    public static final String KEY_FIELD_PROP_KEY = "key-field";
    public static final String TABLE_NAME_PROP_KEY = "table-name";
    public static final String VAL_FIELD_PROP_KEY = "val-field";
    private static final String CPU_USAGE_TEXT = "Usage CPU [%]: ";
    private static final String DEF_KEY_FIELD_NAME = "counter_name";
    private static final String DEF_TABLE_NAME = "counter_data";
    private static final String DEF_VALUE_FIELD_NAME = "counter_value";
    private static final String MEM_USAGE_TEXT = "Usage RAM [%]: ";
    private static final Logger log = Logger.getLogger(CounterDataArchivizer.class.getName());
    private static final String SERVER_CONNECTIONS_TEXT = "Connections s2s: ";
    private static final String UPTIME_TEXT = "Uptime: ";
    private static final String USER_CONNECTIONS_TEXT = "Connections c2s: ";
    private static final String USER_REGISTERED_TEXT = "Registered user: ";
    private static final String VERSION_TEXT = "Version: ";
    private static final String VHOSTS_TEXT = "VHosts: ";
    private String create_table_query = null;
    private DataRepository data_repo = null;
    private String init_entry_query = null;
    private String tableName = "counter_data";
    private String keyField = "counter_name";
    private String update_entry_query = null;
    private String valueField = "counter_value";

    @Override
    public void execute(StatisticsProvider sp) {
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(2);
        this.initData(CPU_USAGE_TEXT, format.format(sp.getCPUUsage()));
        this.initData(MEM_USAGE_TEXT, format.format(sp.getHeapMemUsage()));
        format = NumberFormat.getIntegerInstance();
        this.initData(USER_REGISTERED_TEXT, format.format(sp.getRegistered()));
        this.initData(USER_CONNECTIONS_TEXT, format.format(sp.getConnectionsNumber()));
        this.initData(SERVER_CONNECTIONS_TEXT, format.format(sp.getServerConnections()));
        this.initData(UPTIME_TEXT, TigaseRuntime.getTigaseRuntime().getUptimeString());
        this.initData(VHOSTS_TEXT, format.format(sp.getStats("vhost-man", "Number of VHosts", 0)));
    }

    @Override
    public void init(Map<String, Object> conf) {
        String prop = (String)conf.get(TABLE_NAME_PROP_KEY);
        if (prop != null) {
            this.tableName = prop;
        }
        if ((prop = (String)conf.get(KEY_FIELD_PROP_KEY)) != null) {
            this.keyField = prop;
        }
        if ((prop = (String)conf.get(VAL_FIELD_PROP_KEY)) != null) {
            this.valueField = prop;
        }
        log.log(Level.SEVERE, "Initialize stats archive, table: {0} ", this.tableName);
        this.init_entry_query = "insert into " + this.tableName + " (" + this.keyField + ", " + this.valueField + ")  (select ?, ? from " + this.tableName + " where " + this.keyField + " = ? HAVING count(*)=0)";
        this.update_entry_query = "update " + this.tableName + " set " + this.valueField + " = ? where " + this.keyField + " = ?";
        this.create_table_query = "CREATE TABLE " + this.tableName + " ( " + this.keyField + " varchar(255) NOT NULL DEFAULT '0', " + this.valueField + " varchar(255) NOT NULL DEFAULT '0',  PRIMARY KEY ( " + this.keyField + " ));";
        try {
            this.initRepository((String)conf.get(DB_URL_PROP_KEY), null);
            this.initData(VERSION_TEXT, XMPPServer.getImplementationVersion());
            this.initData(CPU_USAGE_TEXT, "0");
            this.initData(MEM_USAGE_TEXT, "0");
            this.initData(USER_CONNECTIONS_TEXT, "0");
            this.initData(SERVER_CONNECTIONS_TEXT, "0");
            this.initData(VHOSTS_TEXT, "0");
            this.initData(UPTIME_TEXT, TigaseRuntime.getTigaseRuntime().getUptimeString());
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Cannot initialize connection to database: ", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initData(String key, String value) {
        try {
            PreparedStatement updateEntry = this.data_repo.getPreparedStatement(null, this.update_entry_query);
            PreparedStatement initEntry = this.data_repo.getPreparedStatement(null, this.init_entry_query);
            PreparedStatement preparedStatement = updateEntry;
            synchronized (preparedStatement) {
                updateEntry.setString(1, value);
                updateEntry.setString(2, key);
                updateEntry.executeUpdate();
            }
            preparedStatement = initEntry;
            synchronized (preparedStatement) {
                initEntry.setString(1, key);
                initEntry.setString(2, value);
                initEntry.setString(3, key);
                initEntry.executeUpdate();
            }
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Problem adding new entry to DB: ", e);
        }
    }

    public void initRepository(String conn_str, Map<String, String> params) throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException, DBInitException {
        this.data_repo = RepositoryFactory.getDataRepository(null, conn_str, params);
        this.checkDB();
        this.data_repo.initPreparedStatement(this.init_entry_query, this.init_entry_query);
        this.data_repo.initPreparedStatement(this.update_entry_query, this.update_entry_query);
    }

    @Override
    public void release() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateData(String key, String value) {
        try {
            PreparedStatement updateEntry;
            PreparedStatement preparedStatement = updateEntry = this.data_repo.getPreparedStatement(null, this.update_entry_query);
            synchronized (preparedStatement) {
                updateEntry.setString(1, value);
                updateEntry.setString(2, key);
                updateEntry.executeUpdate();
            }
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Problem adding new entry to DB: ", e);
        }
    }

    private void checkDB() throws SQLException {
        this.data_repo.checkTable(this.tableName, this.create_table_query);
    }
}

