/*
 * Decompiled with CFR 0.152.
 */
package tigase.disteventbus.component;

import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import tigase.disteventbus.EventHandler;
import tigase.disteventbus.component.EventBusContext;
import tigase.xml.Element;

public class ListenerScript
implements EventHandler {
    private CompiledScript compiledScript;
    private EventBusContext context;
    private ScriptEngine engine;
    private String eventName;
    private String eventXMLNS;
    private String scriptContent;

    @Override
    public void onEvent(String name, String xmlns, Element event) {
        try {
            Bindings bindings = this.engine.createBindings();
            bindings.put("event", (Object)event);
            bindings.put("eventName", (Object)name);
            bindings.put("eventXMLNS", (Object)xmlns);
            bindings.put("context", (Object)this.context);
            if (this.compiledScript != null) {
                this.compiledScript.eval(bindings);
            } else {
                this.engine.eval(this.scriptContent, bindings);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void run(EventBusContext context, ScriptEngineManager scriptEngineManager, String scriptName, String scriptExtension, String scriptContent, String eventName, String eventXMLNS) throws ScriptException {
        this.context = context;
        this.eventName = eventName;
        this.eventXMLNS = eventXMLNS;
        this.engine = scriptEngineManager.getEngineByExtension(scriptExtension);
        this.scriptContent = scriptContent;
        this.compiledScript = this.engine instanceof Compilable ? ((Compilable)((Object)this.engine)).compile(scriptContent) : null;
        context.getEventBus().addHandler(this.eventName, this.eventXMLNS, this);
    }

    public void unregister() {
        this.context.getEventBus().removeHandler(this.eventName, this.eventXMLNS, this);
    }
}

