/*
 * Decompiled with CFR 0.152.
 */
package tigase.db;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.DBInitException;
import tigase.db.TigaseDBException;
import tigase.db.UserExistsException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.xmpp.BareJID;

public class UserRepositoryMDImpl
implements UserRepository {
    private static final Logger log = Logger.getLogger(UserRepositoryMDImpl.class.getName());
    private UserRepository def = null;
    private ConcurrentSkipListMap<String, UserRepository> repos = new ConcurrentSkipListMap();

    @Override
    public void addDataList(BareJID user, String subnode, String key, String[] list) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = this.getRepo(user.getDomain());
        if (repo != null) {
            repo.addDataList(user, subnode, key, list);
        } else {
            log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        }
    }

    public void addRepo(String domain, UserRepository repo) {
        this.repos.put(domain, repo);
    }

    @Override
    public void addUser(BareJID user) throws UserExistsException, TigaseDBException {
        UserRepository repo = this.getRepo(user.getDomain());
        if (repo != null) {
            repo.addUser(user);
        } else {
            log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        }
    }

    @Override
    public String getData(BareJID user, String subnode, String key, String def) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = this.getRepo(user.getDomain());
        if (repo != null) {
            return repo.getData(user, subnode, key, def);
        }
        log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        return null;
    }

    @Override
    public String getData(BareJID user, String subnode, String key) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = this.getRepo(user.getDomain());
        if (repo != null) {
            return repo.getData(user, subnode, key);
        }
        log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        return null;
    }

    @Override
    public String getData(BareJID user, String key) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = this.getRepo(user.getDomain());
        if (repo != null) {
            return repo.getData(user, key);
        }
        log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        return null;
    }

    @Override
    public String[] getDataList(BareJID user, String subnode, String key) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = this.getRepo(user.getDomain());
        if (repo != null) {
            return repo.getDataList(user, subnode, key);
        }
        log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        return null;
    }

    @Override
    public String[] getKeys(BareJID user, String subnode) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = this.getRepo(user.getDomain());
        if (repo != null) {
            return repo.getKeys(user, subnode);
        }
        log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        return null;
    }

    @Override
    public String[] getKeys(BareJID user) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = this.getRepo(user.getDomain());
        if (repo != null) {
            return repo.getKeys(user);
        }
        log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        return null;
    }

    public UserRepository getRepo(String domain) {
        if (domain == null) {
            return this.def;
        }
        UserRepository result = this.repos.get(domain);
        if (result == null) {
            result = this.def;
        }
        return result;
    }

    @Override
    public String getResourceUri() {
        return this.def.getResourceUri();
    }

    @Override
    public String[] getSubnodes(BareJID user, String subnode) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = this.getRepo(user.getDomain());
        if (repo != null) {
            return repo.getSubnodes(user, subnode);
        }
        log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        return null;
    }

    @Override
    public String[] getSubnodes(BareJID user) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = this.getRepo(user.getDomain());
        if (repo != null) {
            repo.getSubnodes(user);
        } else {
            log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        }
        return null;
    }

    @Override
    public long getUserUID(BareJID user) throws TigaseDBException {
        UserRepository repo = this.getRepo(user.getDomain());
        if (repo != null) {
            return repo.getUserUID(user);
        }
        log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        return -1L;
    }

    @Override
    public List<BareJID> getUsers() throws TigaseDBException {
        ArrayList<BareJID> result = new ArrayList<BareJID>();
        for (UserRepository repo : this.repos.values()) {
            result.addAll(repo.getUsers());
        }
        return result;
    }

    @Override
    public long getUsersCount() {
        long result = 0L;
        for (UserRepository repo : this.repos.values()) {
            result += repo.getUsersCount();
        }
        return result;
    }

    @Override
    public long getUsersCount(String domain) {
        UserRepository repo = this.getRepo(domain);
        if (repo != null) {
            return repo.getUsersCount(domain);
        }
        log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + domain + ", not even default one!");
        return -1L;
    }

    @Override
    public void initRepository(String resource_uri, Map<String, String> params) throws DBInitException {
        log.info("Multi-domain repository pool initialized: " + resource_uri + ", params: " + params);
    }

    @Override
    public void removeData(BareJID user, String subnode, String key) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = this.getRepo(user.getDomain());
        if (repo != null) {
            repo.removeData(user, subnode, key);
        } else {
            log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        }
    }

    @Override
    public void removeData(BareJID user, String key) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = this.getRepo(user.getDomain());
        if (repo != null) {
            repo.removeData(user, key);
        } else {
            log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        }
    }

    public UserRepository removeRepo(String domain) {
        return this.repos.remove(domain);
    }

    @Override
    public void removeSubnode(BareJID user, String subnode) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = this.getRepo(user.getDomain());
        if (repo != null) {
            repo.removeSubnode(user, subnode);
        } else {
            log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        }
    }

    @Override
    public void removeUser(BareJID user) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = this.getRepo(user.getDomain());
        if (repo != null) {
            repo.removeUser(user);
        } else {
            log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        }
    }

    @Override
    public void setData(BareJID user, String subnode, String key, String value) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = this.getRepo(user.getDomain());
        if (repo != null) {
            repo.setData(user, subnode, key, value);
        } else {
            log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        }
    }

    @Override
    public void setData(BareJID user, String key, String value) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = this.getRepo(user.getDomain());
        if (repo != null) {
            repo.setData(user, key, value);
        } else {
            log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        }
    }

    @Override
    public void setDataList(BareJID user, String subnode, String key, String[] list) throws UserNotFoundException, TigaseDBException {
        UserRepository repo = this.getRepo(user.getDomain());
        if (repo != null) {
            repo.setDataList(user, subnode, key, list);
        } else {
            log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        }
    }

    public void setDefault(UserRepository repo) {
        this.def = repo;
    }

    @Override
    public boolean userExists(BareJID user) {
        UserRepository repo = this.getRepo(user.getDomain());
        if (repo != null) {
            return repo.userExists(user);
        }
        log.log(Level.WARNING, "Couldn't obtain user repository for domain: " + user.getDomain() + ", not even default one!");
        return false;
    }
}

