/*
 * Decompiled with CFR 0.152.
 */
package tigase.conf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.conf.ConfigXMLRepository;
import tigase.conf.Configurable;
import tigase.conf.ConfigurationException;
import tigase.conf.ConfiguratorAbstract;
import tigase.conf.MonitoringSetupIfc;
import tigase.disco.ServiceEntity;
import tigase.disco.ServiceIdentity;
import tigase.server.Command;
import tigase.server.ConnectionManager;
import tigase.server.Iq;
import tigase.server.MessageReceiver;
import tigase.server.Packet;
import tigase.server.Permissions;
import tigase.util.ClassUtil;
import tigase.xml.Element;
import tigase.xml.XMLUtils;
import tigase.xml.db.Types;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;

public class ConfiguratorOld
extends ConfiguratorAbstract {
    private static String key = null;
    private static final Logger log = Logger.getLogger("tigase.conf.Configurator");
    private static MonitoringSetupIfc monitoring = null;
    private static String value = null;
    private static boolean set = false;
    private static boolean print = false;
    private static boolean force = true;
    private static boolean add = false;
    private String config_file_name = null;
    private ServiceEntity config_list = null;
    private ServiceEntity config_set = null;
    private ConfigXMLRepository repository = null;
    private Map<String, Object> defProperties = new LinkedHashMap<String, Object>();
    private Map<String, Object> defConfigParams = new LinkedHashMap<String, Object>();
    private String routerCompName = null;
    private ServiceEntity serviceEntity = null;
    private boolean demoMode = false;

    @Override
    public void componentAdded(Configurable component) throws ConfigurationException {
        ServiceEntity item;
        super.componentAdded(component);
        if (log.isLoggable(Level.CONFIG)) {
            log.config(" component: " + component.getName());
        }
        if ((item = this.config_list.findNode(component.getName())) == null) {
            item = new ServiceEntity(this.getName(), component.getName(), "Component: " + component.getName());
            item.addFeatures(CMD_FEATURES);
            item.addIdentities(new ServiceIdentity("automation", "command-node", "Component: " + component.getName()));
            this.config_list.addItems(item);
        }
        if (this.config_set.findNode(component.getName()) == null) {
            this.config_set.addItems(item);
        }
        if (component.getClass().getName().equals("tigase.server.MessageRouter")) {
            this.routerCompName = component.getName();
        }
    }

    @Override
    public void init(String[] args) throws ConfigurationException {
        this.parseArgs(args);
        try {
            this.repository = ConfigXMLRepository.getConfigRepository(this.config_file_name);
        }
        catch (Exception e) {
            throw new ConfigurationException("Problem reading configuration repository", e);
        }
        this.defConfigParams.putAll(this.getAllProperties(null));
        Set<String> prop_keys = this.defProperties.keySet();
        for (String key : prop_keys) {
            int idx1 = key.indexOf("/");
            if (idx1 > 0) {
                String root = key.substring(0, idx1);
                String node = key.substring(idx1 + 1);
                String prop_key = null;
                int idx2 = node.lastIndexOf("/");
                if (idx2 > 0) {
                    prop_key = node.substring(idx2 + 1);
                    node = node.substring(0, idx2);
                } else {
                    prop_key = node;
                    node = null;
                }
                this.repository.set(root, node, prop_key, this.defProperties.get(key));
                log.config("Added default config property: (" + key + "=" + this.defProperties.get(key) + "), classname: " + this.defProperties.get(key).getClass().getName());
                continue;
            }
            log.warning("Ignoring default property, component part is missing: " + key);
        }
        this.initMonitoring((String)this.defConfigParams.get("--monitoring"), new File(this.config_file_name).getParent());
    }

    @Override
    public void initializationCompleted() {
        if (this.isInitializationComplete()) {
            return;
        }
        super.initializationCompleted();
        if (monitoring != null) {
            monitoring.initializationCompleted();
        }
    }

    public static void main(String[] args) throws Exception {
        force = false;
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-h")) {
                    System.out.print(ConfiguratorOld.help());
                    System.exit(0);
                }
                if (args[i].equals("-key")) {
                    key = args[++i];
                }
                if (args[i].equals("-value")) {
                    value = args[++i];
                }
                if (args[i].equals("-set")) {
                    set = true;
                }
                if (args[i].equals("-add")) {
                    add = true;
                }
                if (args[i].equals("-print")) {
                    print = true;
                }
                if (!args[i].equals("-f")) continue;
                force = true;
            }
        }
        ConfiguratorOld conf = new ConfiguratorOld();
        conf.init(args);
        if (set || add) {
            conf.setValue(key, value, add, true, null);
        }
        if (print) {
            Map<String, Object> allprop = conf.getAllProperties(key);
            for (Map.Entry<String, Object> entry : allprop.entrySet()) {
                ConfiguratorOld.print(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void parseArgs(String[] args) {
        String property_filename;
        this.defConfigParams.put("--test", Boolean.FALSE);
        this.defConfigParams.put("config-type", "--gen-config-default");
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                String key = null;
                Object val = null;
                if (args[i].equals("-c")) {
                    if (i + 1 == args.length) {
                        System.out.print(ConfiguratorOld.help());
                        System.exit(1);
                    } else {
                        this.config_file_name = args[++i];
                        continue;
                    }
                }
                if (args[i].startsWith("--gen-config")) {
                    key = "config-type";
                    val = args[i];
                }
                if (args[i].startsWith("--test")) {
                    key = args[i];
                    val = Boolean.TRUE;
                }
                if (args[i].equals("--user-db") || args[i].equals("--user-db-uri") || args[i].equals("--auth-db") || args[i].equals("--auth-db-uri") || args[i].startsWith("--comp-name") || args[i].startsWith("--comp-class") || args[i].startsWith("--ext-comp") || args[i].equals("--virt-hosts") || args[i].equals("--admins") || args[i].equals("--debug") || args[i].startsWith("--gen-") && !args[i].startsWith("--gen-config") || args[i].equals("--property-file") || args[i].equals("--cluster-mode")) {
                    key = args[i];
                    val = args[++i];
                }
                if (key == null) continue;
                this.defConfigParams.put(key, val);
                log.config("Setting defaults: " + key + "=" + val.toString());
            }
        }
        if ((property_filename = (String)this.defConfigParams.get("--property-file")) != null) {
            log.config("Loading initial properties from property file: " + property_filename);
            try {
                Properties defProps = new Properties();
                defProps.load(new FileReader(property_filename));
                Set<String> prop_keys = defProps.stringPropertyNames();
                for (String key : prop_keys) {
                    String value = defProps.getProperty(key).trim();
                    if (key.startsWith("--") || key.equals("config-type")) {
                        this.defConfigParams.put(key.trim(), value);
                        log.config("Added default config parameter: (" + key + "=" + value + ")");
                        continue;
                    }
                    Object[] val = value;
                    if (key.matches(".*\\[[LISBlisb]\\]$")) {
                        char c = key.charAt(key.length() - 2);
                        key = key.substring(0, key.length() - 3);
                        try {
                            switch (c) {
                                case 'L': {
                                    val = Long.decode(value);
                                    break;
                                }
                                case 'I': {
                                    val = Integer.decode(value);
                                    break;
                                }
                                case 'B': {
                                    val = Boolean.parseBoolean(value);
                                    log.config("Found Boolean property: " + val.toString());
                                    break;
                                }
                                case 's': {
                                    val = value.split(",");
                                    break;
                                }
                                case 'i': {
                                    String[] ints_str = value.split(",");
                                    int[] ints = new int[ints_str.length];
                                    int k = 0;
                                    for (String i : ints_str) {
                                        try {
                                            ints[k++] = Integer.parseInt(i);
                                        }
                                        catch (Exception e) {
                                            log.warning("Incorrect int array settins: " + i);
                                        }
                                    }
                                    val = ints;
                                    break;
                                }
                                case 'l': {
                                    String[] longs_str = value.split(",");
                                    long[] longs = new long[longs_str.length];
                                    int j = 0;
                                    for (String i : longs_str) {
                                        try {
                                            longs[j++] = Long.parseLong(i);
                                        }
                                        catch (Exception e) {
                                            log.warning("Incorrect long array settins: " + i);
                                        }
                                    }
                                    val = longs;
                                    break;
                                }
                            }
                        }
                        catch (Exception e) {
                            log.log(Level.CONFIG, "Incorrect parameter modifier", e);
                        }
                    }
                    this.defProperties.put(key.trim(), val);
                }
            }
            catch (FileNotFoundException e) {
                log.warning("Given property file was not found: " + property_filename);
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Can not read property file: " + property_filename, e);
            }
        }
    }

    @Override
    public void processPacket(Packet packet, Queue<Packet> results) {
        Command.Action action;
        if (!packet.isCommand()) {
            return;
        }
        Iq iqc = (Iq)packet;
        if (iqc.getType() != null && iqc.getType() == StanzaType.error) {
            log.info("Ignoring error packet: " + iqc.toString());
            return;
        }
        String nick = iqc.getTo().getLocalpart();
        if (nick == null || !this.getName().equals(nick)) {
            return;
        }
        String msg = "Please be careful, you are service admin and all changes you make are instantly applied to live system!";
        boolean admin = true;
        if (iqc.getPermissions() != Permissions.ADMIN) {
            if (this.demoMode) {
                admin = false;
                msg = "You are not admin. You can safely play with the settings as you can not change anything.";
                if (iqc.getStrCommand() != null && iqc.getStrCommand().endsWith("sess-man")) {
                    Packet result = iqc.commandResult(Command.DataType.result);
                    Command.addFieldValue(result, "Note", msg, "fixed");
                    Command.addFieldValue(result, "Note", "Restricted area, only admin can see these settings.", "fixed");
                    results.offer(result);
                    return;
                }
            } else {
                try {
                    results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You are not authorized for this action.", true));
                }
                catch (PacketErrorTypeException e) {
                    log.warning("Packet processing exception: " + e);
                }
                return;
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Command received: " + iqc.toString());
        }
        if ((action = Command.getAction(iqc)) == Command.Action.cancel) {
            Packet result = iqc.commandResult(null);
            results.offer(result);
            return;
        }
        switch (iqc.getCommand()) {
            case OTHER: {
                Packet result;
                String[] spl;
                if (iqc.getStrCommand() == null) break;
                if (iqc.getStrCommand().startsWith("config/list/")) {
                    try {
                        spl = iqc.getStrCommand().split("/");
                        result = iqc.commandResult(Command.DataType.result);
                        Command.addFieldValue(result, "Note", msg, "fixed");
                        Map<String, Object> allprop = this.getAllProperties(spl[2]);
                        for (Map.Entry<String, Object> entry : allprop.entrySet()) {
                            Command.addFieldValue(result, XMLUtils.escape(entry.getKey()), XMLUtils.escape(ConfiguratorOld.objectToString(entry.getValue())));
                        }
                        results.offer(result);
                    }
                    catch (ConfigurationException ex) {
                        Logger.getLogger(ConfiguratorOld.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                if (!iqc.getStrCommand().startsWith("config/set/")) break;
                try {
                    spl = iqc.getStrCommand().split("/");
                    result = iqc.commandResult(Command.DataType.result);
                    Command.addFieldValue(result, "Note", msg, "fixed");
                    if (Command.getData(packet) == null) {
                        this.prepareConfigData(result, spl[2]);
                        results.offer(result);
                        break;
                    }
                    this.updateConfigChanges(packet, result, spl[2], admin);
                    results.offer(result);
                }
                catch (ConfigurationException ex) {
                    Logger.getLogger(ConfiguratorOld.class.getName()).log(Level.SEVERE, null, ex);
                }
                break;
            }
        }
    }

    public static void putMXBean(String objName, Object bean) {
        if (monitoring != null) {
            monitoring.putMXBean(objName, bean);
        }
    }

    public void setup(String name) throws ConfigurationException {
        Configurable component = (Configurable)this.getComponent(name);
        this.setup(component);
    }

    public Map<String, Object> getAllProperties(String key) throws ConfigurationException {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        String[] comps = this.getComponents();
        if (comps != null) {
            for (String comp : comps) {
                Map<String, Object> prop = this.getProperties(comp);
                for (Map.Entry<String, Object> entry : prop.entrySet()) {
                    String entry_key = comp + "/" + entry.getKey();
                    if (key == null) {
                        result.put(entry_key, entry.getValue());
                        continue;
                    }
                    if (!entry_key.startsWith(key)) continue;
                    result.put(entry_key, entry.getValue());
                }
            }
        }
        return result;
    }

    public String[] getComponents() {
        return this.repository.getCompNames();
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> defaults = super.getDefaults(params);
        defaults.put("demo-mode", this.demoMode);
        return defaults;
    }

    @Override
    public Map<String, Object> getDefConfigParams() {
        return this.defConfigParams;
    }

    @Override
    public List<Element> getDiscoFeatures(JID from) {
        return null;
    }

    @Override
    public Element getDiscoInfo(String node, JID jid, JID from) {
        if (jid != null && this.getName().equals(jid.getLocalpart()) && this.isAdmin(from)) {
            return this.serviceEntity.getDiscoInfo(node);
        }
        return null;
    }

    @Override
    public List<Element> getDiscoItems(String node, JID jid, JID from) {
        if (this.isAdmin(from)) {
            if (this.getName().equals(jid.getLocalpart())) {
                return this.serviceEntity.getDiscoItems(node, jid.toString());
            }
            if (node == null) {
                return Arrays.asList(this.serviceEntity.getDiscoItem(null, BareJID.toString(this.getName(), jid.toString())));
            }
            return null;
        }
        return null;
    }

    public static Object getMXBean(String objName) {
        if (monitoring != null) {
            return monitoring.getMXBean(objName);
        }
        return null;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.serviceEntity = new ServiceEntity(name, "config", "Server configuration");
        this.serviceEntity.addIdentities(new ServiceIdentity("automation", "command-list", "Configuration commands"));
        this.serviceEntity.addFeatures(DEF_FEATURES);
        this.config_list = new ServiceEntity(name, "list", "List");
        this.config_list.addIdentities(new ServiceIdentity("automation", "command-list", "Config listings"));
        this.config_list.addFeatures(DEF_FEATURES);
        this.config_set = new ServiceEntity(name, "set", "Set");
        this.config_set.addIdentities(new ServiceIdentity("automation", "command-list", "Config settings"));
        this.config_set.addFeatures(DEF_FEATURES);
        ServiceEntity item = new ServiceEntity(this.getName(), "--none--", "Add new component...");
        item.addFeatures(CMD_FEATURES);
        item.addIdentities(new ServiceIdentity("automation", "command-node", "Add new component..."));
        this.config_set.addItems(item);
        this.serviceEntity.addItems(this.config_list, this.config_set);
    }

    @Override
    public void setProperties(Map<String, Object> props) throws ConfigurationException {
        super.setProperties(props);
        this.demoMode = (Boolean)props.get("demo-mode");
    }

    public Object setPropertyValue(String key, String val, Packet result_pack, boolean admin) {
        Object result = null;
        try {
            if (admin) {
                result = this.setValue(key, val, false, false, null);
            }
            if (result != null) {
                Command.addFieldValue(result_pack, XMLUtils.escape(key), XMLUtils.escape(val));
            } else {
                Command.addFieldValue(result_pack, "Note", "You can not set new properties yet, you can just modify existing ones.", "fixed");
            }
        }
        catch (Exception e) {
            Command.addFieldValue(result_pack, "Note", "Error setting property: " + e, "fixed");
        }
        return result;
    }

    public Object setValue(String node_key, String value, boolean add, boolean feedback, Map<String, Object> orig) throws Exception {
        int root_idx = node_key.indexOf(47);
        String root = root_idx > 0 ? node_key.substring(0, root_idx) : "";
        int key_idx = node_key.lastIndexOf(47);
        String key = key_idx > 0 ? node_key.substring(key_idx + 1) : node_key;
        String subnode = null;
        if (root_idx != key_idx) {
            subnode = node_key.substring(root_idx + 1, key_idx);
        }
        Object old_val = null;
        old_val = orig == null ? this.repository.get(root, subnode, key, null) : orig.get(node_key);
        if (old_val != null) {
            Object[] new_val = null;
            Types.DataType type = Types.DataType.valueof(old_val.getClass().getSimpleName());
            switch (type) {
                case INTEGER: {
                    new_val = Integer.decode(value);
                    break;
                }
                case INTEGER_ARR: {
                    if (add) {
                        int old_len = ((int[])old_val).length;
                        new_val = Arrays.copyOf((int[])old_val, old_len + 1);
                        ((int[])new_val)[old_len] = Integer.decode(value);
                        break;
                    }
                    String[] spl = value.split(",");
                    new_val = new int[spl.length];
                    for (int i = 0; i < spl.length; ++i) {
                        ((int[])new_val)[i] = Integer.decode(spl[i].trim());
                    }
                    break;
                }
                case LONG: {
                    new_val = Long.decode(value);
                    break;
                }
                case LONG_ARR: {
                    if (add) {
                        int old_len = ((long[])old_val).length;
                        new_val = Arrays.copyOf((long[])old_val, old_len + 1);
                        ((long[])new_val)[old_len] = Long.decode(value);
                        break;
                    }
                    String[] spl = value.split(",");
                    new_val = new long[spl.length];
                    for (int i = 0; i < spl.length; ++i) {
                        ((long[])new_val)[i] = Long.decode(spl[i].trim());
                    }
                    break;
                }
                case STRING: {
                    new_val = value;
                    break;
                }
                case STRING_ARR: {
                    if (add) {
                        int old_len = ((String[])old_val).length;
                        new_val = Arrays.copyOf((String[])old_val, old_len + 1);
                        new_val[old_len] = value;
                        break;
                    }
                    String[] spl = value.split(",");
                    new_val = new String[spl.length];
                    for (int i = 0; i < spl.length; ++i) {
                        new_val[i] = spl[i].trim();
                    }
                    break;
                }
                case DOUBLE: {
                    new_val = new Double(Double.parseDouble(value));
                    break;
                }
                case DOUBLE_ARR: {
                    if (add) {
                        int old_len = ((double[])old_val).length;
                        new_val = Arrays.copyOf((double[])old_val, old_len + 1);
                        ((double[])new_val)[old_len] = Double.parseDouble(value);
                        break;
                    }
                    String[] spl = value.split(",");
                    new_val = new double[spl.length];
                    for (int i = 0; i < spl.length; ++i) {
                        ((double[])new_val)[i] = Double.parseDouble(spl[i].trim());
                    }
                    break;
                }
                case BOOLEAN: {
                    new_val = this.parseBoolean(value);
                    break;
                }
                case BOOLEAN_ARR: {
                    if (add) {
                        int old_len = ((boolean[])old_val).length;
                        new_val = Arrays.copyOf((boolean[])old_val, old_len + 1);
                        ((boolean[])new_val)[old_len] = this.parseBoolean(value);
                        break;
                    }
                    String[] spl = value.split(",");
                    new_val = new boolean[spl.length];
                    for (int i = 0; i < spl.length; ++i) {
                        ((boolean[])new_val)[i] = this.parseBoolean(spl[i].trim());
                    }
                    break;
                }
                default: {
                    new_val = value;
                }
            }
            if (orig == null) {
                this.repository.set(root, subnode, key, new_val);
                this.repository.store();
            } else {
                orig.put(node_key, new_val);
            }
            return new_val;
        }
        if (force) {
            if (orig == null) {
                this.repository.set(root, subnode, key, value);
                this.repository.store();
            } else {
                orig.put(node_key, value);
            }
            if (feedback) {
                System.out.println("Forced to set new key=value: " + key + "=" + value);
            }
            return value;
        }
        if (feedback) {
            System.out.println("Error, given key does not exist in config yet.");
            System.out.println("You can only modify existing values, you can add new.");
            System.out.println("Use '-f' switch to force creation of the new property.");
        }
        return null;
    }

    private boolean checkComponentName(Packet result, String name) {
        String[] comp_names;
        String msg = name;
        if (msg != null) {
            Command.addFieldValue(result, "Info", "Note!! " + msg + ", please provide valid component name.", "fixed");
            this.newComponentCommand(result);
            return false;
        }
        for (String comp_name : comp_names = this.getComponents()) {
            if (!comp_name.equals(name)) continue;
            Command.addFieldValue(result, "Info", "Note!! Component with provided name already exists.", "fixed");
            Command.addFieldValue(result, "Info", "Please provide different component name.", "fixed");
            this.newComponentCommand(result);
            return false;
        }
        return true;
    }

    private void createNewComponent(Packet packet, Packet result, boolean admin) {
        String new_comp_name = Command.getFieldValue(packet, "Component name");
        String new_comp_class = Command.getFieldValue(packet, "Component class");
        try {
            MessageReceiver mr = (MessageReceiver)Class.forName(new_comp_class).newInstance();
            mr.setName(new_comp_name);
            if (mr instanceof Configurable) {
                Map<String, Object> comp_props = ((Configurable)((Object)mr)).getDefaults(this.defConfigParams);
                LinkedHashMap<String, Object> new_params = new LinkedHashMap<String, Object>(comp_props);
                for (Map.Entry<String, Object> entry : comp_props.entrySet()) {
                    String val = Command.getFieldValue(packet, XMLUtils.escape(entry.getKey()));
                    if (val == null) {
                        val = "";
                    }
                    val = XMLUtils.unescape(val);
                    log.info("New component value: " + entry.getKey() + "=" + val);
                    this.setValue(entry.getKey(), val, false, false, new_params);
                }
                if (admin) {
                    for (Map.Entry<String, Object> entry : new_params.entrySet()) {
                        String key = entry.getKey();
                        String subnode = null;
                        int key_idx = entry.getKey().lastIndexOf(47);
                        if (key_idx > 0) {
                            key = entry.getKey().substring(key_idx + 1);
                            subnode = entry.getKey().substring(0, key_idx);
                        }
                        log.info("Saving property to repository: root=" + new_comp_name + ", subnode=" + subnode + ", key=" + key + ", value=" + entry.getValue());
                        this.repository.set(new_comp_name, subnode, key, entry.getValue());
                    }
                    this.repository.set(this.routerCompName, "/components/msg-receivers", new_comp_name + ".class", new_comp_class);
                    this.repository.set(this.routerCompName, "/components/msg-receivers", new_comp_name + ".active", true);
                    this.setValue(this.routerCompName + "/components/msg-receivers/id-names", new_comp_name, true, false, null);
                    this.setup(this.routerCompName);
                }
            }
            Command.addNote(result, "New component created: " + new_comp_name);
            Command.addFieldValue(result, "Note", "New component created: " + new_comp_name, "fixed");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Problem instantiating component:", e);
            Command.addFieldValue(result, "Component class", "ERROR!! Problem instantiating component, look in log file for details...", "text-single", "Component class");
        }
    }

    private static String help() {
        return "\nParameters:\n -h             this help message\n -c file        configuration file\n -key key       node/key for the value to set\n -value value   value to set in configuration file\n -set           set given value for given key\n -add           add given value to the values list for given key\n -print         print content of all configuration settings or of given node/key\n -f             force creation of the new property - dangerous option...\nSamples:\n Setting admin account - overwriting any previous value(s)\n $ ./scripts/config.sh -c tigase-config.xml -print -set -key sess-man/admins -value admin1@localhost\n Adding next admin account leaving old value(s)\n $ ./scripts/config.sh -c tigase-config.xml -print -add -key sess-man/admins -value admin2@localhost\n\nNote: adding -print option is useful always, even with -set or -add\n      option as it prints set value afterwards.\n";
    }

    private void initMonitoring(String settings, String configDir) {
        if (monitoring == null && settings != null) {
            try {
                monitoring = (MonitoringSetupIfc)Class.forName("tigase.management.MonitoringSetup").newInstance();
                monitoring.initMonitoring(settings, configDir);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Can not initialize monitoring: ", e);
            }
        }
    }

    private void newComponentCommand(Packet result) {
        Command.addFieldValue(result, "Info", "Press:", "fixed");
        Command.addFieldValue(result, "Info", "'Next' to set all parameters for the new component.", "fixed");
        Command.setStatus(result, Command.Status.executing);
        Command.addAction(result, Command.Action.next);
        Command.addFieldValue(result, "Component name", "", "text-single", "Component name");
        try {
            Set<Class<MessageReceiver>> receiv_cls = ClassUtil.getClassesImplementing(MessageReceiver.class);
            String[] receiv_cls_names = new String[receiv_cls.size() - 1];
            String[] receiv_cls_simple = new String[receiv_cls.size() - 1];
            int idx = 0;
            for (Class<MessageReceiver> reciv : receiv_cls) {
                if (reciv.getName().equals("tigase.server.MessageRouter")) continue;
                receiv_cls_names[idx] = reciv.getName();
                receiv_cls_simple[idx++] = reciv.getSimpleName();
            }
            Command.addFieldValue(result, "Component class", "tigase.server.xmppcomponent.ComponentConnectionManager", "Component class", receiv_cls_simple, receiv_cls_names);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Problem loading MessageReceiver implementations", e);
            Command.addFieldValue(result, "Component class", "ERROR!! Problem loading MessageReceiver implementations, look in log file for details...", "text-single", "Component class");
        }
    }

    private void newComponentCommand(Packet packet, Packet result, boolean admin) {
        String params_set = Command.getFieldValue(packet, "Params set");
        if (Command.getAction(packet) != null && Command.getAction(packet).equals("prev")) {
            this.newComponentCommand(result);
            return;
        }
        if (params_set != null) {
            this.createNewComponent(packet, result, admin);
            return;
        }
        String new_comp_name = Command.getFieldValue(packet, "Component name");
        String new_comp_class = Command.getFieldValue(packet, "Component class");
        if (!this.checkComponentName(result, new_comp_name)) {
            return;
        }
        Command.setStatus(result, Command.Status.executing);
        Command.addFieldValue(result, "Component name", new_comp_name, "hidden");
        Command.addFieldValue(result, "Component class", new_comp_class, "hidden");
        Command.addFieldValue(result, "Info1", "Press:", "fixed");
        try {
            MessageReceiver mr = (MessageReceiver)Class.forName(new_comp_class).newInstance();
            Command.addFieldValue(result, "Info4", "Component name: " + new_comp_name + ", class: " + mr.getClass().getSimpleName(), "fixed");
            if (mr instanceof ConnectionManager) {
                String ports = Command.getFieldValue(packet, "TCP/IP ports");
                if (ports == null) {
                    Command.addFieldValue(result, "Info2", "1. 'Next' to set more component parameters.", "fixed");
                    Command.addFieldValue(result, "Info3", "2. 'Previous' to go back and select different component.", "fixed");
                    Command.addAction(result, Command.Action.next);
                    Command.addAction(result, Command.Action.prev);
                    Command.addFieldValue(result, "Info4", "This component uses TCP/IP ports, please provide port numbers:", "fixed");
                    Command.addFieldValue(result, "TCP/IP ports", "5557");
                    return;
                }
                String[] ports_arr = ports.split(",");
                int[] ports_i = new int[ports_arr.length];
                try {
                    for (int i = 0; i < ports_arr.length; ++i) {
                        ports_i[i] = Integer.decode(ports_arr[i].trim());
                    }
                    this.defConfigParams.put(new_comp_name + "/connections/ports", ports_i);
                }
                catch (Exception e) {
                    Command.addFieldValue(result, "Info2", "1. 'Next' to set more component parameters.", "fixed");
                    Command.addFieldValue(result, "Info3", "2. 'Previous' to go back and select different component.", "fixed");
                    Command.addAction(result, Command.Action.next);
                    Command.addAction(result, Command.Action.prev);
                    Command.addFieldValue(result, "Info4", "Incorrect TCP/IP ports provided, please provide port numbers:", "fixed");
                    Command.addFieldValue(result, "TCP/IP ports", ports);
                    return;
                }
            }
            Command.addFieldValue(result, "Info2", "1. 'Finish' to create component with this parameters.", "fixed");
            Command.addFieldValue(result, "Info3", "2. 'Previous' to go back and select different component.", "fixed");
            Command.addAction(result, Command.Action.complete);
            Command.addAction(result, Command.Action.prev);
            mr.setName(new_comp_name);
            if (mr instanceof Configurable) {
                TreeMap<String, Object> comp_props = new TreeMap<String, Object>(((Configurable)((Object)mr)).getDefaults(this.defConfigParams));
                for (Map.Entry entry : comp_props.entrySet()) {
                    Command.addFieldValue(result, XMLUtils.escape((String)entry.getKey()), XMLUtils.escape(ConfiguratorOld.objectToString(entry.getValue())));
                }
            } else {
                Command.addFieldValue(result, "Info6", "Component is not configurable, do you want to create it?", "fixed");
            }
            Command.addFieldValue(result, "Params set", "true", "hidden");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Problem instantiating component:", e);
            Command.addFieldValue(result, "Component class", "ERROR!! Problem instantiating component, look in log file for details...", "text-single", "Component class");
        }
    }

    private static String objectToString(Object value) {
        String val_str = null;
        Types.DataType type = Types.DataType.valueof(value.getClass().getSimpleName());
        try {
            StringBuilder sb = new StringBuilder();
            switch (type) {
                case STRING_ARR: {
                    for (String s : (String[])value) {
                        if (sb.length() == 0) {
                            sb.append(s);
                            continue;
                        }
                        sb.append(", ").append(s);
                    }
                    val_str = sb.toString();
                    break;
                }
                case INTEGER_ARR: {
                    for (int s : (int[])value) {
                        if (sb.length() == 0) {
                            sb.append(s);
                            continue;
                        }
                        sb.append(", ").append(s);
                    }
                    val_str = sb.toString();
                    break;
                }
                case LONG_ARR: {
                    for (long s : (long[])value) {
                        if (sb.length() == 0) {
                            sb.append(s);
                            continue;
                        }
                        sb.append(", ").append(s);
                    }
                    val_str = sb.toString();
                    break;
                }
                case DOUBLE_ARR: {
                    for (double s : (double[])value) {
                        if (sb.length() == 0) {
                            sb.append(s);
                            continue;
                        }
                        sb.append(", ").append(s);
                    }
                    val_str = sb.toString();
                    break;
                }
                case BOOLEAN_ARR: {
                    for (boolean s : (boolean[])value) {
                        if (sb.length() == 0) {
                            sb.append(s);
                            continue;
                        }
                        sb.append(", ").append(s);
                    }
                    val_str = sb.toString();
                    break;
                }
                default: {
                    val_str = value.toString();
                    break;
                }
            }
        }
        catch (ClassCastException e) {
            log.warning("ERROR! Problem with type casting for property: " + key);
        }
        return val_str;
    }

    private boolean parseBoolean(String val) {
        return val.equalsIgnoreCase("true") || val.equalsIgnoreCase("yes") || val.equalsIgnoreCase("on");
    }

    private void prepareConfigData(Packet result, String comp_name) throws ConfigurationException {
        if (comp_name.equals("--none--")) {
            this.newComponentCommand(result);
            return;
        }
        Command.setStatus(result, Command.Status.executing);
        Command.addAction(result, Command.Action.complete);
        TreeMap<String, Object> allprop = new TreeMap<String, Object>(this.getAllProperties(comp_name));
        for (Map.Entry entry : allprop.entrySet()) {
            Command.addFieldValue(result, XMLUtils.escape((String)entry.getKey()), XMLUtils.escape(ConfiguratorOld.objectToString(entry.getValue())));
        }
        Command.addFieldValue(result, XMLUtils.escape("new-prop-name"), XMLUtils.escape(comp_name + "/"), "text-single", "New property name");
        Command.addFieldValue(result, XMLUtils.escape("new-prop-value"), "", "text-single", "New property value");
    }

    private static void print(String key, Object value) {
        System.out.println(key + " = " + ConfiguratorOld.objectToString(value));
    }

    private void updateConfigChanges(Packet packet, Packet result, String comp_name, boolean admin) throws ConfigurationException {
        if (comp_name.equals("--none--")) {
            this.newComponentCommand(packet, result, admin);
            return;
        }
        Command.addNote(result, "You changed following settings:");
        Command.addFieldValue(result, "Note", "You changed following settings:", "fixed");
        Map<String, Object> allprop = this.getAllProperties(comp_name);
        boolean changed = false;
        for (Map.Entry<String, Object> entry : allprop.entrySet()) {
            String old_val;
            String tmp_val = Command.getFieldValue(packet, XMLUtils.escape(entry.getKey()));
            String new_val = old_val = ConfiguratorOld.objectToString(entry.getValue());
            if (tmp_val != null) {
                new_val = XMLUtils.unescape(tmp_val);
            }
            if (new_val == null || old_val == null || new_val.equals(old_val)) continue;
            this.defConfigParams.put(entry.getKey(), this.setPropertyValue(entry.getKey(), new_val, result, admin));
            changed = true;
        }
        String prop_value = Command.getFieldValue(packet, "new-prop-value");
        if (prop_value != null && prop_value.trim().length() > 0) {
            this.setPropertyValue(XMLUtils.unescape(Command.getFieldValue(packet, "new-prop-name")), XMLUtils.unescape(prop_value), result, admin);
            changed = true;
        }
        if (changed && admin) {
            this.setup(comp_name);
        }
    }
}

