/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.server.Command;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public class PacketTest {
    Packet packetInstance;

    @Before
    public void setUp() {
        JID from = JID.jidInstanceNS((String)"server");
        JID to = JID.jidInstanceNS((String)"user");
        Element property = new Element("property", new String[]{"name", "value", "xmlns"}, new String[]{"some name", "some value", "namespace"});
        Element iq = Command.createIqCommand((JID)from, (JID)to, (StanzaType)StanzaType.get, (String)"myId", (String)"node", (Command.DataType)Command.DataType.submit);
        iq.findChild(new String[]{"iq", "command", "x"}).addChild((XMLNodeIfc)property);
        this.packetInstance = Iq.packetInstance((Element)iq, (JID)from, (JID)to);
        this.packetInstance.getStanzaFrom().getDomain();
    }

    @Test
    public void testOkResult_String_int() {
        String includeXML = null;
        int depth = 5;
        Packet result = this.packetInstance.okResult(includeXML, depth);
        Element property = result.getElement().findChild(new String[]{"iq", "command", "x", "property"});
        Assert.assertEquals((Object)"some name", (Object)property.getAttributeStaticStr("name"));
        Assert.assertEquals((Object)"some value", (Object)property.getAttributeStaticStr("value"));
        Assert.assertEquals((Object)"namespace", (Object)property.getAttributeStaticStr("xmlns"));
        Assert.assertEquals(null, (Object)property.getAttributeStaticStr("unknown"));
        depth = 0;
        result = this.packetInstance.okResult(includeXML, depth);
        property = result.getElement().findChild(new String[]{"iq", "command", "x", "property"});
        Assert.assertEquals(null, (Object)property);
        depth = 1;
        result = this.packetInstance.okResult(includeXML, depth);
        property = result.getElement().findChild(new String[]{"iq", "command", "x"});
        Assert.assertEquals(null, (Object)property);
        property = result.getElement().findChild(new String[]{"iq", "command"});
        Assert.assertEquals((Object)"command", (Object)property.getName());
        Assert.assertEquals((Object)"http://jabber.org/protocol/commands", (Object)property.getAttributeStaticStr("xmlns"));
        Assert.assertEquals((Object)"node", (Object)property.getAttributeStaticStr("node"));
        Assert.assertEquals(null, (Object)property.getAttributeStaticStr("unknown"));
    }

    @Test
    public void testOkResult_Element_int() {
        Element includeXML = null;
        int depth = 5;
        Packet result = this.packetInstance.okResult(includeXML, depth);
        Element property = result.getElement().findChild(new String[]{"iq", "command", "x", "property"});
        Assert.assertEquals((Object)"some name", (Object)property.getAttributeStaticStr("name"));
        Assert.assertEquals((Object)"some value", (Object)property.getAttributeStaticStr("value"));
        Assert.assertEquals((Object)"namespace", (Object)property.getAttributeStaticStr("xmlns"));
        Assert.assertEquals(null, (Object)property.getAttributeStaticStr("unknown"));
        depth = 0;
        result = this.packetInstance.okResult(includeXML, depth);
        property = result.getElement().findChild(new String[]{"iq", "command", "x", "property"});
        Assert.assertEquals(null, (Object)property);
        depth = 1;
        result = this.packetInstance.okResult(includeXML, depth);
        property = result.getElement().findChild(new String[]{"iq", "command", "x"});
        Assert.assertEquals(null, (Object)property);
        property = result.getElement().findChild(new String[]{"iq", "command"});
        Assert.assertEquals((Object)"command", (Object)property.getName());
        Assert.assertEquals((Object)"http://jabber.org/protocol/commands", (Object)property.getAttributeStaticStr("xmlns"));
        Assert.assertEquals((Object)"node", (Object)property.getAttributeStaticStr("node"));
        Assert.assertEquals(null, (Object)property.getAttributeStaticStr("unknown"));
    }

    @Test
    public void testPacketSecure() throws TigaseStringprepException {
        JID jid1 = JID.jidInstance((String)"user1@example.com/res1");
        JID jid2 = JID.jidInstance((String)"user1@example.com/res2");
        Element iqEl = new Element("iq", new String[]{"from", "to", "xmlns", "type"}, new String[]{jid1.toString(), jid2.toString(), "jabber:client", "get"});
        iqEl.addChild((XMLNodeIfc)new Element("command", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/commands"}));
        Packet result = Packet.packetInstance((Element)iqEl);
        Command.addFieldValue((Packet)result, (String)"password", (String)"mySuperSecretPassword", (String)"text-private", (String)"The password for this account");
        Assert.assertTrue((String)"Output secured in default Element.toString()", (boolean)iqEl.toString().contains("mySuperSecretPassword"));
        Assert.assertFalse((String)"Plain output in Element.toStringSecure()", (boolean)iqEl.toStringSecure().contains("mySuperSecretPassword"));
        Assert.assertFalse((String)"Plain output in Packet.toString()", (boolean)result.toString().contains("mySuperSecretPassword"));
        Assert.assertFalse((String)"Plain output in Packet.toString(true)", (boolean)result.toString(true).contains("mySuperSecretPassword"));
        Assert.assertFalse((String)"Plain output in Packet.toStringSecure(true)", (boolean)result.toStringSecure().contains("mySuperSecretPassword"));
        Assert.assertTrue((String)"Output secured in default Packet.toStringFull()", (boolean)result.toStringFull().contains("mySuperSecretPassword"));
        Assert.assertTrue((String)"Output secured in default Packet.toString(false)", (boolean)result.toString(false).contains("mySuperSecretPassword"));
    }
}

