/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import tigase.conf.ConfigurationException;
import tigase.conf.ConfiguratorAbstract;
import tigase.disco.ServiceEntity;
import tigase.disco.ServiceIdentity;
import tigase.server.AbstractComponentRegistrator;
import tigase.server.Command;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.ServerComponent;
import tigase.stats.ErrorsStatisticsProvider;
import tigase.stats.StatRecord;
import tigase.stats.StatisticsArchivizerIfc;
import tigase.stats.StatisticsContainer;
import tigase.stats.StatisticsList;
import tigase.stats.StatisticsProvider;
import tigase.sys.ShutdownHook;
import tigase.sys.TigaseRuntime;
import tigase.util.ElementUtils;
import tigase.xml.Element;
import tigase.xml.XMLUtils;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public class StatisticsCollector
extends AbstractComponentRegistrator<StatisticsContainer>
implements ShutdownHook {
    public static final String ERRORS_STATISTICS_MBEAN_NAME = "tigase.stats:type=ErrorStatistics";
    public static final String STATISTICS_MBEAN_NAME = "tigase.stats:type=StatisticsProvider";
    public static final String STATS_ARCHIVIZERS = "--stats-archiv";
    public static final String STATS_ARCHIVIZERS_PROP_KEY = "stats-archiv";
    public static final String STATS_HISTORY = "--stats-history";
    public static final String STATS_HISTORY_SIZE_PROP_KEY = "stats-history-size";
    public static final int STATS_HISTORY_SIZE_PROP_VAL = 8640;
    public static final String STATS_UPDATE_INTERVAL_PROP_KEY = "stats-update-interval";
    public static final long STATS_UPDATE_INTERVAL_PROP_VAL = 10L;
    private static final String STATS_XMLNS = "http://jabber.org/protocol/stats";
    private static final Logger log = Logger.getLogger(StatisticsCollector.class.getName());
    private int historySize = 0;
    private TimerTask initializationCompletedTask = null;
    private ServiceEntity serviceEntity = null;
    private StatisticsProvider sp = null;
    private ErrorsStatisticsProvider esp = null;
    private final Map<String, StatisticsArchivizerIfc> archivizers = new ConcurrentSkipListMap<String, StatisticsArchivizerIfc>();
    private final ArchivizerRunner arch_runner = new ArchivizerRunner();
    private Level statsLevel = Level.INFO;
    private final Timer statsArchivTasks = new Timer("stats-archivizer-tasks", true);
    private long updateInterval = 10L;

    @Override
    public void componentAdded(StatisticsContainer component) {
        ServiceEntity item = this.serviceEntity.findNode(component.getName());
        if (item == null) {
            item = new ServiceEntity(this.getName(), component.getName(), "Component: " + component.getName());
            item.addFeatures(CMD_FEATURES);
            item.addIdentities(new ServiceIdentity("automation", "command-node", "Component: " + component.getName()));
            this.serviceEntity.addItems(item);
        }
    }

    @Override
    public void componentRemoved(StatisticsContainer component) {
    }

    @Override
    public void initializationCompleted() {
        if (this.isInitializationComplete()) {
            return;
        }
        super.initializationCompleted();
        try {
            this.sp = new StatisticsProvider(this, this.historySize, this.updateInterval);
            String objName = STATISTICS_MBEAN_NAME;
            ObjectName on = new ObjectName(objName);
            ManagementFactory.getPlatformMBeanServer().registerMBean(this.sp, on);
            ConfiguratorAbstract.putMXBean(objName, this.sp);
            this.esp = new ErrorsStatisticsProvider();
            objName = ERRORS_STATISTICS_MBEAN_NAME;
            on = new ObjectName(objName);
            ManagementFactory.getPlatformMBeanServer().registerMBean(this.esp, on);
            ConfiguratorAbstract.putMXBean(objName, this.esp);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Can not install Statistics MXBean: ", ex);
        }
        TigaseRuntime.getTigaseRuntime().addShutdownHook(this);
        if (this.initializationCompletedTask != null) {
            this.initializationCompletedTask.run();
        }
    }

    @Override
    public void processPacket(Packet packet, Queue<Packet> results) {
        Iq iqc;
        BareJID stanzaFromBare;
        JID stanzaFrom;
        if (!packet.isCommand() || packet.getType() == StanzaType.result) {
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "{0} command received: {1}", new Object[]{packet.getCommand().name(), packet});
        }
        if (!this.isAdmin(stanzaFrom = JID.jidInstance(stanzaFromBare = (iqc = (Iq)packet).getStanzaFrom().getBareJID()))) {
            Packet result = iqc.commandResult(Command.DataType.result);
            Command.addTextField(result, "Error", "You do not have enough permissions to manage this domain");
            results.offer(result);
            return;
        }
        switch (iqc.getCommand()) {
            case GETSTATS: {
                Element iq = ElementUtils.createIqQuery(iqc.getStanzaTo(), iqc.getStanzaFrom(), StanzaType.result, iqc.getStanzaId(), STATS_XMLNS);
                Element query = iq.getChild("query");
                StatisticsList stats = this.getAllStats();
                if (stats != null) {
                    for (StatRecord record : stats) {
                        Element item = new Element("stat");
                        item.addAttribute("name", record.getComponent() + "/" + record.getDescription());
                        item.addAttribute("value", record.getValue());
                        query.addChild(item);
                    }
                }
                Packet result = Packet.packetInstance(iq, iqc.getStanzaTo(), iqc.getStanzaFrom());
                results.offer(result);
                break;
            }
            case OTHER: {
                if (iqc.getStrCommand() == null) {
                    return;
                }
                String nick = iqc.getTo().getLocalpart();
                if (!this.getName().equals(nick)) {
                    return;
                }
                Command.Action action = Command.getAction(iqc);
                if (action == Command.Action.cancel) {
                    Packet result = iqc.commandResult(null);
                    results.offer(result);
                    return;
                }
                String tmp_val = Command.getFieldValue(iqc, "Stats level");
                Level statsLevel = this.statsLevel;
                if (tmp_val != null) {
                    statsLevel = Level.parse(tmp_val);
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "statsLevel parsed to: {0}", statsLevel.getName());
                    }
                }
                StatisticsList list = new StatisticsList(statsLevel);
                if (iqc.getStrCommand().equals("stats")) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Getting all stats for level: {0}", statsLevel.getName());
                    }
                    this.getAllStats(list);
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "All stats for level loaded: {0}", statsLevel.getName());
                    }
                } else {
                    String[] spl = iqc.getStrCommand().split("/");
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Getting stats for component: {0}, level: {1}", new Object[]{spl[1], statsLevel.getName()});
                    }
                    this.getComponentStats(spl[1], list);
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Stats loaded for component: {0}, level: {1}", new Object[]{spl[1], statsLevel.getName()});
                    }
                }
                Packet result = iqc.commandResult(Command.DataType.form);
                for (StatRecord rec : list) {
                    Command.addFieldValue(result, XMLUtils.escape(rec.getComponent() + "/" + rec.getDescription()), XMLUtils.escape(rec.getValue()));
                }
                Command.addFieldValue(result, "Stats level", statsLevel.getName(), "Stats level", new String[]{Level.INFO.getName(), Level.FINE.getName(), Level.FINER.getName(), Level.FINEST.getName()}, new String[]{Level.INFO.getName(), Level.FINE.getName(), Level.FINER.getName(), Level.FINEST.getName()});
                results.offer(result);
                if (!log.isLoggable(Level.FINEST)) break;
                log.log(Level.FINEST, "Returning stats result: {0}", result);
                break;
            }
        }
    }

    @Override
    public void release() {
        super.release();
        this.sp.stop();
        this.statsArchivTasks.cancel();
        for (String stat_arch_key : this.archivizers.keySet()) {
            StatisticsArchivizerIfc stat_arch = this.archivizers.remove(stat_arch_key);
            if (stat_arch == null) continue;
            stat_arch.release();
        }
    }

    @Override
    public String shutdown() {
        StatisticsList allStats = this.getAllStats();
        StringBuilder sb = new StringBuilder(4096);
        for (StatRecord statRecord : allStats) {
            sb.append(statRecord.toString()).append('\n');
        }
        return sb.toString();
    }

    public StatisticsList getAllStats() {
        StatisticsList list = new StatisticsList(Level.ALL);
        this.getAllStats(list);
        return list;
    }

    public void getAllStats(StatisticsList list) {
        for (StatisticsContainer comp : this.components.values()) {
            this.getComponentStats(comp.getName(), list);
        }
        int totalQueuesWait = 0;
        long totalQueuesOverflow = 0L;
        for (StatisticsContainer comp : this.components.values()) {
            totalQueuesWait += list.getValue(comp.getName(), "Total queues wait", 0);
            totalQueuesOverflow += list.getValue(comp.getName(), "Total queues overflow", 0L);
        }
        list.add("total", "Total queues wait", totalQueuesWait, Level.INFO);
        list.add("total", "Total queues overflow", totalQueuesOverflow, Level.INFO);
    }

    public List<String> getComponentsNames() {
        return new ArrayList<String>(this.components.keySet());
    }

    public void getComponentStats(String name, StatisticsList list) {
        StatisticsContainer stats = (StatisticsContainer)this.components.get(name);
        if (stats != null) {
            stats.getStatistics(list);
        }
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> defs = super.getDefaults(params);
        String statsArchivizers = (String)params.get(STATS_ARCHIVIZERS);
        if (statsArchivizers != null && !statsArchivizers.isEmpty()) {
            String[] archivs = statsArchivizers.split(",");
            defs.put(STATS_ARCHIVIZERS_PROP_KEY, archivs);
        }
        int hSize = this.historySize;
        long updateInt = this.updateInterval;
        String stats_history = (String)params.get(STATS_HISTORY);
        if (stats_history != null) {
            String[] st_pars = stats_history.split(",");
            try {
                hSize = Integer.parseInt(st_pars[0]);
            }
            catch (NumberFormatException ex) {
                log.log(Level.CONFIG, "Invalid statistics history size settings: {0}", st_pars[0]);
            }
            if (st_pars.length > 1) {
                try {
                    updateInt = Long.parseLong(st_pars[1]);
                }
                catch (NumberFormatException ex) {
                    log.log(Level.CONFIG, "Invalid statistics update interval: {0}", st_pars[1]);
                }
            }
        }
        defs.put(STATS_HISTORY_SIZE_PROP_KEY, hSize);
        defs.put(STATS_UPDATE_INTERVAL_PROP_KEY, updateInt);
        return defs;
    }

    @Override
    public List<Element> getDiscoFeatures(JID from) {
        return null;
    }

    @Override
    public Element getDiscoInfo(String node, JID jid, JID from) {
        if (jid != null && this.getName().equals(jid.getLocalpart()) && this.isAdmin(from)) {
            return this.serviceEntity.getDiscoInfo(node);
        }
        return null;
    }

    @Override
    public List<Element> getDiscoItems(String node, JID jid, JID from) {
        if (this.isAdmin(from)) {
            if (this.getName().equals(jid.getLocalpart()) || this.getComponentId().equals(jid)) {
                List<Element> items = this.serviceEntity.getDiscoItems(node, jid.toString());
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Processing discoItems for node: {0}, result: {1}", new Object[]{node, items == null ? null : items.toString()});
                }
                return items;
            }
            if (node == null) {
                Element item = this.serviceEntity.getDiscoItem(null, BareJID.toString(this.getName(), jid.toString()));
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Processing discoItems, result: {0}", item == null ? null : item.toString());
                }
                return Arrays.asList(item);
            }
            return null;
        }
        return null;
    }

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    public boolean isCorrectType(ServerComponent component) {
        return component instanceof StatisticsContainer;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.serviceEntity = new ServiceEntity(name, "stats", "Server statistics");
        this.serviceEntity.addIdentities(new ServiceIdentity("component", "stats", "Server statistics"), new ServiceIdentity("automation", "command-node", "All statistics"), new ServiceIdentity("automation", "command-list", "Statistics retrieving commands"));
        this.serviceEntity.addFeatures(DEF_FEATURES);
        this.serviceEntity.addFeatures(CMD_FEATURES);
    }

    @Override
    public void setProperties(Map<String, Object> props) throws ConfigurationException {
        super.setProperties(props);
        String[] archivs = (String[])props.get(STATS_ARCHIVIZERS_PROP_KEY);
        if (archivs != null) {
            this.initStatsArchivizers(archivs, props);
        }
        if (props.get(STATS_HISTORY_SIZE_PROP_KEY) != null) {
            this.historySize = (Integer)props.get(STATS_HISTORY_SIZE_PROP_KEY);
        }
        if (props.get(STATS_UPDATE_INTERVAL_PROP_KEY) != null) {
            this.updateInterval = (Long)props.get(STATS_UPDATE_INTERVAL_PROP_KEY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void statsUpdated() {
        ArchivizerRunner archivizerRunner = this.arch_runner;
        synchronized (archivizerRunner) {
            this.arch_runner.notifyAll();
        }
        this.esp.update(this.sp);
    }

    private void initStatsArchivizers(final String[] archivs, final Map<String, Object> props) {
        for (String stat_arch_key : this.archivizers.keySet()) {
            StatisticsArchivizerIfc stat_arch = this.archivizers.remove(stat_arch_key);
            if (stat_arch == null) continue;
            stat_arch.release();
        }
        this.initializationCompletedTask = new TimerTask(){

            @Override
            public void run() {
                for (String arch_prop : archivs) {
                    try {
                        String[] arch_prop_a = arch_prop.split(":");
                        String arch_class = arch_prop_a[0];
                        String arch_name = arch_prop_a[1];
                        final StatisticsArchivizerIfc stat_arch = (StatisticsArchivizerIfc)Class.forName(arch_class).newInstance();
                        stat_arch.init(StatisticsCollector.this.getArchivizerConf(arch_name, props));
                        long freq = -1L;
                        if (arch_prop_a.length > 2) {
                            try {
                                freq = Long.parseLong(arch_prop_a[2]);
                            }
                            catch (Exception e) {
                                freq = -1L;
                            }
                        }
                        if (freq > 0L) {
                            StatisticsCollector.this.statsArchivTasks.schedule(new TimerTask(){

                                @Override
                                public void run() {
                                    stat_arch.execute(StatisticsCollector.this.sp);
                                }
                            }, freq * 1000L, freq * 1000L);
                        } else {
                            StatisticsCollector.this.archivizers.put(arch_name, stat_arch);
                        }
                        log.log(Level.CONFIG, "Loaded statistics archivizer: {0} for class: {1}", new Object[]{arch_name, arch_class});
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "Can't initialize statistics archivizer: " + arch_prop, e);
                    }
                }
            }
        };
    }

    private Map<String, Object> getArchivizerConf(String name, Map<String, Object> props) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(4);
        String key_start = "stats-archiv/" + name + "/";
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            if (!entry.getKey().startsWith(key_start)) continue;
            String key = entry.getKey().substring(key_start.length());
            log.log(Level.CONFIG, "Found {0} property: {1} = {2}", new Object[]{name, key, entry.getValue()});
            result.put(key, entry.getValue());
        }
        return result;
    }

    private class ArchivizerRunner
    extends Thread {
        private boolean stopped;

        private ArchivizerRunner() {
            super("stats-archivizer");
            this.stopped = false;
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stopped) {
                try {
                    ArchivizerRunner archivizerRunner = this;
                    synchronized (archivizerRunner) {
                        this.wait();
                    }
                    for (Map.Entry entry : StatisticsCollector.this.archivizers.entrySet()) {
                        ((StatisticsArchivizerIfc)entry.getValue()).execute(StatisticsCollector.this.sp);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

