/*
 * Decompiled with CFR 0.152.
 */
package tigase.monitor.tasks;

import java.util.Date;
import java.util.HashSet;
import tigase.disteventbus.EventBus;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.monitor.InfoTask;
import tigase.monitor.MonitorComponent;
import tigase.monitor.tasks.AbstractConfigurableTimerTask;
import tigase.server.monitor.MonitorRuntime;
import tigase.util.DateTimeFormatter;
import tigase.xml.Element;

@Bean(name="memory-checker-task")
public class MemoryCheckerTask
extends AbstractConfigurableTimerTask
implements InfoTask {
    private static final DateTimeFormatter dtf = new DateTimeFormatter();
    public static final String HEAP_MEMORY_MONITOR_EVENT_NAME = "HeapMemoryMonitorEvent";
    public static final String NONHEAP_MEMORY_MONITOR_EVENT_NAME = "NonHeapMemoryMonitorEvent";
    @Inject
    private MonitorComponent component;
    @Inject
    private EventBus eventBus;
    private int maxHeapMemUsagePercentThreshold = 90;
    private int maxNonHeapMemUsagePercentThreshold = 90;
    @Inject
    private MonitorRuntime runtime;
    private final HashSet<String> triggeredEvents = new HashSet();

    @Override
    public Form getCurrentConfiguration() {
        Form form = super.getCurrentConfiguration();
        form.addField(Field.fieldTextSingle("maxHeapMemUsagePercentThreshold", String.valueOf(this.maxHeapMemUsagePercentThreshold), "Alarm when heap mem usage is bigger than [%]"));
        form.addField(Field.fieldTextSingle("maxNonHeapMemUsagePercentThreshold", String.valueOf(this.maxNonHeapMemUsagePercentThreshold), "Alarm when non-heap mem usage is bigger than [%]"));
        return form;
    }

    public int getMaxHeapMemUsagePercentThreshold() {
        return this.maxHeapMemUsagePercentThreshold;
    }

    public int getMaxNonHeapMemUsagePercentThreshold() {
        return this.maxNonHeapMemUsagePercentThreshold;
    }

    @Override
    public Form getTaskInfo() {
        Form result = new Form("", "Memory Information", "");
        result.addField(Field.fieldTextSingle("heapMemMax", Long.toString(this.runtime.getHeapMemMax()), "Heap Memory Max"));
        result.addField(Field.fieldTextSingle("heapMemUsed", Long.toString(this.runtime.getHeapMemUsed()), "Heap Memory Used"));
        result.addField(Field.fieldTextSingle("heapMemUsedPercentage", Float.toString(this.runtime.getHeapMemUsage()), "Heap Memory Used [%]"));
        result.addField(Field.fieldTextSingle("nonHeapMemMax", Long.toString(this.runtime.getNonHeapMemMax()), "Non-Heap Memory Max"));
        result.addField(Field.fieldTextSingle("nonHeapMemUsed", Long.toString(this.runtime.getNonHeapMemUsed()), "Non-Heap Memory Used"));
        result.addField(Field.fieldTextSingle("nonHeapMemUsedPercentage", Float.toString(this.runtime.getNonHeapMemUsage()), "Non-Heap Memory Used [%]"));
        result.addField(Field.fieldTextSingle("directMemUsed", Long.toString(this.runtime.getDirectMemUsed()), "Direct Memory Used"));
        return result;
    }

    @Override
    protected void run() {
        float curHeapMemUsagePercent = this.runtime.getHeapMemUsage();
        if (curHeapMemUsagePercent >= (float)this.maxHeapMemUsagePercentThreshold) {
            Element event = new Element(HEAP_MEMORY_MONITOR_EVENT_NAME, new String[]{"xmlns"}, new String[]{"tigase:monitor:event"});
            event.addChild(new Element("hostname", this.component.getDefHostName().toString()));
            event.addChild(new Element("timestamp", "" + dtf.formatDateTime(new Date())));
            event.addChild(new Element("heapMemUsage", Float.toString(curHeapMemUsagePercent)));
            event.addChild(new Element("heapMemMax", Long.toString(this.runtime.getHeapMemMax())));
            event.addChild(new Element("heapMemUsed", Long.toString(this.runtime.getHeapMemUsed())));
            event.addChild(new Element("nonHeapMemMax", Long.toString(this.runtime.getNonHeapMemMax())));
            event.addChild(new Element("nonHeapMemUsed", Long.toString(this.runtime.getNonHeapMemUsed())));
            event.addChild(new Element("directMemUsed", Long.toString(this.runtime.getDirectMemUsed())));
            event.addChild(new Element("message", "Heap memory usage is higher than " + this.maxHeapMemUsagePercentThreshold + " and it equals " + curHeapMemUsagePercent));
            if (!this.triggeredEvents.contains(event.getName())) {
                this.eventBus.fire(event);
                this.triggeredEvents.add(event.getName());
            }
        } else {
            this.triggeredEvents.remove(HEAP_MEMORY_MONITOR_EVENT_NAME);
        }
        float curNonHeapMemUsagePercent = this.runtime.getNonHeapMemUsage();
        if (curNonHeapMemUsagePercent >= (float)this.maxNonHeapMemUsagePercentThreshold) {
            Element event = new Element(NONHEAP_MEMORY_MONITOR_EVENT_NAME, new String[]{"xmlns"}, new String[]{"tigase:monitor:event"});
            event.addChild(new Element("hostname", this.component.getDefHostName().toString()));
            event.addChild(new Element("timestamp", "" + dtf.formatDateTime(new Date())));
            event.addChild(new Element("nonHeapMemUsage", Float.toString(curNonHeapMemUsagePercent)));
            event.addChild(new Element("heapMemMax", Long.toString(this.runtime.getHeapMemMax())));
            event.addChild(new Element("heapMemUsed", Long.toString(this.runtime.getHeapMemUsed())));
            event.addChild(new Element("nonHeapMemMax", Long.toString(this.runtime.getNonHeapMemMax())));
            event.addChild(new Element("nonHeapMemUsed", Long.toString(this.runtime.getNonHeapMemUsed())));
            event.addChild(new Element("directMemUsed", Long.toString(this.runtime.getDirectMemUsed())));
            event.addChild(new Element("message", "Non-Heap memory usage is higher than " + this.maxNonHeapMemUsagePercentThreshold + " and it equals " + curHeapMemUsagePercent));
            if (!this.triggeredEvents.contains(event.getName())) {
                this.eventBus.fire(event);
                this.triggeredEvents.add(event.getName());
            }
        } else {
            this.triggeredEvents.remove(NONHEAP_MEMORY_MONITOR_EVENT_NAME);
        }
    }

    public void setMaxHeapMemUsagePercentThreshold(Integer maxHeapMemUsagePercentThreshold) {
        this.maxHeapMemUsagePercentThreshold = maxHeapMemUsagePercentThreshold;
    }

    public void setMaxNonHeapMemUsagePercentThreshold(Integer maxNonHeapMemUsagePercentThreshold) {
        this.maxNonHeapMemUsagePercentThreshold = maxNonHeapMemUsagePercentThreshold;
    }

    @Override
    public void setNewConfiguration(Form form) {
        Field nonHeapMemUsage;
        Field heapMemUsage = form.get("maxHeapMemUsagePercentThreshold");
        if (heapMemUsage != null) {
            this.maxHeapMemUsagePercentThreshold = Integer.parseInt(heapMemUsage.getValue());
        }
        if ((nonHeapMemUsage = form.get("maxNonHeapMemUsagePercentThreshold")) != null) {
            this.maxNonHeapMemUsagePercentThreshold = Integer.parseInt(nonHeapMemUsage.getValue());
        }
        super.setNewConfiguration(form);
    }
}

