/*
 * Decompiled with CFR 0.152.
 */
package tigase.monitor.modules;

import tigase.component.adhoc.AdHocCommand;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocCommandManager;
import tigase.component.exceptions.ComponentException;
import tigase.component.modules.impl.AdHocCommandModule;
import tigase.monitor.MonitorContext;
import tigase.monitor.modules.ConfigureTaskCommand;
import tigase.monitor.modules.InfoTaskCommand;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.JID;

public class AdHocCommandMonitorModule
extends AdHocCommandModule<MonitorContext> {
    private ConfigureTaskCommand configCommand;
    private final AdHocCommandManager customCommandsManager = new AdHocCommandManager();
    private InfoTaskCommand infoCommand;

    public AdHocCommandMonitorModule(AdHocCommandModule.ScriptCommandProcessor scriptProcessor) {
        super(scriptProcessor);
    }

    @Override
    public void afterRegistration() {
        super.afterRegistration();
        this.infoCommand = new InfoTaskCommand((MonitorContext)this.context);
        this.configCommand = new ConfigureTaskCommand((MonitorContext)this.context);
    }

    private AdHocCommand getCommand(Object taskInstance, String node) {
        if (node.equals("x-info")) {
            return this.infoCommand;
        }
        if (node.equals("x-config")) {
            return this.configCommand;
        }
        return null;
    }

    @Override
    public void process(Packet packet) throws ComponentException {
        Object taskInstance;
        JID jid = packet.getStanzaTo();
        Object v0 = taskInstance = jid.getResource() != null ? ((MonitorContext)this.context).getKernel().getInstance(jid.getResource()) : null;
        if (jid.getResource() != null && taskInstance != null) {
            this.processCommand(packet, taskInstance);
        } else {
            if (jid.getResource() != null) {
                throw new ComponentException(Authorization.ITEM_NOT_FOUND);
            }
            if (jid.getResource() == null) {
                super.process(packet);
            } else {
                throw new ComponentException(Authorization.NOT_ACCEPTABLE);
            }
        }
    }

    private void processCommand(Packet packet, Object taskInstance) throws ComponentException {
        Element element = packet.getElement();
        JID senderJid = packet.getStanzaFrom();
        Element command2 = element.getChild("command", "http://jabber.org/protocol/commands");
        String node = command2.getAttributeStaticStr("node");
        String action = command2.getAttributeStaticStr("action");
        String sessionId = command2.getAttributeStaticStr("sessionid");
        AdHocCommand adHocCommand = this.getCommand(taskInstance, node);
        try {
            this.write(this.customCommandsManager.process(packet, command2, node, action, sessionId, adHocCommand));
        }
        catch (AdHocCommandException e) {
            throw new ComponentException(e.getErrorCondition(), e.getMessage());
        }
    }
}

