/*
 * Decompiled with CFR 0.152.
 */
package tigase.kernel.core;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.kernel.beans.Inject;
import tigase.kernel.core.BeanConfig;
import tigase.kernel.core.Dependency;
import tigase.kernel.core.Kernel;

public class DependencyManager {
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    private final Map<String, BeanConfig> beanConfigs = new HashMap<String, BeanConfig>();
    private DependencyManager parent;
    private boolean throwExceptionIfCannotCreate = false;

    public static Field[] getAllFields(Class<?> klass) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(Arrays.asList(klass.getDeclaredFields()));
        if (klass.getSuperclass() != null) {
            fields.addAll(Arrays.asList(DependencyManager.getAllFields(klass.getSuperclass())));
        }
        return fields.toArray(new Field[0]);
    }

    public static boolean match(Dependency dependency, BeanConfig beanConfig) {
        if (dependency.getBeanName() != null) {
            return beanConfig.getBeanName().equals(dependency.getBeanName());
        }
        if (dependency.getType() != null) {
            return dependency.getType().isAssignableFrom(beanConfig.getClazz());
        }
        throw new RuntimeException("Unsupported dependecy type.");
    }

    protected BeanConfig createBeanConfig(Kernel kernel, String beanName, Class<?> beanClass) {
        try {
            BeanConfig result = new BeanConfig(beanName, beanClass);
            result.setKernel(kernel);
            this.prepareDependencies(result);
            return result;
        }
        catch (NoClassDefFoundError e) {
            this.log.log(Level.WARNING, "Cannot create bean config '" + beanName + "', type=" + beanClass.getName() + ". Bean requires unknown class " + e.getMessage());
            if (this.throwExceptionIfCannotCreate) {
                throw e;
            }
            return null;
        }
    }

    private Map<Field, Inject> createFieldsDependencyList(Class<?> cls) {
        HashMap<Field, Inject> deps = new HashMap<Field, Inject>();
        for (Field field : DependencyManager.getAllFields(cls)) {
            Inject injectAnnotation = field.getAnnotation(Inject.class);
            if (injectAnnotation == null) continue;
            deps.put(field, injectAnnotation);
        }
        return deps;
    }

    public BeanConfig[] getBeanConfig(Dependency dependency) {
        ArrayList<BeanConfig> bcs = new ArrayList<BeanConfig>();
        if (this.parent != null && this.parent != this) {
            BeanConfig[] pds;
            for (BeanConfig beanConfig : pds = this.parent.getBeanConfig(dependency)) {
                if (beanConfig == null || !beanConfig.isExportable()) continue;
                bcs.add(beanConfig);
            }
        }
        if (dependency.getBeanName() != null) {
            BeanConfig b = this.beanConfigs.get(dependency.getBeanName());
            if (b != null) {
                bcs.add(b);
            }
            if (bcs.isEmpty()) {
                bcs.add(null);
            }
        } else if (dependency.getType() != null) {
            bcs.addAll(this.getBeanConfigs(dependency.getType()));
        } else {
            throw new RuntimeException("Unsupported dependecy type.");
        }
        return bcs.toArray(new BeanConfig[0]);
    }

    public BeanConfig getBeanConfig(String beanName) {
        return this.beanConfigs.get(beanName);
    }

    public Collection<BeanConfig> getBeanConfigs() {
        return Collections.unmodifiableCollection(this.beanConfigs.values());
    }

    public List<BeanConfig> getBeanConfigs(Class<?> type) {
        return this.getBeanConfigs(type, true);
    }

    public List<BeanConfig> getBeanConfigs(Class<?> type, boolean allowNonExportable) {
        ArrayList<BeanConfig> result = new ArrayList<BeanConfig>();
        for (BeanConfig bc : this.beanConfigs.values()) {
            if (!type.isAssignableFrom(bc.getClazz()) || !allowNonExportable && !bc.isExportable()) continue;
            result.add(bc);
        }
        return result;
    }

    public Collection<Dependency> getDependenciesTo(BeanConfig destination) {
        HashSet<Dependency> result = new HashSet<Dependency>();
        for (BeanConfig candidate : this.beanConfigs.values()) {
            for (Dependency dp : candidate.getFieldDependencies().values()) {
                List<BeanConfig> bcs = Arrays.asList(this.getBeanConfig(dp));
                if (!bcs.contains(destination)) continue;
                result.add(dp);
            }
        }
        return result;
    }

    public HashSet<BeanConfig> getDependentBeans(BeanConfig beanConfig) {
        HashSet<BeanConfig> result = new HashSet<BeanConfig>();
        for (BeanConfig candidate : this.beanConfigs.values()) {
            for (Dependency dp : candidate.getFieldDependencies().values()) {
                List<BeanConfig> bcs = Arrays.asList(this.getBeanConfig(dp));
                if (!bcs.contains(beanConfig)) continue;
                result.add(candidate);
            }
        }
        return result;
    }

    DependencyManager getParent() {
        return this.parent;
    }

    void setParent(DependencyManager parent) {
        this.parent = parent;
    }

    public boolean isBeanClassRegistered(String beanName) {
        return this.beanConfigs.containsKey(beanName);
    }

    public boolean isThrowExceptionIfCannotCreate() {
        return this.throwExceptionIfCannotCreate;
    }

    public void setThrowExceptionIfCannotCreate(boolean throwExceptionIfCannotCreate) {
        this.throwExceptionIfCannotCreate = throwExceptionIfCannotCreate;
    }

    protected void prepareDependencies(BeanConfig beanConfig) {
        String id = beanConfig.getBeanName();
        Class<?> cls = beanConfig.getClazz();
        Map<Field, Inject> deps = this.createFieldsDependencyList(cls);
        for (Map.Entry<Field, Inject> e : deps.entrySet()) {
            Dependency d = new Dependency(beanConfig);
            d.setField(e.getKey());
            d.setNullAllowed(e.getValue().nullAllowed());
            if (!e.getValue().bean().isEmpty()) {
                d.setBeanName(e.getValue().bean());
            } else if (e.getValue().type() != Inject.EMPTY.class) {
                d.setType(e.getValue().type());
            } else if (e.getKey().getType().isArray()) {
                d.setType(e.getKey().getType().getComponentType());
            } else {
                d.setType(e.getKey().getType());
            }
            beanConfig.getFieldDependencies().put(e.getKey(), d);
        }
    }

    void register(BeanConfig factoryBeanConfig) {
        this.beanConfigs.put(factoryBeanConfig.getBeanName(), factoryBeanConfig);
        factoryBeanConfig.setState(BeanConfig.State.registered);
    }

    public BeanConfig unregister(String beanName) {
        return this.beanConfigs.remove(beanName);
    }
}

