/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster;

import java.util.List;
import java.util.Map;
import tigase.cluster.ClusterConnection;
import tigase.cluster.api.ClusterConnectionHandler;
import tigase.cluster.api.ClusterConnectionSelectorIfc;
import tigase.server.Packet;
import tigase.server.Priority;
import tigase.xmpp.XMPPIOService;

public class ClusterConnectionSelector
implements ClusterConnectionSelectorIfc {
    protected static final String CLUSTER_SYS_CONNECTIONS_PER_NODE_PROP_KEY = "cluster-sys-connections-per-node";
    private int allConns = 5;
    private int sysConns = 2;
    private ClusterConnectionHandler handler;

    @Override
    public XMPPIOService<Object> selectConnection(Packet p, ClusterConnection conn) {
        if (conn == null) {
            return null;
        }
        int code = Math.abs(this.handler.hashCodeForPacket(p));
        List<XMPPIOService<Object>> conns = conn.getConnections();
        if (conns.size() > 0) {
            if (conns.size() > this.sysConns) {
                if (p.getPriority() != null && p.getPriority().ordinal() <= Priority.CLUSTER.ordinal()) {
                    return conns.get(code % this.sysConns);
                }
                return conns.get(this.sysConns + code % (conns.size() - this.sysConns));
            }
            return conns.get(code % conns.size());
        }
        return null;
    }

    @Override
    public void setClusterConnectionHandler(ClusterConnectionHandler handler) {
        this.handler = handler;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        if (props.containsKey(CLUSTER_SYS_CONNECTIONS_PER_NODE_PROP_KEY)) {
            this.sysConns = (Integer)props.get(CLUSTER_SYS_CONNECTIONS_PER_NODE_PROP_KEY);
        }
        if (props.containsKey("cluster-connections-per-node")) {
            this.allConns = (Integer)props.get("cluster-connections-per-node");
        }
    }
}

