/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster;

import java.util.ArrayList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterCommandException;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.ClusteredComponentIfc;
import tigase.cluster.api.CommandListener;
import tigase.cluster.api.CommandListenerAbstract;
import tigase.server.Packet;
import tigase.server.Priority;
import tigase.server.amp.AmpComponent;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.JID;

public class AmpComponentClustered
extends AmpComponent
implements ClusteredComponentIfc {
    private static final Logger log = Logger.getLogger(AmpComponentClustered.class.getCanonicalName());
    private ClusterControllerIfc controller = null;
    private Set<CommandListener> commandListeners = new CopyOnWriteArraySet<CommandListener>();

    public AmpComponentClustered() {
        this.commandListeners.add(new PacketForwardCommand("packet-forward"));
    }

    protected void forwardPacket(Packet packet) {
        ArrayList<JID> toNodes = new ArrayList<JID>();
        for (JID jid : this.getNodesConnected()) {
            if (jid.equals(this.getComponentId())) continue;
            toNodes.add(jid);
        }
        if (!toNodes.isEmpty()) {
            this.controller.sendToNodes("packet-forward", null, packet.getElement(), this.getComponentId(), null, toNodes.toArray(new JID[toNodes.size()]));
        }
    }

    @Override
    public void processPacket(Packet packet) {
        if ((packet.getPacketFrom() == null || this.getComponentId().getDomain().equals(packet.getPacketFrom().getDomain())) && packet.getElemName() == "message" && packet.getElement().getChild("broadcast", "http://tigase.org/protocol/broadcast") != null && packet.getAttributeStaticStr("from-conn-id") == null) {
            this.forwardPacket(packet.copyElementOnly());
        }
        super.processPacket(packet);
    }

    @Override
    public void setClusterController(ClusterControllerIfc cl_controller) {
        super.setClusterController(cl_controller);
        if (this.controller != null) {
            for (CommandListener listener : this.commandListeners) {
                this.controller.removeCommandListener(listener);
            }
        }
        this.controller = cl_controller;
        if (this.controller != null) {
            for (CommandListener listener : this.commandListeners) {
                this.controller.setCommandListener(listener);
            }
        }
    }

    protected class PacketForwardCommand
    extends CommandListenerAbstract {
        public PacketForwardCommand(String name) {
            super(name, Priority.HIGH);
        }

        @Override
        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            Element packetEl = null;
            while ((packetEl = packets.poll()) != null) {
                try {
                    Packet packet = Packet.packetInstance(packetEl);
                    packet.setPacketFrom(fromNode);
                    packet.setPacketTo(AmpComponentClustered.this.getComponentId());
                    AmpComponentClustered.this.addPacket(packet);
                }
                catch (TigaseStringprepException ex) {
                    log.log(Level.WARNING, "exception converting element to packet after forwarding from other node", ex);
                }
            }
        }
    }
}

